/*
 * Decompiled with CFR 0.152.
 */
package erebus.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModMaterials;
import erebus.ModTabs;
import erebus.client.model.armor.ModelArmorGlider;
import erebus.client.model.armor.ModelArmorPowered;
import erebus.core.handler.KeyBindingHandler;
import erebus.item.ItemMaterials;
import erebus.network.PacketPipeline;
import erebus.network.server.PacketGlider;
import erebus.network.server.PacketGliderPowered;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ItemArmorGlider
extends ItemArmor {
    public ItemArmorGlider() {
        super(ModMaterials.armorREINEXOSPECIAL, 2, 1);
        this.func_77637_a(ModTabs.gears);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        if (this.canFly()) {
            list.add(StatCollector.func_74838_a((String)"tooltip.erebus.poweredGlider"));
            list.add(StatCollector.func_74838_a((String)"tooltip.erebus.gliderPoweredKey") + ": " + Keyboard.getKeyName((int)KeyBindingHandler.poweredGlide.func_151463_i()));
        }
        list.add(StatCollector.func_74838_a((String)"tooltip.erebus.gliderGlideKey") + ": " + Keyboard.getKeyName((int)KeyBindingHandler.glide.func_151463_i()));
    }

    public boolean func_82816_b_(ItemStack stack) {
        return !stack.func_77942_o() ? false : (!stack.func_77978_p().func_150297_b("display", 10) ? false : stack.func_77978_p().func_74775_l("display").func_150297_b("color", 3));
    }

    public int func_82814_b(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return 0xFFFFFF;
        }
        NBTTagCompound displayNBT = nbt.func_74775_l("display");
        return displayNBT == null ? 0xFFFFFF : (displayNBT.func_150297_b("color", 3) ? displayNBT.func_74762_e("color") : 0xFFFFFF);
    }

    public void func_82815_c(ItemStack stack) {
        NBTTagCompound displayNBT;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && (displayNBT = nbt.func_74775_l("display")).func_74764_b("color")) {
            displayNBT.func_82580_o("color");
        }
    }

    public void func_82813_b(ItemStack stack, int colour) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        NBTTagCompound displayNBT = nbt.func_74775_l("display");
        if (!nbt.func_150297_b("display", 10)) {
            nbt.func_74782_a("display", (NBTBase)displayNBT);
        }
        displayNBT.func_74768_a("color", colour);
    }

    public boolean func_82789_a(ItemStack armour, ItemStack material) {
        return material.func_77973_b() == ModItems.materials && material.func_77960_j() == ItemMaterials.DATA.GLIDER_WING.ordinal();
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack is, Entity entity, int slot, String type) {
        return "erebus:textures/models/armor/glider.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase player, ItemStack stack, int slot) {
        if (this.canFly()) {
            ModelArmorPowered model = new ModelArmorPowered();
            model.field_78116_c.field_78806_j = false;
            model.field_78114_d.field_78806_j = false;
            model.field_78115_e.field_78806_j = false;
            model.field_78112_f.field_78806_j = false;
            model.field_78113_g.field_78806_j = false;
            model.field_78123_h.field_78806_j = false;
            model.field_78124_i.field_78806_j = false;
            if (stack.func_77942_o()) {
                model.isGliding = stack.func_77978_p().func_74767_n("isGliding");
                model.isPowered = stack.func_77978_p().func_74767_n("isPowered");
            }
            return model;
        }
        ModelArmorGlider model = new ModelArmorGlider();
        model.field_78116_c.field_78806_j = false;
        model.field_78114_d.field_78806_j = false;
        model.field_78115_e.field_78806_j = false;
        model.field_78112_f.field_78806_j = false;
        model.field_78113_g.field_78806_j = false;
        model.field_78123_h.field_78806_j = false;
        model.field_78124_i.field_78806_j = false;
        if (stack.func_77942_o()) {
            model.isGliding = stack.func_77978_p().func_74767_n("isGliding");
        }
        return model;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K) {
            if (!stack.func_77942_o()) {
                stack.field_77990_d = new NBTTagCompound();
            }
            if (stack.func_77978_p().func_74767_n("isGliding") && (!KeyBindingHandler.glide.func_151470_d() || entity.field_70122_E)) {
                stack.func_77978_p().func_74757_a("isGliding", false);
                PacketPipeline.sendToServer(new PacketGlider(false));
            }
            if (this.canFly() && stack.func_77978_p().func_74767_n("isPowered") && (!KeyBindingHandler.poweredGlide.func_151470_d() || entity.field_70122_E)) {
                stack.func_77978_p().func_74757_a("isPowered", false);
                PacketPipeline.sendToServer(new PacketGliderPowered(false));
            }
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        this.func_77663_a(stack, world, (Entity)player, 0, false);
        player.field_70143_R = 0.0f;
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt.func_74767_n("isGliding") && !player.field_70122_E) {
            player.field_70159_w *= 1.05;
            player.field_70179_y *= 1.05;
            player.field_70181_x *= 0.5;
        }
        if (nbt.func_74767_n("isPowered") && this.canFly() && this.hasGemOrIsCreative(player) && !player.field_70122_E) {
            player.field_70159_w *= 1.05;
            player.field_70179_y *= 1.05;
            player.field_70181_x += 0.1;
            if (!player.field_71075_bZ.field_75098_d) {
                nbt.func_74768_a("fuelTicks", nbt.func_74762_e("fuelTicks") + 1);
                if (nbt.func_74762_e("fuelTicks") >= 80) {
                    nbt.func_74768_a("fuelTicks", 0);
                    player.field_71071_by.func_146026_a(Item.func_150898_a((Block)ModBlocks.redGem));
                }
            }
        }
    }

    private boolean hasGemOrIsCreative(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146028_b(Item.func_150898_a((Block)ModBlocks.redGem));
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74757_a("isGliding", false);
        stack.field_77990_d.func_74757_a("isPowered", false);
        stack.field_77990_d.func_74768_a("fuelTicks", 0);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        GL11.glPushMatrix();
        EntityPlayer player = event.entityPlayer;
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.partialRenderTick;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.partialRenderTick;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.partialRenderTick;
        GL11.glTranslated((double)(d0 -= RenderManager.field_78725_b), (double)(d1 -= RenderManager.field_78726_c), (double)(d2 -= RenderManager.field_78723_d));
        ItemStack chestPlate = player.field_71071_by.field_70460_b[2];
        if (chestPlate != null && chestPlate.func_77973_b() instanceof ItemArmorGlider && chestPlate.func_77942_o() && (chestPlate.func_77978_p().func_74767_n("isGliding") && !player.field_70122_E || chestPlate.func_77978_p().func_74767_n("isPowered") && !player.field_70122_E)) {
            float yaw = player.field_70177_z;
            float x = (float)Math.cos(Math.PI * (double)yaw / 180.0);
            float y = (float)Math.sin(Math.PI * (double)yaw / 180.0);
            GL11.glRotatef((float)60.0f, (float)x, (float)0.0f, (float)y);
            player.field_70721_aZ = 0.1f;
        }
        GL11.glTranslated((double)(-d0), (double)(-d1), (double)(-d2));
    }

    public boolean canFly() {
        return this == ModItems.armorGliderPowered;
    }

    private boolean hasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return false;
        }
        return true;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        GL11.glPopMatrix();
    }
}

