/*
 * Decompiled with CFR 0.152.
 */
package erebus.item;

import com.google.common.collect.HashMultimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.item.ItemMaterials;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSmoothie
extends ItemFood {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemSmoothie() {
        super(3, 0.5f, false);
        this.func_77656_e(0);
        this.func_77848_i();
        this.func_77627_a(true);
        this.func_77637_a(ModTabs.items);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return ItemMaterials.DATA.SMOOTHIE_GLASS.makeStack();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.drink;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        super.func_77654_b(stack, world, player);
        if (stack.field_77994_a >= 0 && !player.field_71071_by.func_70441_a(this.getContainerItem(stack))) {
            player.func_71019_a(this.getContainerItem(stack), false);
        }
        return stack;
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            SmoothieType type = SmoothieType.values()[stack.func_77960_j()];
            PotionEffect[] effects = type.getPotionEffects();
            if (effects != null && effects.length > 0) {
                for (PotionEffect effect : effects) {
                    player.func_70690_d(new PotionEffect(effect));
                }
            }
            type.onDrunk(player);
        }
    }

    public int func_150905_g(ItemStack stack) {
        return SmoothieType.values()[stack.func_77960_j()].getHealAmount();
    }

    public float func_150906_h(ItemStack stack) {
        return SmoothieType.values()[stack.func_77960_j()].getSaturationModifier();
    }

    public String func_77667_c(ItemStack stack) {
        String type = SmoothieType.values()[stack.func_77960_j()].toString().toLowerCase();
        return super.func_77658_a() + "_" + type;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isComplex) {
        PotionEffect[] effects;
        SmoothieType type = SmoothieType.values()[stack.func_77960_j()];
        String extraEffect = type.getExtraEffect();
        if (extraEffect != null) {
            list.add(StatCollector.func_74838_a((String)("erebus.smoothie.effect." + extraEffect)));
        }
        if ((effects = type.getPotionEffects()) != null && effects.length > 0) {
            HashMultimap attributes = HashMultimap.create();
            for (PotionEffect effect : effects) {
                String str = StatCollector.func_74838_a((String)effect.func_76453_d()).trim();
                Potion potion = Potion.field_76425_a[effect.func_76456_a()];
                Map map = potion.func_111186_k();
                if (map != null && map.size() > 0) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier modifier = (AttributeModifier)entry.getValue();
                        attributes.put((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)new AttributeModifier(modifier.func_111166_b(), potion.func_111183_a(effect.func_76458_c(), modifier), modifier.func_111169_c()));
                    }
                }
                if (effect.func_76458_c() > 0) {
                    str = str + " " + StatCollector.func_74838_a((String)("potion.potency." + effect.func_76458_c())).trim();
                }
                if (effect.func_76459_b() > 20) {
                    str = str + " (" + Potion.func_76389_a((PotionEffect)effect) + ")";
                }
                if (potion.func_76398_f()) {
                    list.add(EnumChatFormatting.RED + str);
                    continue;
                }
                list.add(EnumChatFormatting.GRAY + str);
            }
            if (!attributes.isEmpty()) {
                list.add("");
                list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"potion.effects.whenDrank"));
                for (Map.Entry entry : attributes.entries()) {
                    AttributeModifier modifier = (AttributeModifier)entry.getValue();
                    double amount0 = modifier.func_111164_d();
                    double amount1 = modifier.func_111169_c() != 1 && modifier.func_111169_c() != 2 ? modifier.func_111164_d() : modifier.func_111164_d() * 100.0;
                    if (amount0 > 0.0) {
                        list.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)("attribute.modifier.plus." + modifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(amount1), StatCollector.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
                        continue;
                    }
                    if (!(amount0 < 0.0)) continue;
                    list.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)("attribute.modifier.take." + modifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(amount1 *= -1.0), StatCollector.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < SmoothieType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public IIcon func_77617_a(int meta) {
        if (meta < 0 || meta >= this.icons.length) {
            return null;
        }
        return this.icons[meta];
    }

    public void func_94581_a(IIconRegister icon) {
        this.icons = new IIcon[SmoothieType.values().length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = icon.func_94245_a("erebus:smoothie_" + SmoothieType.values()[i].toString().toLowerCase());
        }
    }

    public static enum SmoothieType {
        GREEN_TEA_GRASSHOPPER(5, 0.4f, new PotionEffect(Potion.field_76430_j.field_76415_H, 1000, 2)),
        MONEY_HONEY(3, 0.2f, new PotionEffect(Potion.field_76428_l.field_76415_H, 200, 2)),
        NOTHING_IN_THE_MIDDLE(1, 0.0f, new PotionEffect(Potion.field_76441_p.field_76415_H, 500, 1)),
        GREEN_GIANT(2, 0.1f, new PotionEffect[0]),
        SEEDY_GOODNESS(1, 1.1f, new PotionEffect(Potion.field_76422_e.field_76415_H, 500, 1)),
        GIVIN_ME_THE_BLUES(3, 0.2f, new PotionEffect(Potion.field_76421_d.field_76415_H, 500, 2)),
        HOT_HOT_BABY(2, 0.1f, new PotionEffect(Potion.field_76420_g.field_76415_H, 1000, 1)),
        DONT_MEDDLE_WITH_THE_NETTLE(2, 0.1f, new PotionEffect(Potion.field_76429_m.field_76415_H, 1000, 1)),
        LIQUID_GOLD(0, 0.0f, new PotionEffect(Potion.field_76443_y.field_76415_H, 1000, 1)),
        BRYUFS_BREW(2, 0.0f, new PotionEffect(Potion.field_76420_g.field_76415_H, 1000, 2), new PotionEffect(Potion.field_76430_j.field_76415_H, 1000, 2), new PotionEffect(Potion.field_76424_c.field_76415_H, 1000, 2), new PotionEffect(Potion.field_76439_r.field_76415_H, 1000, 1));

        private final int healAmount;
        private final float saturationModifier;
        private final PotionEffect[] effects;

        private SmoothieType(int healAmount, float saturationModifier, PotionEffect ... effects) {
            this.healAmount = healAmount;
            this.saturationModifier = saturationModifier;
            this.effects = effects;
        }

        public PotionEffect[] getPotionEffects() {
            return this.effects;
        }

        public float getSaturationModifier() {
            return this.saturationModifier;
        }

        public int getHealAmount() {
            return this.healAmount;
        }

        public ItemStack makeStack() {
            return this.makeStack(1);
        }

        public ItemStack makeStack(int size) {
            return new ItemStack(ModItems.smoothie, size, this.ordinal());
        }

        public String getExtraEffect() {
            switch (this) {
                case GREEN_GIANT: {
                    return "milk";
                }
                case GIVIN_ME_THE_BLUES: {
                    return "extinguish";
                }
                case HOT_HOT_BABY: {
                    return "set_fire";
                }
                case LIQUID_GOLD: {
                    return "heal";
                }
                case BRYUFS_BREW: {
                    return "heal";
                }
            }
            return null;
        }

        public void onDrunk(EntityPlayer player) {
            switch (this) {
                case GREEN_GIANT: {
                    player.curePotionEffects(new ItemStack(Items.field_151117_aB));
                    break;
                }
                case GIVIN_ME_THE_BLUES: {
                    player.func_70066_B();
                    break;
                }
                case HOT_HOT_BABY: {
                    player.func_70015_d(5);
                    break;
                }
                case LIQUID_GOLD: {
                    player.func_70691_i(0.5f);
                    break;
                }
                case BRYUFS_BREW: {
                    player.func_70691_i(1.5f);
                    break;
                }
            }
        }
    }
}

