/*
 * Decompiled with CFR 0.152.
 */
package erebus.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSpawnEggs
extends ItemMonsterPlacer {
    private static final Random rand = new Random();
    private static final Map<Short, EggData> eggTypes = new LinkedHashMap<Short, EggData>();

    public ItemSpawnEggs() {
        this.func_77627_a(true);
        this.func_77637_a(CreativeTabs.field_78026_f);
    }

    public static void registerSpawnEgg(Class<? extends EntityLiving> entity, String entityName, int id, int eggBackgroundColor, int eggForegroundColor) {
        eggTypes.put((short)id, new EggData(id, entityName, entity, eggBackgroundColor, eggForegroundColor));
    }

    private static EggData getEggData(ItemStack is) {
        return eggTypes.get((short)is.func_77960_j());
    }

    public static Class<? extends EntityLiving> getRandomEntityClass() {
        EggData[] eggs = eggTypes.values().toArray(new EggData[0]);
        Class cls = eggs[rand.nextInt(eggs.length)].entityClass;
        while (IBossDisplayData.class.isAssignableFrom(cls)) {
            cls = eggs[rand.nextInt(eggs.length)].entityClass;
        }
        return cls;
    }

    public String func_77653_i(ItemStack is) {
        String s = StatCollector.func_74838_a((String)(this.func_77658_a() + ".name")).trim();
        String mob = "";
        EggData egg = ItemSpawnEggs.getEggData(is);
        if (egg != null) {
            mob = StatCollector.func_74838_a((String)("entity.erebus." + egg.entityName + ".name"));
        }
        return String.format(s, mob);
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        x += Facing.field_71586_b[side];
        y += Facing.field_71587_c[side];
        z += Facing.field_71585_d[side];
        EggData egg = ItemSpawnEggs.getEggData(is);
        if (egg != null) {
            egg.spawnMob(world, (double)x + 0.5, (double)y + (side == 1 && block != null && block.func_149645_b() == 11 ? 0.5 : 0.0), (double)z + 0.5, is);
            if (!player.field_71075_bZ.field_75098_d) {
                --is.field_77994_a;
            }
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return is;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, true);
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            EggData egg;
            int x = mop.field_72311_b;
            int y = mop.field_72312_c;
            int z = mop.field_72309_d;
            if (!world.func_72962_a(player, x, y, z) || !player.func_82247_a(x, y, z, mop.field_72310_e, is)) {
                return is;
            }
            if (world.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h && (egg = ItemSpawnEggs.getEggData(is)) != null) {
                egg.spawnMob(world, x, y, z, is);
                if (!player.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                }
            }
        }
        return is;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack is, int pass) {
        EggData egg = ItemSpawnEggs.getEggData(is);
        return egg != null ? (pass == 0 ? egg.primaryColor : egg.secondaryColor) : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs tab, List list) {
        for (Short s : eggTypes.keySet()) {
            list.add(new ItemStack(id, 1, (int)s.shortValue()));
        }
    }

    static class EggData {
        private final short id;
        private final Class<? extends EntityLiving> entityClass;
        String entityName;
        int primaryColor;
        int secondaryColor;

        EggData(int id, String entityName, Class<? extends EntityLiving> entityClass, int[] rgbPrimaryColor, int[] rgbSecondaryColor) {
            this(id, entityName, entityClass, rgbPrimaryColor[0] << 16 | rgbPrimaryColor[1] << 8 | rgbPrimaryColor[2], rgbSecondaryColor[0] << 16 | rgbSecondaryColor[1] << 8 | rgbSecondaryColor[2]);
        }

        EggData(int id, String entityName, Class<? extends EntityLiving> entityClass, int primaryColor, int secondaryColor) {
            this.id = (short)id;
            this.entityName = entityName;
            this.entityClass = entityClass;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
        }

        public EntityLiving spawnMob(World world, double x, double y, double z, ItemStack is) {
            EntityLiving e = null;
            try {
                e = this.entityClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
            if (e == null) {
                return null;
            }
            e.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            e.field_70759_as = e.field_70177_z;
            e.field_70761_aq = e.field_70177_z;
            e.func_110161_a((IEntityLivingData)null);
            world.func_72838_d((Entity)e);
            e.func_70642_aH();
            if (is.func_82837_s()) {
                e.func_94058_c(is.func_82833_r());
            }
            return e;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

