/*
 * Decompiled with CFR 0.152.
 */
package erebus.item.bambucket;

import cpw.mods.fml.common.eventhandler.Event;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModTabs;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;

public class ItemBambucket
extends Item {
    private final Block fluid;

    public ItemBambucket() {
        this(Blocks.field_150350_a);
        this.func_77655_b("erebus.bambucket");
        this.func_111206_d("erebus:bambucket");
    }

    public ItemBambucket(Block fluid) {
        this.fluid = fluid;
        this.func_77625_d(16);
        this.func_77637_a(ModTabs.specials);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.fluid != Blocks.field_150350_a;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return this.hasContainerItem(stack) ? new ItemStack(ModItems.bambucket) : null;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        if (entity instanceof EntityCow) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.bambucketMilk))) {
                player.func_71019_a(new ItemStack(ModItems.bambucketMilk), false);
            }
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        boolean flag = this.fluid == Blocks.field_150350_a;
        MovingObjectPosition pos = this.func_77621_a(world, player, flag);
        if (pos == null) {
            return stack;
        }
        FillBucketEvent event = new FillBucketEvent(player, stack, world, pos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return stack;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (player.field_71075_bZ.field_75098_d) {
                return stack;
            }
            if (--stack.field_77994_a <= 0) {
                return event.result;
            }
            if (!player.field_71071_by.func_70441_a(event.result)) {
                player.func_71019_a(event.result, false);
            }
            return stack;
        }
        if (pos.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = pos.field_72311_b;
            int y = pos.field_72312_c;
            int z = pos.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return stack;
            }
            if (flag) {
                if (!player.func_82247_a(x, y, z, pos.field_72310_e, stack)) {
                    return stack;
                }
                Block block = world.func_147439_a(x, y, z);
                int meta = world.func_72805_g(x, y, z);
                if (block == Blocks.field_150355_j && meta == 0) {
                    world.func_147468_f(x, y, z);
                    return this.addBucketToPlayer(stack, player, ModItems.bambucketWater);
                }
                if (block == ModBlocks.honeyBlock && meta == 0) {
                    world.func_147468_f(x, y, z);
                    return this.addBucketToPlayer(stack, player, ModItems.bambucketHoney);
                }
                if (block == ModBlocks.formicAcid && meta == 0) {
                    world.func_147468_f(x, y, z);
                    return this.addBucketToPlayer(stack, player, ModItems.bambucketFormicAcid);
                }
            } else {
                if (pos.field_72310_e == 0) {
                    --y;
                }
                if (pos.field_72310_e == 1) {
                    ++y;
                }
                if (pos.field_72310_e == 2) {
                    --z;
                }
                if (pos.field_72310_e == 3) {
                    ++z;
                }
                if (pos.field_72310_e == 4) {
                    --x;
                }
                if (pos.field_72310_e == 5) {
                    ++x;
                }
                if (!player.func_82247_a(x, y, z, pos.field_72310_e, stack)) {
                    return stack;
                }
                if (this.tryPlaceContainedLiquid(world, x, y, z) && !player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                    if (stack.field_77994_a <= 0) {
                        return new ItemStack(ModItems.bambucket);
                    }
                    player.field_71071_by.func_70441_a(new ItemStack(ModItems.bambucket));
                    return stack;
                }
            }
        }
        return stack;
    }

    private ItemStack addBucketToPlayer(ItemStack stack, EntityPlayer player, Item item) {
        if (player.field_71075_bZ.field_75098_d) {
            return stack;
        }
        if (--stack.field_77994_a <= 0) {
            return new ItemStack(item);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack(item))) {
            player.func_71019_a(new ItemStack(item), false);
        }
        return stack;
    }

    private boolean tryPlaceContainedLiquid(World world, int x, int y, int z) {
        boolean flag;
        if (this.fluid == Blocks.field_150350_a) {
            return false;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        boolean bl = flag = !material.func_76220_a();
        if (!world.func_147437_c(x, y, z) && !flag) {
            return false;
        }
        if (world.field_73011_w.field_76575_d && this.fluid == Blocks.field_150358_i) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!world.field_72995_K && flag && !material.func_76224_d()) {
                world.func_147480_a(x, y, z, true);
            }
            world.func_147465_d(x, y, z, this.fluid, 0, 3);
        }
        return true;
    }
}

