/*
 * Decompiled with CFR 0.152.
 */
package erebus.lib;

import cpw.mods.fml.common.registry.GameRegistry;
import erebus.ModBlocks;
import erebus.block.BlockErebusLeaves;
import erebus.block.BlockLogErebus;
import erebus.block.BlockSlabPlanks;
import erebus.block.BlockStairPlanks;
import erebus.block.BlockWoodFence;
import erebus.block.BlockWoodFenceGate;
import erebus.block.plants.BlockSaplingErebus;
import erebus.item.block.ItemBlockLocalised;
import erebus.item.block.ItemBlockSlabSimple;
import erebus.item.block.ItemErebusLeaves;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum EnumWood {
    Baobab,
    Eucalyptus,
    Mahogany,
    Mossbark,
    Asper,
    Cypress,
    Sap,
    White(false, true, false, false),
    Bamboo(false, true, false, false),
    Rotten(true, true, false, false),
    Marshwood;

    private final boolean hasLog;
    private final boolean hasPlanks;
    private final boolean hasSapling;
    private final boolean hasLeaves;
    private static final HashMap<EnumWood, Block> logs;
    private static final HashMap<EnumWood, Block> slabs;
    private static final HashMap<EnumWood, Block> stairs;
    private static final HashMap<EnumWood, Block> saplings;
    private static final HashMap<EnumWood, Block> leaves;
    private static final HashMap<EnumWood, Block> fences;
    private static final HashMap<EnumWood, Block> fenceGates;

    private EnumWood(boolean hasLog, boolean hasPlanks, boolean hasSapling, boolean hasLeaves) {
        this.hasLog = hasLog;
        this.hasPlanks = hasPlanks;
        this.hasSapling = hasSapling;
        this.hasLeaves = hasLeaves;
    }

    private EnumWood() {
        this(true, true, true, true);
    }

    public boolean hasSapling() {
        return this.hasSapling;
    }

    public boolean hasPlanks() {
        return this.hasPlanks;
    }

    public boolean hasLog() {
        return this.hasLog;
    }

    public boolean hasLeaves() {
        return this.hasLeaves;
    }

    public Block getStair() {
        return stairs.get((Object)this);
    }

    public Block getLog() {
        return logs.get((Object)this);
    }

    public Block getSlab() {
        return slabs.get((Object)this);
    }

    public Block getLeaves() {
        return leaves.get((Object)this);
    }

    public Block getSapling() {
        return saplings.get((Object)this);
    }

    public Block getFence() {
        return fences.get((Object)this);
    }

    public Block getFenceGate() {
        return fenceGates.get((Object)this);
    }

    public String getUnlocalisedName() {
        return this.name().toLowerCase();
    }

    public static void initBlocks() {
        for (EnumWood wood : EnumWood.values()) {
            if (wood.hasLog) {
                BlockLogErebus log = new BlockLogErebus(wood);
                GameRegistry.registerBlock((Block)log, ItemBlockLocalised.class, (String)("log" + wood.name()));
                Blocks.field_150480_ab.setFireInfo((Block)log, 5, 5);
                logs.put(wood, (Block)log);
            }
            if (wood.hasSapling) {
                BlockSaplingErebus sapling = new BlockSaplingErebus(wood);
                GameRegistry.registerBlock((Block)sapling, ItemBlockLocalised.class, (String)("sapling" + wood.name()));
                saplings.put(wood, (Block)sapling);
            }
            if (wood.hasPlanks) {
                BlockStairPlanks stair = new BlockStairPlanks(ModBlocks.planks, wood);
                GameRegistry.registerBlock((Block)stair, ItemBlockLocalised.class, (String)("plankStair" + wood.name()));
                Blocks.field_150480_ab.setFireInfo((Block)stair, 5, 5);
                stairs.put(wood, (Block)stair);
                BlockSlabPlanks slab = new BlockSlabPlanks(wood);
                GameRegistry.registerBlock((Block)slab, ItemBlockSlabSimple.class, (String)("slabPlanks" + wood.name()));
                Blocks.field_150480_ab.setFireInfo((Block)slab, 5, 5);
                slabs.put(wood, slab);
                BlockWoodFence fence = new BlockWoodFence(wood);
                GameRegistry.registerBlock((Block)fence, ItemBlockLocalised.class, (String)("fence" + wood.name()));
                fences.put(wood, (Block)fence);
                BlockWoodFenceGate fenceGate = new BlockWoodFenceGate(wood);
                GameRegistry.registerBlock((Block)fenceGate, ItemBlockLocalised.class, (String)("fenceGate" + wood.name()));
                fenceGates.put(wood, (Block)fenceGate);
            }
            if (!wood.hasLeaves) continue;
            BlockErebusLeaves leaf = new BlockErebusLeaves(wood);
            GameRegistry.registerBlock((Block)leaf, ItemErebusLeaves.class, (String)("leaves" + wood.name()));
            Blocks.field_150480_ab.setFireInfo((Block)leaf, 30, 60);
            leaves.put(wood, (Block)leaf);
        }
    }

    public static void initRecipes() {
        for (EnumWood wood : EnumWood.values()) {
            if (wood.hasLog) {
                Block log = logs.get((Object)wood);
                OreDictionary.registerOre((String)"logWood", (Block)log);
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ModBlocks.planks, 4, wood.ordinal()), (Object[])new Object[]{new ItemStack(log)});
                GameRegistry.addSmelting((ItemStack)new ItemStack(log), (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
            }
            if (wood.hasSapling) {
                OreDictionary.registerOre((String)"treeSapling", (Block)saplings.get((Object)wood));
            }
            if (wood.hasPlanks) {
                Block stair = stairs.get((Object)wood);
                OreDictionary.registerOre((String)"stairWood", (Block)stair);
                GameRegistry.addRecipe((ItemStack)new ItemStack(stair, 4), (Object[])new Object[]{"x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.planks, 1, wood.ordinal())});
                Block slab = slabs.get((Object)wood);
                OreDictionary.registerOre((String)"slabWood", (Block)slab);
                GameRegistry.addRecipe((ItemStack)new ItemStack(slab, 6), (Object[])new Object[]{"xxx", Character.valueOf('x'), new ItemStack(ModBlocks.planks, 1, wood.ordinal())});
                Block fence = fences.get((Object)wood);
                OreDictionary.registerOre((String)"fenceWood", (Block)fence);
                GameRegistry.addRecipe((ItemStack)new ItemStack(fence, 2), (Object[])new Object[]{"sps", "s s", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('p'), new ItemStack(ModBlocks.planks, 1, wood.ordinal())});
                Block fenceGate = fenceGates.get((Object)wood);
                OreDictionary.registerOre((String)"fenceGate", (Block)fenceGate);
                GameRegistry.addRecipe((ItemStack)new ItemStack(fenceGate, 1), (Object[])new Object[]{"sps", "sps", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('p'), new ItemStack(ModBlocks.planks, 1, wood.ordinal())});
            }
            if (!wood.hasLeaves) continue;
            Block leaf = wood.getLeaves();
            OreDictionary.registerOre((String)"treeLeaves", (Block)leaf);
        }
    }

    static {
        logs = new HashMap();
        slabs = new HashMap();
        stairs = new HashMap();
        saplings = new HashMap();
        leaves = new HashMap();
        fences = new HashMap();
        fenceGates = new HashMap();
    }
}

