/*
 * Decompiled with CFR 0.152.
 */
package erebus.recipes;

import erebus.ModBlocks;
import erebus.ModItems;
import erebus.core.helper.Utils;
import erebus.item.ItemMaterials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;

public class ComposterRegistry {
    private static List<Material> compostableMaterials = Arrays.asList(Material.field_151570_A, Material.field_151568_F, Material.field_151589_v, Material.field_151572_C, Material.field_151577_b, Material.field_151584_j, Material.field_151585_k, Material.field_151583_m, Material.field_151582_l, Material.field_151569_G, Material.field_151575_d);
    private static List<ItemStack> registry = new ArrayList<ItemStack>();
    private static List<ItemStack> blacklist = new ArrayList<ItemStack>();

    public static void init() {
        ComposterRegistry.register(Items.field_151055_y);
        ComposterRegistry.register(Items.field_151053_p);
        ComposterRegistry.register(Items.field_151135_aq);
        ComposterRegistry.register(Items.field_151017_I);
        ComposterRegistry.register(Items.field_151039_o);
        ComposterRegistry.register(Items.field_151038_n);
        ComposterRegistry.register(Items.field_151041_m);
        ComposterRegistry.register(Items.field_151015_O);
        ComposterRegistry.register(Items.field_151170_bI);
        ComposterRegistry.register(ItemMaterials.DATA.DARK_FRUIT_SEEDS.makeStack());
        ComposterRegistry.register(ItemMaterials.DATA.WEEPING_BLUE_PETAL.makeStack());
        ComposterRegistry.register(ItemMaterials.DATA.PAPYRUS.makeStack());
        ComposterRegistry.register(ItemMaterials.DATA.NETTLE_LEAVES.makeStack());
        ComposterRegistry.register(ItemMaterials.DATA.NETTLE_FLOWERS.makeStack());
        ComposterRegistry.register(ItemMaterials.DATA.MOSS_BALL.makeStack());
        ComposterRegistry.register(ItemMaterials.DATA.YELLOW_DOTTED_FUNGUS.makeStack());
        ComposterRegistry.register(ItemMaterials.DATA.JADE_BERRIES.makeStack());
        ComposterRegistry.register(ItemMaterials.DATA.SNAPPER_ROOT.makeStack());
        ComposterRegistry.register(ItemMaterials.DATA.BAMBOO.makeStack());
        ComposterRegistry.register(ItemMaterials.DATA.BAMBOO_SHOOT.makeStack());
        blacklist.add(new ItemStack(ModBlocks.wallPlants, 1, 1));
        blacklist.add(new ItemStack(ModBlocks.wallPlantsCultivated, 1, 1));
    }

    private static void register(Item item) {
        ComposterRegistry.register(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    private static void register(ItemStack stack) {
        registry.add(stack);
    }

    public static ItemStack isCompostable(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (ItemStack s : blacklist) {
            if (!Utils.areStacksTheSame(s, stack, false)) continue;
            return null;
        }
        if (stack.func_77973_b() instanceof ItemFood || stack.func_77973_b() instanceof ItemSeeds) {
            return new ItemStack(ModItems.compost);
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block != null && block != Blocks.field_150350_a && compostableMaterials.contains(block.func_149688_o())) {
            return new ItemStack(ModItems.compost);
        }
        for (ItemStack reg : registry) {
            if (!Utils.areStacksTheSame(stack, reg, false)) continue;
            return new ItemStack(ModItems.compost);
        }
        return null;
    }
}

