/*
 * Decompiled with CFR 0.152.
 */
package erebus.recipes;

import cpw.mods.fml.common.registry.GameRegistry;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.block.BlockSlabStone;
import erebus.block.plants.BlockErebusFlower;
import erebus.item.ItemDungeonIdols;
import erebus.item.ItemErebusFood;
import erebus.item.ItemMaterials;
import erebus.lib.EnumWood;
import erebus.recipes.EnchantSensitiveRecipe;
import erebus.recipes.RecipeGliderDye;
import erebus.recipes.RecipePaxel;
import erebus.recipes.RecipeSprintLeggingsUpgrades;
import erebus.world.biomes.decorators.data.OreSettings;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeHandler {
    public static void init() {
        EnumWood.initRecipes();
        RecipeHandler.registerOreDictionary();
        RecipeHandler.registerRecipes();
        RecipeHandler.registerSmelting();
        RecipeSorter.register((String)"erebus.gliderdye", RecipeGliderDye.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"erebus.paxelrecipe", RecipePaxel.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"erebus.enchantmentsensitiverecipe", EnchantSensitiveRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"erebus.sprintleggingsupgrades", RecipeSprintLeggingsUpgrades.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }

    private static void registerRecipes() {
        RecipeHandler.addShapelessRecipe(new ItemStack(ModBlocks.planks, 1, EnumWood.White.ordinal()), "plankWood", "dyeWhite");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.umberPaver, 4, 0), "##", "##", Character.valueOf('#'), new ItemStack(ModBlocks.umberstone, 1, 1));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.umberPaver, 4, 1), "##", "##", Character.valueOf('#'), new ItemStack(ModBlocks.umberstone, 1, 2));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.umberPaver, 4, 2), "##", "##", Character.valueOf('#'), new ItemStack(ModBlocks.umberstone, 1, 3));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.umberFurnace, 1), "###", "#$#", "###", Character.valueOf('#'), new ItemStack(ModBlocks.umberstone, 1, 1), Character.valueOf('$'), Items.field_151133_ar);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.umberstone, 4, 4), "##", "##", Character.valueOf('#'), "stoneUmber");
        RecipeHandler.addShapelessRecipe(new ItemStack(ModBlocks.umberstoneButton, 1, 0), new ItemStack(ModBlocks.umberstone, 1, 1));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.umberstone, 9, 5), "###", "###", "###", Character.valueOf('#'), "stoneUmber");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.umberstone, 4, 6), "##", "##", Character.valueOf('#'), new ItemStack(ModBlocks.umberstone, 1, 5));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.umberstonePillar, 2), "#", "#", Character.valueOf('#'), "stoneUmber");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.petrifiedWoodPlanks), "xx", "xx", Character.valueOf('x'), ItemMaterials.DATA.PETRIFIED_WOOD.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.petrifiedCraftingTable), "xx", "xx", Character.valueOf('x'), ModBlocks.petrifiedWoodPlanks);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.petrifiedWoodChest), "xxx", "xyx", "xxx", Character.valueOf('x'), ModBlocks.petrifiedWoodPlanks, Character.valueOf('y'), "ingotGold");
        for (int i = 0; i < ModBlocks.umbercobbleStairs.length; ++i) {
            RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.umbercobbleStairs[i], 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(ModBlocks.umberstone, 1, i));
        }
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.amberBrickStairs, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(ModBlocks.amber, 1, 2));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.petrifiedWoodStairs, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(ModBlocks.petrifiedWoodPlanks, 1, 0));
        for (Block slab : ModBlocks.stoneSlabs) {
            RecipeHandler.addShapedRecipe(new ItemStack(slab, 6), "xxx", Character.valueOf('x'), new ItemStack(((BlockSlabStone)slab).base, 1, ((BlockSlabStone)slab).meta));
        }
        for (int i = 0; i < ModBlocks.gneissStairs.length; ++i) {
            RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.gneissStairs[i], 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(ModBlocks.gneiss, 1, i));
        }
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.wall, 6), "###", "###", Character.valueOf('#'), "stoneUmber");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.wall, 6, 1), "###", "###", Character.valueOf('#'), new ItemStack(ModBlocks.umberstone, 1, 1));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.wall, 6, 2), "###", "###", Character.valueOf('#'), new ItemStack(ModBlocks.umberstone, 1, 2));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.wall, 6, 3), "###", "###", Character.valueOf('#'), new ItemStack(ModBlocks.umberstone, 1, 3));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.wall, 6, 4), "###", "###", Character.valueOf('#'), new ItemStack(ModBlocks.umberstone, 1, 4));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.wall, 6, 5), "###", "###", Character.valueOf('#'), new ItemStack(ModBlocks.umberPaver, 1, 0));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.wall, 6, 6), "###", "###", Character.valueOf('#'), new ItemStack(ModBlocks.umberPaver, 1, 1));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.wall, 6, 7), "###", "###", Character.valueOf('#'), new ItemStack(ModBlocks.umberPaver, 1, 2));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.wall, 6, 8), "###", "###", Character.valueOf('#'), new ItemStack(ModBlocks.amber, 1, 2));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.doorAmber, 3), "##", "##", "##", Character.valueOf('#'), new ItemStack(ModBlocks.amber, 1, 2));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.doorBaobab, 3), "##", "##", "##", Character.valueOf('#'), "plank" + (Object)((Object)EnumWood.Baobab));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.doorEucalyptus, 3), "##", "##", "##", Character.valueOf('#'), "plank" + (Object)((Object)EnumWood.Eucalyptus));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.doorMahogany, 3), "##", "##", "##", Character.valueOf('#'), "plank" + (Object)((Object)EnumWood.Mahogany));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.doorMossbark, 3), "##", "##", "##", Character.valueOf('#'), "plank" + (Object)((Object)EnumWood.Mossbark));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.doorAsper, 3), "##", "##", "##", Character.valueOf('#'), "plank" + (Object)((Object)EnumWood.Asper));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.doorCypress, 3), "##", "##", "##", Character.valueOf('#'), "plank" + (Object)((Object)EnumWood.Cypress));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.doorRotten, 3), "##", "##", "##", Character.valueOf('#'), "plank" + (Object)((Object)EnumWood.Rotten));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.doorMarshwood, 3), "##", "##", "##", Character.valueOf('#'), "plank" + (Object)((Object)EnumWood.Marshwood));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.doorPetrified, 3), "##", "##", "##", Character.valueOf('#'), "plankPetrified");
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.doorScorched, 3), "##", "##", "##", Character.valueOf('#'), "plankScorched");
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.jadePickaxe, 1), "XXX", " # ", " # ", Character.valueOf('#'), "stickWood", Character.valueOf('X'), "gemJade");
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.jadeShovel, 1), "X", "#", "#", Character.valueOf('#'), "stickWood", Character.valueOf('X'), "gemJade");
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.jadeAxe, 1), "XX", "X#", " #", Character.valueOf('#'), "stickWood", Character.valueOf('X'), "gemJade");
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.jadeHoe, 1), "XX", " #", " #", Character.valueOf('#'), "stickWood", Character.valueOf('X'), "gemJade");
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.jadeSword, 1), "X", "X", "#", Character.valueOf('#'), "stickWood", Character.valueOf('X'), "gemJade");
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.jadePaxel, 1), "XXX", "XSX", "XSX", Character.valueOf('X'), "gemJade", Character.valueOf('S'), "stickWood");
        GameRegistry.addRecipe((IRecipe)new RecipePaxel());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.jadeHelmet, 1), "###", "# #", Character.valueOf('#'), "gemJade");
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.jadeBody, 1), "# #", "###", "###", Character.valueOf('#'), "gemJade");
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.jadeLegs, 1), "###", "# #", "# #", Character.valueOf('#'), "gemJade");
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.jadeBoots, 1), "# #", "# #", Character.valueOf('#'), "gemJade");
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.exoskeletonHelmet, 1), "sss", "s s", Character.valueOf('s'), ItemMaterials.DATA.PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.exoskeletonBody, 1), "s s", "sss", "sss", Character.valueOf('s'), ItemMaterials.DATA.PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.exoskeletonLegs, 1), "sss", "s s", "s s", Character.valueOf('s'), ItemMaterials.DATA.PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.exoskeletonBoots, 1), "s s", "s s", Character.valueOf('s'), ItemMaterials.DATA.PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack(), "sss", "sss", "sss", Character.valueOf('s'), ItemMaterials.DATA.PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.reinExoskeletonHelmet, 1), "sss", "s s", Character.valueOf('s'), ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.reinExoskeletonBody, 1), "s s", "sss", "sss", Character.valueOf('s'), ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.reinExoskeletonLegs, 1), "sss", "s s", "s s", Character.valueOf('s'), ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.reinExoskeletonBoots, 1), "s s", "s s", Character.valueOf('s'), ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.COMPOUND_LENS.makeStack(), "GGG", "GEG", "GGG", Character.valueOf('E'), new ItemStack(ModBlocks.amber, 1, 1), Character.valueOf('G'), ItemMaterials.DATA.COMPOUND_EYES.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.compoundGoggles, 1), "XXX", "OXO", Character.valueOf('O'), ItemMaterials.DATA.COMPOUND_LENS.makeStack(), Character.valueOf('X'), ItemMaterials.DATA.PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.reinCompoundGoggles, 1), "XXX", "XOX", Character.valueOf('O'), new ItemStack(ModItems.compoundGoggles, 1), Character.valueOf('X'), ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.jumpBoots), "F F", "BXB", "B B", Character.valueOf('F'), ItemMaterials.DATA.FLY_WING.makeStack(), Character.valueOf('B'), ItemMaterials.DATA.ELASTIC_FIBRE.makeStack(), Character.valueOf('X'), new ItemStack(ModItems.reinExoskeletonBoots, 1));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.sprintLeggings), "BBB", "BXB", "BBB", Character.valueOf('B'), ItemMaterials.DATA.BIO_VELOCITY.makeStack(), Character.valueOf('X'), new ItemStack(ModItems.reinExoskeletonLegs, 1));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.armorGlider), "GXG", Character.valueOf('G'), ItemMaterials.DATA.GLIDER_WING.makeStack(), Character.valueOf('X'), new ItemStack(ModItems.reinExoskeletonBody, 1));
        RecipeHandler.addShapedRecipe(new ItemStack((Item)ModItems.armorGliderPowered), "W W", "ECE", " V ", Character.valueOf('W'), ItemMaterials.DATA.ENHANCED_GLIDER_WING.makeStack(), Character.valueOf('E'), ItemMaterials.DATA.ELASTIC_FIBRE.makeStack(), Character.valueOf('C'), new ItemStack(ModItems.armorGlider, 1), Character.valueOf('V'), new ItemStack(ModBlocks.velocityBlock, 1));
        GameRegistry.addRecipe((IRecipe)new RecipeGliderDye());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.waterStriders), "WWW", "WXW", "WWW", Character.valueOf('W'), ItemMaterials.DATA.WATER_REPELLENT.makeStack(), Character.valueOf('X'), new ItemStack(ModItems.reinExoskeletonBoots, 1));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.rhinoExoskeletonHelmet), "h h", "sss", "s s", Character.valueOf('s'), ItemMaterials.DATA.PLATE_EXO_RHINO.makeStack(), Character.valueOf('h'), ItemMaterials.DATA.RHINO_BEETLE_HORN.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.rhinoExoskeletonBody), "s s", "sss", "sss", Character.valueOf('s'), ItemMaterials.DATA.PLATE_EXO_RHINO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.rhinoExoskeletonLegs), "sss", "s s", "s s", Character.valueOf('s'), ItemMaterials.DATA.PLATE_EXO_RHINO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.rhinoExoskeletonBoots), "s s", "s s", Character.valueOf('s'), ItemMaterials.DATA.PLATE_EXO_RHINO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.scorpionPincer), "I I", "XIX", "XPX", Character.valueOf('I'), "ingotIron", Character.valueOf('X'), ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack(), Character.valueOf('P'), ItemMaterials.DATA.SCORPION_PINCER.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.rolledNewspaper), "PWP", "PIP", "PWP", Character.valueOf('I'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('P'), ItemMaterials.DATA.PAPYRUS.makeStack(), Character.valueOf('W'), ItemMaterials.DATA.WHETSTONE_POWDER.makeStack());
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.GLIDER_WING.makeStack(), "SSS", "FFF", "FFF", Character.valueOf('S'), "stickWood", Character.valueOf('F'), ItemMaterials.DATA.FLY_WING.makeStack());
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.ENHANCED_GLIDER_WING.makeStack(), "BBB", "WWW", "WWW", Character.valueOf('B'), ItemMaterials.DATA.BAMBOO.makeStack(), Character.valueOf('W'), ItemMaterials.DATA.DRAGONFLY_WING.makeStack());
        RecipeHandler.addShapelessRecipe(new ItemStack(ModItems.waspDagger), ItemMaterials.DATA.WASP_STING.makeStack(), "stickWood");
        GameRegistry.addRecipe((IRecipe)new RecipeSprintLeggingsUpgrades());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.mushroomHelm, 1), "mmm", "mpm", Character.valueOf('m'), ItemMaterials.DATA.HIDE_SHROOM.makeStack(), Character.valueOf('p'), new ItemStack(Blocks.field_150423_aK));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.bigBulbCappedMushroom), "mmm", "mmm", "mmm", Character.valueOf('m'), new ItemStack(ModBlocks.darkCapped));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.bigGreenMushroom), "mmm", "mmm", "mmm", Character.valueOf('m'), new ItemStack(ModBlocks.grandmasShoes));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.bigBundleMushroom), "mmm", "mmm", "mmm", Character.valueOf('m'), new ItemStack(ModBlocks.sarcasticCzech));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.bigKaiserfingerMushroom), "mmm", "mmm", "mmm", Character.valueOf('m'), new ItemStack(ModBlocks.kaizersFinger));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.bigDutchCapMushroom), "mmm", "mmm", "mmm", Character.valueOf('m'), new ItemStack(ModBlocks.dutchCap));
        RecipeHandler.addShapedRecipe(new ItemStack(Blocks.field_150419_aX), "mmm", "mmm", "mmm", Character.valueOf('m'), new ItemStack((Block)Blocks.field_150337_Q));
        RecipeHandler.addShapedRecipe(new ItemStack(Blocks.field_150420_aW), "mmm", "mmm", "mmm", Character.valueOf('m'), new ItemStack((Block)Blocks.field_150338_P));
        RecipeHandler.addShapelessRecipe(new ItemStack(Items.field_151137_ax, 2, 0), ItemMaterials.DATA.RED_GEM.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.redGem, 1, 0), "##", "##", Character.valueOf('#'), ItemMaterials.DATA.RED_GEM.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.redGem, 1, 1), " S ", "S#S", " S ", Character.valueOf('#'), new ItemStack(ModBlocks.redGem, 1, 0), Character.valueOf('S'), "stickWood");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.glowGemBlock, 3, 0), "BBB", "BGB", "BBB", Character.valueOf('B'), ItemMaterials.DATA.BIO_LUMINESCENCE.makeStack(), Character.valueOf('G'), ItemMaterials.DATA.RED_GEM.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.bambucket, 1, 0), " S ", "B B", " B ", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('B'), ItemMaterials.DATA.BAMBOO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.bambucketHoney), "RRR", "RBR", "RRR", Character.valueOf('B'), new ItemStack(ModItems.bambucket, 1, 0), Character.valueOf('R'), "dropHoney");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.planks, 1, EnumWood.Bamboo.ordinal()), "##", "##", Character.valueOf('#'), ItemMaterials.DATA.BAMBOO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.bambooCrate), "bpb", "p p", "bpb", Character.valueOf('p'), new ItemStack(ModBlocks.planks, 1, EnumWood.Bamboo.ordinal()), Character.valueOf('b'), ItemMaterials.DATA.BAMBOO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.bambooLadder, 1), "BBB", "S S", "BBB", Character.valueOf('B'), ItemMaterials.DATA.BAMBOO.makeStack(), Character.valueOf('S'), Items.field_151007_F);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.bambooTorch, 4), "C", "B", "B", Character.valueOf('C'), new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), Character.valueOf('B'), ItemMaterials.DATA.BAMBOO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.bambooBridge, 3), "SSS", "B B", "LLL", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('L'), new ItemStack(ModBlocks.bambooLadder, 1), Character.valueOf('B'), ItemMaterials.DATA.BAMBOO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.bambooPole, 4), "S", "B", "B", Character.valueOf('S'), "slimeball", Character.valueOf('B'), ItemMaterials.DATA.BAMBOO.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.extenderThingy, 1), "BSB", "PDP", "BRB", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), Blocks.field_150367_z, Character.valueOf('B'), ItemMaterials.DATA.BAMBOO.makeStack(), Character.valueOf('P'), new ItemStack(ModBlocks.planks, 1, EnumWood.Bamboo.ordinal()));
        RecipeHandler.addShapelessRecipe(new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.BAMBOO_SOUP.ordinal()), new ItemStack(Items.field_151054_z), ItemMaterials.DATA.BAMBOO.makeStack(), ItemMaterials.DATA.BAMBOO_SHOOT.makeStack());
        RecipeHandler.addShapelessRecipe(new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.LARVAE_ON_STICK.ordinal()), "stickWood", new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.BEETLE_LARVA_COOKED.ordinal()), new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.BEETLE_LARVA_COOKED.ordinal()), new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.BEETLE_LARVA_COOKED.ordinal()));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.food, 2, ItemErebusFood.FoodType.HONEY_SANDWICH.ordinal()), " B ", "RRR", " B ", Character.valueOf('B'), new ItemStack(Items.field_151025_P), Character.valueOf('R'), "dropHoney");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.honeyTreat, 1), "SRS", "RBR", "SRS", Character.valueOf('S'), new ItemStack(Items.field_151102_aT), Character.valueOf('B'), new ItemStack(Items.field_151025_P), Character.valueOf('R'), "dropHoney");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.mirBrick), "xy", "yx", Character.valueOf('x'), Items.field_151119_aD, Character.valueOf('y'), ItemMaterials.DATA.MUD_BRICK.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.mirBrick), "xy", "yx", Character.valueOf('y'), Items.field_151119_aD, Character.valueOf('x'), ItemMaterials.DATA.MUD_BRICK.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.mirBrick, 4), "xy", "yx", Character.valueOf('x'), Blocks.field_150435_aG, Character.valueOf('y'), ModBlocks.mudBricks);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.mirBrick, 4), "xy", "yx", Character.valueOf('y'), Blocks.field_150435_aG, Character.valueOf('x'), ModBlocks.mudBricks);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.blockSilk, 1), "sss", "sss", "sss", Character.valueOf('s'), Items.field_151007_F);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.amber, 4, 2), "ss", "ss", Character.valueOf('s'), new ItemStack(ModBlocks.amber, 1, 0));
        RecipeHandler.addShapelessRecipe(new ItemStack(Items.field_151007_F, 9), new ItemStack(ModBlocks.blockSilk));
        RecipeHandler.addShapelessRecipe(new ItemStack(Items.field_151100_aR, 1, 15), ItemMaterials.DATA.SHARD_BONE.makeStack());
        RecipeHandler.addShapelessRecipe(new ItemStack(Items.field_151100_aR, 6, 15), new ItemStack(ModItems.cavemanClub, 1, 0));
        RecipeHandler.addShapedRecipe(new ItemStack(Items.field_151032_g, 4), "T", "S", "F", Character.valueOf('F'), new ItemStack(Items.field_151008_G, 1, 0), Character.valueOf('S'), "stickWood", Character.valueOf('T'), ItemMaterials.DATA.SHARD_BONE.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(Items.field_151032_g, 4), "T", "S", "F", Character.valueOf('F'), ItemMaterials.DATA.FLY_WING.makeStack(), Character.valueOf('S'), "stickWood", Character.valueOf('T'), ItemMaterials.DATA.SHARD_BONE.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(Items.field_151032_g, 4), "T", "S", "F", Character.valueOf('F'), ItemMaterials.DATA.FLY_WING.makeStack(), Character.valueOf('S'), "stickWood", Character.valueOf('T'), Items.field_151145_ak);
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.sprayCan, 9), " B ", "XRX", "XXX", Character.valueOf('X'), "ingotIron", Character.valueOf('B'), "buttonWood", Character.valueOf('R'), ItemMaterials.DATA.REPELLENT.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.altarBase, 1), "XXX", "XOX", "XXX", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('X'), ItemMaterials.DATA.ALTAR_FRAGMENT.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.glowingJar, 1), "XXX", "GBG", "GGG", Character.valueOf('X'), "ingotIron", Character.valueOf('G'), new ItemStack(ModBlocks.amber, 1, 1), Character.valueOf('B'), ItemMaterials.DATA.BIO_LUMINESCENCE.makeStack());
        RecipeHandler.addShapelessRecipe(new ItemStack(ModBlocks.reinExo, 1), ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack(), ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack(), ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack(), ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack());
        RecipeHandler.addShapelessRecipe(new ItemStack(Items.field_151122_aG, 1, 0), ItemMaterials.DATA.PLATE_EXO.makeStack(), Items.field_151121_aF, Items.field_151121_aF, Items.field_151121_aF);
        RecipeHandler.addShapelessRecipe(new ItemStack(Items.field_151121_aF, 4), ItemMaterials.DATA.PAPYRUS.makeStack(), ItemMaterials.DATA.PAPYRUS.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.velocityBlock), "xxx", "xxx", "xxx", Character.valueOf('x'), ItemMaterials.DATA.BIO_VELOCITY.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.mudBricks), "xx", "xx", Character.valueOf('x'), ItemMaterials.DATA.MUD_BRICK.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.homingBeecon), "GNG", "NCN", "GNG", Character.valueOf('N'), ItemMaterials.DATA.NECTAR.makeStack(), Character.valueOf('G'), "ingotGold", Character.valueOf('C'), Items.field_151111_aL);
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.nectarCollector), "  B", " S ", "S  ", Character.valueOf('B'), Items.field_151054_z, Character.valueOf('S'), "stickWood");
        ItemStack diamondPick = new ItemStack(Items.field_151046_w);
        diamondPick.func_77966_a(Enchantment.field_77348_q, 1);
        GameRegistry.addRecipe((IRecipe)EnchantSensitiveRecipe.makeRecipe(new ItemStack(ModItems.blockExtractor), "  M", " D ", "C  ", Character.valueOf('M'), ItemMaterials.DATA.STAG_BEETLE_MANDIBLES.makeStack(), Character.valueOf('D'), diamondPick, Character.valueOf('C'), "chestWood"));
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.bucketHoney), "RRR", "RBR", "RRR", Character.valueOf('R'), "dropHoney", Character.valueOf('B'), Items.field_151133_ar);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.jarOHoney), "%%%", "$0$", "$$$", Character.valueOf('%'), "ingotIron", Character.valueOf('$'), new ItemStack(ModBlocks.amber, 1, 1), Character.valueOf('0'), ItemMaterials.DATA.NECTAR.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.jadeBlock), "xxx", "xxx", "xxx", Character.valueOf('x'), "gemJade");
        RecipeHandler.addShapelessRecipe(ItemMaterials.DATA.JADE.makeStack(9), "blockJade");
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.MUCUS_CHARGE.makeStack(), "SSS", "SRS", "SSS", Character.valueOf('S'), "slimeball", Character.valueOf('R'), ItemMaterials.DATA.REPELLENT.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.mucusBomb, 1), "MMM", "MTM", "MMM", Character.valueOf('M'), ItemMaterials.DATA.MUCUS_CHARGE.makeStack(), Character.valueOf('T'), Blocks.field_150335_W);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.honeyCombBlock, 1), "NPN", "PCP", "NPN", Character.valueOf('P'), ItemMaterials.DATA.PAPYRUS.makeStack(), Character.valueOf('C'), "chestWood", Character.valueOf('N'), ItemMaterials.DATA.NECTAR.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(Items.field_151065_br, 1), "FFF", "FFF", "FFF", Character.valueOf('F'), new ItemStack(ModBlocks.fireBloom));
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.MOSS_BALL.makeStack(), "mmm", "mmm", "mmm", Character.valueOf('m'), new ItemStack(ModBlocks.wallPlants, 1, 0));
        RecipeHandler.addShapelessRecipe(new ItemStack(ModBlocks.scorchedPlanks, 4), ModBlocks.scorchedWood);
        RecipeHandler.addShapelessRecipe(new ItemStack(ModBlocks.glowshroom), ItemMaterials.DATA.YELLOW_DOTTED_FUNGUS.makeStack(), Blocks.field_150478_aa);
        RecipeHandler.addShapelessRecipe(new ItemStack(ModBlocks.glowshroom), ItemMaterials.DATA.YELLOW_DOTTED_FUNGUS.makeStack(), ItemMaterials.DATA.BIO_LUMINESCENCE.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.portalActivator), "VSE", "VSS", "GVV", Character.valueOf('V'), Blocks.field_150395_bd, Character.valueOf('S'), "stickWood", Character.valueOf('E'), ItemMaterials.DATA.GAEAN_GEM.makeStack(), Character.valueOf('G'), "ingotGold");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.gaeanKeystone), "V V", "SOS", "SSS", Character.valueOf('V'), Blocks.field_150395_bd, Character.valueOf('S'), Blocks.field_150417_aV, Character.valueOf('O'), Blocks.field_150343_Z);
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.antTamingAmulet), "pgp", "gog", "pgp", Character.valueOf('p'), ItemMaterials.DATA.ANT_PHEROMONES.makeStack(), Character.valueOf('g'), "ingotGold", Character.valueOf('o'), Blocks.field_150343_Z);
        RecipeHandler.addShapelessRecipe(new ItemStack(ModItems.planticide, 2), ItemMaterials.DATA.POISON_GLAND.makeStack(), "slimeball", "dyeWhite");
        RecipeHandler.addShapelessRecipe(new ItemStack(ModBlocks.varnishedPlanks), "plankWood", ItemMaterials.DATA.SAP_BALL.makeStack(), ItemMaterials.DATA.REPELLENT.makeStack(), ItemMaterials.DATA.CAMO_POWDER.makeStack());
        RecipeHandler.addShapelessRecipe(new ItemStack(ModBlocks.varnishedPlanks), "plankWood", "slimeball", ItemMaterials.DATA.REPELLENT.makeStack(), ItemMaterials.DATA.CAMO_POWDER.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.composter), "xyx", "xzx", "xyx", Character.valueOf('x'), ModBlocks.varnishedPlanks, Character.valueOf('y'), "dyeGreen", Character.valueOf('z'), "gemEmerald");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.composter), "xyx", "xzx", "xyx", Character.valueOf('x'), ModBlocks.varnishedPlanks, Character.valueOf('y'), "dyeLime", Character.valueOf('z'), "gemEmerald");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.siloSupports), "xxx", "y y", "y y", Character.valueOf('x'), "slabWood", Character.valueOf('y'), "fenceWood");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.siloTank), "xzx", "ywy", "xzx", Character.valueOf('x'), "ingotIron", Character.valueOf('y'), "blockIron", Character.valueOf('z'), ModBlocks.varnishedPlanks, Character.valueOf('w'), ModBlocks.petrifiedWoodChest);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.siloRoof), " x ", "xyx", Character.valueOf('x'), ModBlocks.varnishedPlanks, Character.valueOf('y'), ModBlocks.petrifiedWoodPlanks);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.offeringAltar), "xwx", "yzy", "xyx", Character.valueOf('x'), "stone", Character.valueOf('y'), Blocks.field_150417_aV, Character.valueOf('z'), Blocks.field_150343_Z, Character.valueOf('w'), "ingotGold");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.templeTile, 4), "xx", "xx", Character.valueOf('x'), new ItemStack(ModBlocks.templeBrick));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.templePillar, 2), "x", "x", Character.valueOf('x'), new ItemStack(ModBlocks.templeTile));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.gneiss), "xx", "xx", Character.valueOf('x'), ItemMaterials.DATA.GNEISS_ROCK.makeStack());
        RecipeHandler.addShapelessRecipe(new ItemStack(Items.field_151100_aR, 2, 9), ModBlocks.waterFlower);
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.JADE.makeStack(), "xxx", "xxx", "xxx", Character.valueOf('x'), ItemMaterials.DATA.JADE_BERRIES.makeStack());
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.WATER_REPELLENT.makeStack(), "xxx", "xrx", "xxx", Character.valueOf('x'), ItemMaterials.DATA.HYDROFUGE.makeStack(), Character.valueOf('r'), ItemMaterials.DATA.REPELLENT.makeStack());
        RecipeHandler.addShapelessRecipe(ItemMaterials.DATA.STEW_POT.makeStack(), Items.field_151066_bu, "stickWood");
        RecipeHandler.addShapelessRecipe(ItemMaterials.DATA.TITAN_STEW.makeStack(), ItemMaterials.DATA.STEW_POT.makeStack(), new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.TITAN_CHOP_RAW.ordinal()), Items.field_151174_bG, Items.field_151172_bF, new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.CABBAGE.ordinal()), "foodMushroom", "foodMushroom");
        RecipeHandler.addShapelessRecipe(ItemMaterials.DATA.TITAN_STEW.makeStack(), ItemMaterials.DATA.STEW_POT.makeStack(), Items.field_151082_bd, Items.field_151082_bd, Items.field_151174_bG, Items.field_151172_bF, new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.CABBAGE.ordinal()), "foodMushroom", "foodMushroom");
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.wallPlantsCultivated, 1, 0), "dvd", "vpv", "dvd", Character.valueOf('d'), new ItemStack(Items.field_151100_aR, 1, 2), Character.valueOf('v'), ItemMaterials.DATA.SUPERNATURAL_VELOCITY.makeStack(), Character.valueOf('p'), new ItemStack(ModBlocks.wallPlants, 1, 0));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.wallPlantsCultivated, 1, 1), "dvd", "vpv", "dvd", Character.valueOf('d'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('v'), ItemMaterials.DATA.SUPERNATURAL_VELOCITY.makeStack(), Character.valueOf('p'), new ItemStack(ModBlocks.wallPlants, 1, 1));
        RecipeHandler.addShapedRecipe(new ItemStack(Items.field_151116_aA, 8), "xx", "xx", Character.valueOf('x'), ItemMaterials.DATA.HIDE_SHROOM.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(Items.field_151100_aR, 1, 2), "xx", "xx", Character.valueOf('x'), new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.STEM.ordinal()));
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.AMBER_STAR.makeStack(), " x ", "xyx", " x ", Character.valueOf('x'), ItemMaterials.DATA.SAP_BALL.makeStack(), Character.valueOf('y'), new ItemStack(ModBlocks.amber, 1, 1));
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.armchair), "  w", "www", "p p", Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('p'), "plankWood");
        RecipeHandler.addShapedRecipe(new ItemStack(Items.field_151078_bh), "xx", "xx", Character.valueOf('x'), ItemMaterials.DATA.PLATE_ZOMBIE_ANT.makeStack());
        RecipeHandler.addShapelessRecipe(ItemMaterials.DATA.SMOOTHIE_GLASS.makeStack(), Items.field_151069_bo, Items.field_151069_bo, Items.field_151069_bo);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.smoothieMaker), "xrx", "xxx", "sss", Character.valueOf('x'), ItemMaterials.DATA.SMOOTHIE_GLASS.makeStack(), Character.valueOf('r'), new ItemStack(ModBlocks.redGem), Character.valueOf('s'), new ItemStack(ModBlocks.umberstone));
        RecipeHandler.addShapelessRecipe(new ItemStack(ModItems.bottleAntiVenom, 2), ModItems.bucketAntiVenom, Items.field_151069_bo, Items.field_151069_bo);
        RecipeHandler.addShapelessRecipe(new ItemStack(ModItems.bottleAntiVenom, 2), ModItems.bambucketAntiVenom, Items.field_151069_bo, Items.field_151069_bo);
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.whetstone, 1, 0), "SSS", "PPP", "UUU", Character.valueOf('S'), Blocks.field_150354_m, Character.valueOf('P'), ItemMaterials.DATA.PETRIFIED_WOOD.makeStack(), Character.valueOf('U'), new ItemStack(ModBlocks.umberstone, 1, 0));
        for (int i = 1; i <= Enchantment.field_77338_j.func_77325_b(); ++i) {
            RecipeHandler.addShapedRecipe(new ItemStack(ModItems.whetstone, 1, i), "xxx", "xyx", "xxx", Character.valueOf('x'), ItemMaterials.DATA.WHETSTONE_POWDER.makeStack(), Character.valueOf('y'), new ItemStack(ModItems.whetstone, 1, i - 1));
        }
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.RHINO_RIDING_KIT.makeStack(), " SX", "CCC", "LLL", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('X'), ItemMaterials.DATA.PLATE_EXO.makeStack(), Character.valueOf('C'), new ItemStack(Blocks.field_150404_cg, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151100_aR, 1, 4));
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.BEETLE_TAMING_AMULET.makeStack(), " N ", "NJN", " F ", Character.valueOf('N'), "nuggetGold", Character.valueOf('J'), "gemJade", Character.valueOf('F'), ItemMaterials.DATA.ALTAR_FRAGMENT.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.beeTamingAmulet), " n ", "nJn", " N ", Character.valueOf('n'), "nuggetGold", Character.valueOf('J'), "gemJade", Character.valueOf('N'), ItemMaterials.DATA.NECTAR.makeStack());
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.UMBERGOLEM_CORE.makeStack(), "AAA", "ARA", "AAA", Character.valueOf('A'), ItemMaterials.DATA.ALTAR_FRAGMENT.makeStack(), Character.valueOf('R'), ItemMaterials.DATA.RED_GEM.makeStack());
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.UMBERGOLEM_HEAD.makeStack(), "SSS", "SHS", "SMS", Character.valueOf('S'), "stone", Character.valueOf('H'), new ItemStack(ModItems.reinCompoundGoggles, 1), Character.valueOf('M'), ItemMaterials.DATA.STAG_BEETLE_MANDIBLES.makeStack());
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.UMBERGOLEM_CLAW.makeStack(), "  P", "  S", " SS", Character.valueOf('S'), "stone", Character.valueOf('P'), ItemMaterials.DATA.SCORPION_PINCER.makeStack());
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.UMBERGOLEM_CLAW.makeStack(), "SSP", "S  ", Character.valueOf('S'), "stone", Character.valueOf('P'), ItemMaterials.DATA.SCORPION_PINCER.makeStack());
        RecipeHandler.addShapedRecipe(ItemMaterials.DATA.UMBERGOLEM_LEGS.makeStack(), "SSS", "S S", "R R", Character.valueOf('S'), "stone", Character.valueOf('R'), ItemMaterials.DATA.REINFORCED_PLATE_EXO.makeStack());
        RecipeHandler.addShapedRecipe(ItemDungeonIdols.IDOL.MUD_UMBERGOLEM.makeStack(), "XXX", "XUX", "XXX", Character.valueOf('X'), ModBlocks.mudBricks, Character.valueOf('U'), ModBlocks.umberGolemStatue);
        RecipeHandler.addShapedRecipe(ItemDungeonIdols.IDOL.IRON_UMBERGOLEM.makeStack(), "XXX", "XUX", "XXX", Character.valueOf('X'), "blockIron", Character.valueOf('U'), ModBlocks.umberGolemStatue);
        RecipeHandler.addShapedRecipe(ItemDungeonIdols.IDOL.GOLD_UMBERGOLEM.makeStack(), "XXX", "XUX", "XXX", Character.valueOf('X'), "blockGold", Character.valueOf('U'), ModBlocks.umberGolemStatue);
        RecipeHandler.addShapedRecipe(ItemDungeonIdols.IDOL.JADE_UMBERGOLEM.makeStack(), "XXX", "XUX", "XXX", Character.valueOf('X'), "blockJade", Character.valueOf('U'), ModBlocks.umberGolemStatue);
        RecipeHandler.addShapedRecipe(new ItemStack(ModBlocks.umberGolemStatue), " H ", "LCL", " X ", Character.valueOf('H'), ItemMaterials.DATA.UMBERGOLEM_HEAD.makeStack(), Character.valueOf('L'), ItemMaterials.DATA.UMBERGOLEM_CLAW.makeStack(), Character.valueOf('C'), ItemMaterials.DATA.UMBERGOLEM_CORE.makeStack(), Character.valueOf('X'), ItemMaterials.DATA.UMBERGOLEM_LEGS.makeStack());
        RecipeHandler.addShapedRecipe(new ItemStack(ModItems.wandOfAnimation), " xy", " zx", "x  ", Character.valueOf('x'), "ingotGold", Character.valueOf('y'), ItemMaterials.DATA.SOUL_CRYSTAL.makeStack(), Character.valueOf('z'), "stickWood");
        RecipeHandler.addShapelessRecipe(new ItemStack(ModItems.witherWebSlinger), new ItemStack(ModItems.webSlinger), new ItemStack(Blocks.field_150425_aM), ItemMaterials.DATA.POISON_GLAND.makeStack(), new ItemStack(ModBlocks.witherWeb), new ItemStack(ModBlocks.witherWeb), new ItemStack(ModBlocks.witherWeb));
        RecipeHandler.addShapelessRecipe(new ItemStack(ModBlocks.lightningSpeedBlock), new ItemStack(ModBlocks.velocityBlock), ItemMaterials.DATA.SUPERNATURAL_VELOCITY.makeStack(), ItemMaterials.DATA.SUPERNATURAL_VELOCITY.makeStack(), ItemMaterials.DATA.SUPERNATURAL_VELOCITY.makeStack(), ItemMaterials.DATA.SUPERNATURAL_VELOCITY.makeStack(), ItemMaterials.DATA.SUPERNATURAL_VELOCITY.makeStack(), ItemMaterials.DATA.SUPERNATURAL_VELOCITY.makeStack(), ItemMaterials.DATA.SUPERNATURAL_VELOCITY.makeStack(), ItemMaterials.DATA.SUPERNATURAL_VELOCITY.makeStack());
        RecipeHandler.addShapelessRecipe(new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(ModItems.deathCompass));
    }

    private static void registerSmelting() {
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.amber), (ItemStack)new ItemStack(ModBlocks.amber, 1, 1), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.BEETLE_LARVA_RAW.ordinal()), (ItemStack)new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.BEETLE_LARVA_COOKED.ordinal()), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.GRASSHOPPER_LEG_RAW.ordinal()), (ItemStack)new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.GRASSHOPPER_LEG_COOKED.ordinal()), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.TARANTULA_LEG_RAW.ordinal()), (ItemStack)new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.TARANTULA_LEG_COOKED.ordinal()), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.TITAN_CHOP_RAW.ordinal()), (ItemStack)new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.TITAN_CHOP_COOKED.ordinal()), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.PRICKLY_PAIR_RAW.ordinal()), (ItemStack)new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.PRICKLY_PAIR_COOKED.ordinal()), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.umberstone, 1, 1), (ItemStack)new ItemStack(ModBlocks.umberstone), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreCoal), (ItemStack)new ItemStack(Items.field_151044_h, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreIron), (ItemStack)new ItemStack(Items.field_151042_j), (float)0.7f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreGold), (ItemStack)new ItemStack(Items.field_151043_k), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreLapis), (ItemStack)new ItemStack(Items.field_151100_aR, 1, 4), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreDiamond), (ItemStack)new ItemStack(Items.field_151045_i), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreEmerald), (ItemStack)new ItemStack(Items.field_151166_bC), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreJade), (ItemStack)ItemMaterials.DATA.JADE.makeStack(), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreFossil), (ItemStack)ItemMaterials.DATA.SHARD_BONE.makeStack(), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreGneiss), (ItemStack)ItemMaterials.DATA.GNEISS_ROCK.makeStack(), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.orePetrifiedWood), (ItemStack)ItemMaterials.DATA.PETRIFIED_WOOD.makeStack(), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreEncrustedDiamond), (ItemStack)new ItemStack(ModItems.encrustedDiamond), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)ItemMaterials.DATA.TITAN_STEW.makeStack(), (ItemStack)new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.TITAN_STEW_COOKED.ordinal()), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.stagHeartRaw), (ItemStack)new ItemStack(ModItems.stagHeartCooked), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.mud), (ItemStack)ItemMaterials.DATA.MUD_BRICK.makeStack(), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)ItemMaterials.DATA.NECTAR.makeStack(), (ItemStack)ItemMaterials.DATA.HONEY_DRIP.makeStack(), (float)0.2f);
        if (OreSettings.OreType.LEAD.isEnabled()) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreLead), (ItemStack)ItemMaterials.DATA.INGOT_LEAD.makeStack(), (float)1.0f);
        }
        if (OreSettings.OreType.SILVER.isEnabled()) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreSilver), (ItemStack)ItemMaterials.DATA.INGOT_SILVER.makeStack(), (float)1.0f);
        }
        if (OreSettings.OreType.COPPER.isEnabled()) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreCopper), (ItemStack)ItemMaterials.DATA.INGOT_COPPER.makeStack(), (float)1.0f);
        }
        if (OreSettings.OreType.TIN.isEnabled()) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreTin), (ItemStack)ItemMaterials.DATA.INGOT_TIN.makeStack(), (float)1.0f);
        }
        if (OreSettings.OreType.ALUMINIUM.isEnabled()) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.oreAluminium), (ItemStack)ItemMaterials.DATA.INGOT_ALUMINIUM.makeStack(), (float)1.0f);
        }
    }

    private static void registerOreDictionary() {
        OreDictionary.registerOre((String)"chestWood", (ItemStack)new ItemStack((Block)Blocks.field_150486_ae));
        OreDictionary.registerOre((String)"buttonWood", (ItemStack)new ItemStack(Blocks.field_150471_bO));
        OreDictionary.registerOre((String)"fenceWood", (ItemStack)new ItemStack(Blocks.field_150422_aJ));
        OreDictionary.registerOre((String)"oreCoal", (ItemStack)new ItemStack(ModBlocks.oreCoal));
        OreDictionary.registerOre((String)"oreIron", (ItemStack)new ItemStack(ModBlocks.oreIron));
        OreDictionary.registerOre((String)"oreGold", (ItemStack)new ItemStack(ModBlocks.oreGold));
        OreDictionary.registerOre((String)"oreLapis", (ItemStack)new ItemStack(ModBlocks.oreLapis));
        OreDictionary.registerOre((String)"oreDiamond", (ItemStack)new ItemStack(ModBlocks.oreDiamond));
        OreDictionary.registerOre((String)"oreEmerald", (ItemStack)new ItemStack(ModBlocks.oreEmerald));
        OreDictionary.registerOre((String)"oreJade", (ItemStack)new ItemStack(ModBlocks.oreJade));
        OreDictionary.registerOre((String)"orePetrifiedWood", (ItemStack)new ItemStack(ModBlocks.orePetrifiedWood));
        OreDictionary.registerOre((String)"oreDiamond", (ItemStack)new ItemStack(ModBlocks.oreEncrustedDiamond));
        OreDictionary.registerOre((String)"oreFossil", (ItemStack)new ItemStack(ModBlocks.oreFossil));
        OreDictionary.registerOre((String)"oreGneiss", (ItemStack)new ItemStack(ModBlocks.oreGneiss));
        OreDictionary.registerOre((String)"oreQuartz", (ItemStack)new ItemStack(ModBlocks.oreQuartz));
        OreDictionary.registerOre((String)"cobblestone", (ItemStack)new ItemStack(ModBlocks.umberstone, 1, 1));
        OreDictionary.registerOre((String)"stone", (ItemStack)new ItemStack(ModBlocks.umberstone));
        OreDictionary.registerOre((String)"stoneUmber", (ItemStack)new ItemStack(ModBlocks.umberstone));
        OreDictionary.registerOre((String)"mobEgg", (ItemStack)new ItemStack(ModItems.spawnEggs, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"gemJade", (ItemStack)ItemMaterials.DATA.JADE.makeStack());
        OreDictionary.registerOre((String)"blockJade", (ItemStack)new ItemStack(ModBlocks.jadeBlock));
        OreDictionary.registerOre((String)"blockSpawner", (Block)ModBlocks.spiderSpawner);
        OreDictionary.registerOre((String)"blockSpawner", (Block)ModBlocks.jumpingSpiderSpawner);
        OreDictionary.registerOre((String)"blockSpawner", (Block)ModBlocks.waspSpawner);
        OreDictionary.registerOre((String)"gemDiamond", (Item)ModItems.encrustedDiamond);
        OreDictionary.registerOre((String)"blockGlass", (ItemStack)new ItemStack(ModBlocks.amber, 1, 1));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ModBlocks.saplessLog));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ModBlocks.scorchedWood));
        OreDictionary.registerOre((String)"bamboo", (ItemStack)ItemMaterials.DATA.BAMBOO.makeStack());
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(ModBlocks.planks, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(ModBlocks.varnishedPlanks));
        OreDictionary.registerOre((String)"plankVarnished", (ItemStack)new ItemStack(ModBlocks.varnishedPlanks));
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(ModBlocks.scorchedPlanks));
        OreDictionary.registerOre((String)"plankScorched", (ItemStack)new ItemStack(ModBlocks.scorchedPlanks));
        OreDictionary.registerOre((String)"plankPetrified", (ItemStack)new ItemStack(ModBlocks.petrifiedWoodPlanks));
        for (EnumWood wood : EnumWood.values()) {
            OreDictionary.registerOre((String)("plank" + (Object)((Object)wood)), (ItemStack)new ItemStack(ModBlocks.planks, 1, wood.ordinal()));
        }
        OreDictionary.registerOre((String)"dyeBlack", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.BLACK_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyeRed", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.RED_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyeBrown", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.BROWN_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyeBlue", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.BLUE_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyePurple", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.PURPLE_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyeCyan", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.CYAN_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyeLightGray", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.LIGHT_GRAY_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyeGray", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.GRAY_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyePink", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.PINK_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyeYellow", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.YELLOW_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyeLightBlue", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.LIGHT_BLUE_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyeMagenta", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.MAGENTA_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyeOrange", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.ORANGE_PETAL.ordinal()));
        OreDictionary.registerOre((String)"dyeWhite", (ItemStack)new ItemStack(ModBlocks.erebusFlower, 1, BlockErebusFlower.FLOWER_TYPE.WHITE_PETAL.ordinal()));
        OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ModBlocks.darkCapped));
        OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ModBlocks.kaizersFinger));
        OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ModBlocks.sarcasticCzech));
        OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ModBlocks.grandmasShoes));
        OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ModBlocks.dutchCap));
        OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack((Block)Blocks.field_150337_Q));
        OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack((Block)Blocks.field_150338_P));
        OreDictionary.registerOre((String)"dropHoney", (ItemStack)ItemMaterials.DATA.HONEY_DRIP.makeStack());
        OreDictionary.registerOre((String)"bucketHoney", (ItemStack)new ItemStack(ModItems.bucketHoney));
        OreDictionary.registerOre((String)"bucketHoney", (ItemStack)new ItemStack(ModItems.bambucketHoney));
        if (OreSettings.OreType.LEAD.isEnabled()) {
            OreDictionary.registerOre((String)"ingotLead", (ItemStack)ItemMaterials.DATA.INGOT_LEAD.makeStack());
            OreDictionary.registerOre((String)"oreLead", (ItemStack)new ItemStack(ModBlocks.oreLead));
        }
        if (OreSettings.OreType.SILVER.isEnabled()) {
            OreDictionary.registerOre((String)"ingotSilver", (ItemStack)ItemMaterials.DATA.INGOT_SILVER.makeStack());
            OreDictionary.registerOre((String)"oreSilver", (ItemStack)new ItemStack(ModBlocks.oreSilver));
        }
        if (OreSettings.OreType.COPPER.isEnabled()) {
            OreDictionary.registerOre((String)"ingotCopper", (ItemStack)ItemMaterials.DATA.INGOT_COPPER.makeStack());
            OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(ModBlocks.oreCopper));
        }
        if (OreSettings.OreType.TIN.isEnabled()) {
            OreDictionary.registerOre((String)"ingotTin", (ItemStack)ItemMaterials.DATA.INGOT_TIN.makeStack());
            OreDictionary.registerOre((String)"oreTin", (ItemStack)new ItemStack(ModBlocks.oreTin));
        }
        if (OreSettings.OreType.ALUMINIUM.isEnabled()) {
            OreDictionary.registerOre((String)"ingotAluminium", (ItemStack)ItemMaterials.DATA.INGOT_ALUMINIUM.makeStack());
            OreDictionary.registerOre((String)"oreAluminum", (ItemStack)new ItemStack(ModBlocks.oreAluminium));
        }
    }

    private static void addShapedRecipe(ItemStack output, Object ... objects) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, objects));
    }

    private static void addShapelessRecipe(ItemStack output, Object ... objects) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(output, objects));
    }
}

