/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModBlocks;
import erebus.recipes.ComposterRegistry;
import erebus.tileentity.TileEntityBasicInventory;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityComposter
extends TileEntityBasicInventory {
    public int composterBurnTime;
    public int currentItemBurnTime;
    public int composterCookTime;

    public TileEntityComposter() {
        super(3, "container.composter");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.composterBurnTime = nbt.func_74765_d("BurnTime");
        this.composterCookTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityComposter.getItemBurnTime(this.inventory[1]);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.composterBurnTime);
        nbt.func_74777_a("CookTime", (short)this.composterCookTime);
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int cookTime) {
        return this.composterCookTime * cookTime / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int burnTime) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.composterBurnTime * burnTime / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.composterBurnTime > 0;
    }

    public void func_145845_h() {
        boolean flag = this.composterBurnTime > 0;
        boolean flag1 = false;
        if (this.composterBurnTime > 0) {
            --this.composterBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.composterBurnTime != 0 || this.inventory[1] != null && this.inventory[0] != null) {
                if (this.composterBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.composterBurnTime = TileEntityComposter.getItemBurnTime(this.inventory[1]);
                    if (this.composterBurnTime > 0) {
                        flag1 = true;
                        if (this.inventory[1] != null) {
                            --this.inventory[1].field_77994_a;
                            if (this.inventory[1].field_77994_a == 0) {
                                this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.composterCookTime;
                    if (this.composterCookTime == 200) {
                        this.composterCookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.composterCookTime = 0;
                }
            }
            if (flag != this.composterBurnTime > 0) {
                boolean blockActive;
                flag1 = true;
                boolean tileActive = this.composterBurnTime > 0;
                int meta = this.func_145832_p();
                boolean bl = blockActive = meta == 1;
                if (blockActive && !tileActive) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
                }
                if (!blockActive && tileActive) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
                }
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemStack itemstack = ComposterRegistry.isCompostable(this.inventory[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.inventory[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.inventory[2].func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = ComposterRegistry.isCompostable(this.inventory[0]);
            if (this.inventory[2] == null) {
                this.inventory[2] = itemstack.func_77946_l();
            } else if (this.inventory[2].func_77973_b() == itemstack.func_77973_b()) {
                this.inventory[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
        }
    }

    public static int getItemBurnTime(ItemStack is) {
        if (is == null) {
            return 0;
        }
        Item item = is.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == ModBlocks.wallPlants && is.func_77960_j() == 1) {
                return 800;
            }
            if (block == ModBlocks.wallPlantsCultivated && is.func_77960_j() == 1) {
                return 400;
            }
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack is) {
        return TileEntityComposter.getItemBurnTime(is) > 0;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 2 ? false : (slot == 1 ? TileEntityComposter.isItemFuel(is) : true);
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack is, int side) {
        return this.func_94041_b(slot, is);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot == 2;
    }
}

