/*
 * Decompiled with CFR 0.152.
 */
package erebus.world;

import cpw.mods.fml.common.eventhandler.Event;
import erebus.ModBiomes;
import erebus.ModBlocks;
import erebus.core.handler.configs.ConfigHandler;
import erebus.world.SpawnerErebus;
import erebus.world.biomes.BiomeBaseErebus;
import erebus.world.feature.structure.WorldGenSpiderDungeons;
import erebus.world.structure.MapGenErebusCaves;
import erebus.world.structure.MapGenErebusRavine;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;

public class ChunkProviderErebus
implements IChunkProvider {
    private final World worldObj;
    private final Random rand;
    private final NoiseGeneratorOctaves noiseGen1;
    private final NoiseGeneratorOctaves noiseGen2;
    private final NoiseGeneratorOctaves noiseGen3;
    private final NoiseGeneratorOctaves noiseGen4;
    private final NoiseGeneratorOctaves noiseGen5;
    private final NoiseGeneratorOctaves noiseGen6;
    private double[] noiseArray;
    private double[] stoneNoise;
    private double[] noiseData1;
    private double[] noiseData2;
    private double[] noiseData3;
    private double[] noiseData4;
    private double[] noiseData5;
    private NoiseGeneratorPerlin perlinAdditional1;
    private NoiseGeneratorPerlin perlinAdditional2;
    private BiomeGenBase[] biomesForGeneration;
    private final MapGenBase caveGenerator;
    private final MapGenBase ravineGenerator;
    public static int swampWaterHeight = 24;

    public ChunkProviderErebus(World world, long seed) {
        this.worldObj = world;
        this.rand = new Random(seed + 1L);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinAdditional1 = new NoiseGeneratorPerlin(this.rand, 4);
        this.perlinAdditional2 = new NoiseGeneratorPerlin(this.rand, 4);
        this.stoneNoise = new double[256];
        this.caveGenerator = new MapGenErebusCaves();
        this.ravineGenerator = new MapGenErebusRavine();
    }

    public void generateTerrain(int x, int z, Block[] blocks) {
        int byte0 = 4;
        int i = byte0 + 1;
        int byte2 = 17;
        int j = byte0 + 1;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.noiseArray = this.initializeNoiseField(this.noiseArray, x * byte0, 0, z * byte0, i, byte2, j);
        for (int k = 0; k < byte0; ++k) {
            for (int l = 0; l < byte0; ++l) {
                for (int i1 = 0; i1 < 16; ++i1) {
                    double d = 0.125;
                    double d1 = this.noiseArray[((k + 0) * j + l + 0) * byte2 + i1 + 0];
                    double d2 = this.noiseArray[((k + 0) * j + l + 1) * byte2 + i1 + 0];
                    double d3 = this.noiseArray[((k + 1) * j + l + 0) * byte2 + i1 + 0];
                    double d4 = this.noiseArray[((k + 1) * j + l + 1) * byte2 + i1 + 0];
                    double d5 = (this.noiseArray[((k + 0) * j + l + 0) * byte2 + i1 + 1] - d1) * d;
                    double d6 = (this.noiseArray[((k + 0) * j + l + 1) * byte2 + i1 + 1] - d2) * d;
                    double d7 = (this.noiseArray[((k + 1) * j + l + 0) * byte2 + i1 + 1] - d3) * d;
                    double d8 = (this.noiseArray[((k + 1) * j + l + 1) * byte2 + i1 + 1] - d4) * d;
                    for (int j1 = 0; j1 < 8; ++j1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k1 = 0; k1 < 4; ++k1) {
                            int l1 = k1 + k * 4 << 11 | 0 + l * 4 << 7 | i1 * 8 + j1;
                            int c = 128;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int i2 = 0; i2 < 4; ++i2) {
                                blocks[l1] = Blocks.field_150350_a;
                                if (d15 > 0.0) {
                                    blocks[l1] = ModBlocks.umberstone;
                                }
                                l1 += c;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public Chunk func_73154_d(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        Block[] blocks = new Block[32768];
        byte[] metadata = new byte[32768];
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.generateTerrain(x, z, blocks);
        this.replaceBlocksForBiome(x, z, blocks, metadata, this.biomesForGeneration);
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, x, z, blocks);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, x, z, blocks);
        Chunk chunk = new Chunk(this.worldObj, blocks, metadata, x, z);
        byte[] biomeArrayReference = chunk.func_76605_m();
        for (int a = 0; a < biomeArrayReference.length; ++a) {
            biomeArrayReference[a] = (byte)this.biomesForGeneration[a].field_76756_M;
        }
        chunk.func_76603_b();
        chunk.func_76613_n();
        return chunk;
    }

    private double[] initializeNoiseField(double[] noise, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        if (noise == null) {
            noise = new double[sizeX * sizeY * sizeZ];
        }
        double d = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.noiseGen5.func_76304_a(this.noiseData4, x, y, z, sizeX, 1, sizeZ, 1.0, 0.0, 1.0);
        this.noiseData5 = this.noiseGen6.func_76304_a(this.noiseData5, x, y, z, sizeX, 1, sizeZ, 100.0, 0.0, 100.0);
        this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, x, y, z, sizeX, sizeY, sizeZ, d * 0.0125, d1 / 60.0, d * 0.0125);
        this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, x, y, z, sizeX, sizeY, sizeZ, d, d1, d);
        this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, x, y, z, sizeX, sizeY, sizeZ, d, d1, d);
        int index = 0;
        int j = 0;
        double[] ad = new double[sizeY];
        double oneOver512 = 0.001953125;
        double groundNoiseMp = 4.8828125E-4;
        for (int k = 0; k < sizeY; ++k) {
            ad[k] = Math.cos((double)k * Math.PI * 6.0 / (double)sizeY) * 2.0;
            double d2 = k;
            if (k > sizeY / 2) {
                d2 = sizeY - 1 - k;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = k;
            ad[n] = ad[n] - d2 * d2 * d2 * 10.0;
        }
        for (int xx = 0; xx < sizeX; ++xx) {
            for (int zz = 0; zz < sizeZ; ++zz) {
                double d3 = (this.noiseData4[j] + 256.0) * oneOver512;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.noiseData5[j] * 1.25E-4;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 *= 0.5;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)sizeY * 0.0625;
                ++j;
                for (int yy = 0; yy < sizeY; ++yy) {
                    double d6 = 0.0;
                    double d7 = ad[yy];
                    double d8 = this.noiseData2[index] * groundNoiseMp;
                    double d9 = this.noiseData3[index] * groundNoiseMp;
                    double d10 = (this.noiseData1[index] * 0.1 + 1.0) * 0.5;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (yy > sizeY - 4) {
                        double d11 = (float)(yy - (sizeY - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)yy < d4) {
                        double d12 = (d4 - (double)yy) * 0.25;
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 > 1.0) {
                            d12 = 1.0;
                        }
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    noise[index] = d6;
                    ++index;
                }
            }
        }
        return noise;
    }

    public void replaceBlocksForBiome(int x, int z, Block[] blocks, byte[] metadata, BiomeGenBase[] biomes) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, x, z, blocks, metadata, biomes, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        int var5 = 0;
        this.stoneNoise = this.noiseGen4.func_76304_a(this.stoneNoise, x * 16, z * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        double d0 = 0.03125;
        double[] additionalNoise1 = new double[256];
        double[] additionalNoise2 = new double[256];
        additionalNoise1 = this.perlinAdditional1.func_151599_a(additionalNoise1, (double)(x * 16), (double)(z * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        additionalNoise2 = this.perlinAdditional2.func_151599_a(additionalNoise2, (double)(x * 16), (double)(z * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
            for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                int h;
                int horIndex = zInChunk + xInChunk * 16;
                BiomeBaseErebus biome = (BiomeBaseErebus)biomes[horIndex];
                float temperature = biome.func_150564_a(0, 0, 0);
                int var12 = (int)(this.stoneNoise[xInChunk + zInChunk * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var13 = -1;
                Block topBlock = biome.field_76752_A;
                Block fillerBlock = biome.field_76753_B;
                int preHeightIndex = (zInChunk * 16 + xInChunk) * 128;
                if (biome == ModBiomes.submergedSwamp) {
                    if (additionalNoise1[horIndex] > 0.0) {
                        h = this.getLowestAirBlock(blocks, preHeightIndex, 25, 35);
                        if (h > swampWaterHeight) {
                            h += 0;
                            while ((double)h > 23.08 - additionalNoise1[horIndex]) {
                                blocks[preHeightIndex + h] = h == swampWaterHeight ? (this.rand.nextInt(32) == 0 ? Blocks.field_150392_bi : Blocks.field_150350_a) : Blocks.field_150350_a;
                                --h;
                            }
                            blocks[preHeightIndex + h] = additionalNoise1[horIndex] < 0.08 ? (ConfigHandler.INSTANCE.generateVents ? (this.rand.nextInt(12) == 0 ? ModBlocks.swampVent : ModBlocks.umberstone) : ModBlocks.umberstone) : (additionalNoise1[horIndex] < 0.5 ? Blocks.field_150354_m : (additionalNoise1[horIndex] < 1.0 ? ModBlocks.quickSand : (additionalNoise2[horIndex] > 1.0 ? ModBlocks.mud : Blocks.field_150346_d)));
                        }
                    } else if (additionalNoise1[horIndex] > -0.15 && (h = this.getLowestAirBlock(blocks, preHeightIndex, 25, 35)) > swampWaterHeight) {
                        h += 0;
                        while (h >= (22 + h) / 2) {
                            blocks[preHeightIndex + h] = Blocks.field_150350_a;
                            --h;
                        }
                        if (++h >= swampWaterHeight && this.rand.nextInt(8) == 0 && blocks[preHeightIndex + h] == Blocks.field_150350_a && blocks[preHeightIndex + h + 1] == Blocks.field_150350_a) {
                            Block block = ModBlocks.bullrush;
                            blocks[preHeightIndex + h + 1] = block;
                            blocks[preHeightIndex + h] = block;
                            metadata[preHeightIndex + h + 1] = 8;
                        }
                    }
                }
                if ((biome == ModBiomes.volcanicDesert || biome == ModBiomes.desertSubCharredForest) && Math.abs(additionalNoise1[horIndex]) < 1.0 && (h = this.getLowestAirBlock(blocks, preHeightIndex, 25, 32) - 1) > 0) {
                    blocks[preHeightIndex + h] = Blocks.field_150350_a;
                    int h2 = h - 1;
                    while ((double)h2 > (double)(h - 1) - 3.0 * (1.0 - Math.abs(additionalNoise1[horIndex]))) {
                        blocks[preHeightIndex + h2] = Blocks.field_150356_k;
                        --h2;
                    }
                }
                for (int yInChunk = 127; yInChunk >= 0; --yInChunk) {
                    int index = (zInChunk * 16 + xInChunk) * 128 + yInChunk;
                    if (yInChunk <= 5 && yInChunk <= 0 + this.rand.nextInt(5) || yInChunk >= 122 && yInChunk >= 127 - this.rand.nextInt(5)) {
                        blocks[index] = Blocks.field_150357_h;
                        continue;
                    }
                    Block block = blocks[index];
                    if (biome == ModBiomes.submergedSwamp && yInChunk < swampWaterHeight && block == Blocks.field_150350_a) {
                        Block block2 = blocks[index] = this.rand.nextInt(256) == 0 && blocks[index - 1].func_149662_c() && yInChunk < swampWaterHeight - 1 ? ModBlocks.mireCoral : Blocks.field_150355_j;
                    }
                    if (block.func_149688_o() == Material.field_151579_a) {
                        var13 = -1;
                        continue;
                    }
                    if (block == ModBlocks.umberstone) {
                        if (var13 != -1) continue;
                        if (var12 <= 0) {
                            topBlock = Blocks.field_150350_a;
                            fillerBlock = ModBlocks.umberstone;
                        } else if (yInChunk >= var5 - 4 && yInChunk <= var5 + 1) {
                            topBlock = biome.field_76752_A;
                            fillerBlock = biome.field_76753_B;
                        }
                        if (yInChunk < var5 && topBlock.func_149688_o() == Material.field_151579_a) {
                            topBlock = temperature < 0.15f ? Blocks.field_150432_aD : Blocks.field_150355_j;
                        }
                        var13 = var12;
                        if (yInChunk >= var5 - 1) {
                            blocks[index] = topBlock;
                            if (topBlock != biome.field_76752_A) continue;
                            metadata[index] = biome.topBlockMeta;
                            continue;
                        }
                        blocks[index] = fillerBlock;
                        if (fillerBlock != biome.field_76753_B) continue;
                        metadata[index] = biome.fillerBlockMeta;
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    blocks[index] = fillerBlock;
                    if (fillerBlock != biome.field_76753_B) continue;
                    metadata[index] = biome.fillerBlockMeta;
                }
            }
        }
    }

    private int getLowestAirBlock(Block[] blocks, int preHeightIndex, int minH, int maxH) {
        for (int h = Math.min(minH, maxH); h <= Math.max(minH, maxH); ++h) {
            if (blocks[preHeightIndex + h] != Blocks.field_150350_a) continue;
            return h;
        }
        return -1;
    }

    public void func_73153_a(IChunkProvider chunkProvider, int x, int z) {
        BlockFalling.field_149832_M = true;
        int blockCoordX = x * 16;
        int blockCoordZ = z * 16;
        BiomeGenBase biomeBase = this.worldObj.func_72807_a(blockCoordX + 16, blockCoordZ + 16);
        if (biomeBase instanceof BiomeBaseErebus) {
            BiomeBaseErebus biome = (BiomeBaseErebus)biomeBase;
            this.rand.setSeed(this.worldObj.func_72905_C());
            this.rand.setSeed((long)x * (this.rand.nextLong() / 2L * 2L + 1L) + (long)z * (this.rand.nextLong() / 2L * 2L + 1L) ^ this.worldObj.func_72905_C());
            biome.populate(this.worldObj, this.rand, blockCoordX, blockCoordZ);
            biome.func_76728_a(this.worldObj, this.rand, blockCoordX, blockCoordZ);
            SpawnerErebus.onChunkPopulate(this.worldObj, this.rand, biome, blockCoordX + 8, blockCoordZ + 8);
        }
        for (int attempt = 0; attempt < 14; ++attempt) {
            new WorldGenSpiderDungeons().func_76484_a(this.worldObj, this.rand, blockCoordX + this.rand.nextInt(16) + 8, this.rand.nextInt(128), blockCoordZ + this.rand.nextInt(16) + 8);
        }
        BlockFalling.field_149832_M = false;
    }

    public void func_82695_e(int x, int z) {
    }

    public List func_73155_a(EnumCreatureType creatureType, int x, int y, int z) {
        BiomeGenBase biome = this.worldObj.func_72807_a(x, z);
        return biome == null ? null : biome.func_76747_a(creatureType);
    }

    public String func_73148_d() {
        return "ErebusRandomLevelSource";
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public boolean func_73151_a(boolean mode, IProgressUpdate progressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public int func_73152_e() {
        return 0;
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }

    public ChunkPosition func_147416_a(World world, String structureIdentifier, int x, int y, int z) {
        return null;
    }
}

