/*
 * Decompiled with CFR 0.152.
 */
package erebus.world;

import cpw.mods.fml.common.eventhandler.Event;
import erebus.ModBiomes;
import erebus.world.biomes.BiomeBaseErebus;
import erebus.world.genlayer.GenLayerErebus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;

public class WorldChunkManagerErebus
extends WorldChunkManager {
    private static final float rainfall = 0.0f;
    private static final ArrayList<BiomeGenBase> allowedBiomes = new ArrayList<BiomeBaseErebus>(Arrays.asList(ModBiomes.undergroundJungle, ModBiomes.subterraneanSavannah));
    private final List biomesToSpawnIn = new ArrayList<BiomeGenBase>(allowedBiomes);
    private final BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private final GenLayer biomeGenLayer;

    public WorldChunkManagerErebus(World world) {
        this.biomeGenLayer = GenLayerErebus.initializeAllBiomeGenerators(world.func_72905_C(), world.func_72912_H().func_76067_t())[1];
    }

    public BiomeGenBase func_76935_a(int chunkX, int chunkZ) {
        return this.biomeCache.func_76837_b(chunkX, chunkZ);
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] biomesForGeneration, int x, int z, int sizeX, int sizeZ) {
        IntCache.func_76446_a();
        if (biomesForGeneration == null || biomesForGeneration.length < sizeX * sizeZ) {
            biomesForGeneration = new BiomeGenBase[sizeX * sizeZ];
        }
        int[] biomeArray = this.biomeGenLayer.func_75904_a(x, z, sizeX, sizeZ);
        for (int index = 0; index < sizeX * sizeZ; ++index) {
            biomesForGeneration[index] = BiomeGenBase.func_150565_n()[biomeArray[index]];
        }
        return biomesForGeneration;
    }

    public float[] func_76936_a(float[] rainfallArray, int x, int z, int sizeX, int sizeZ) {
        if (rainfallArray == null || rainfallArray.length < sizeX * sizeZ) {
            rainfallArray = new float[sizeX * sizeZ];
        }
        Arrays.fill(rainfallArray, 0, sizeX * sizeZ, 0.0f);
        return rainfallArray;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] biomesForGeneration, int x, int z, int sizeX, int sizeZ) {
        return this.func_76931_a(biomesForGeneration, x, z, sizeX, sizeZ, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] biomesForGeneration, int x, int z, int sizeX, int sizeZ, boolean useCache) {
        IntCache.func_76446_a();
        if (biomesForGeneration == null || biomesForGeneration.length < sizeX * sizeZ) {
            biomesForGeneration = new BiomeGenBase[sizeX * sizeZ];
        }
        if (useCache && sizeX == 16 && sizeZ == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            BiomeGenBase[] cachedBiomes = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(cachedBiomes, 0, biomesForGeneration, 0, sizeX * sizeZ);
            return biomesForGeneration;
        }
        int[] generatedBiomes = this.biomeGenLayer.func_75904_a(x, z, sizeX, sizeZ);
        for (int index = 0; index < sizeX * sizeZ; ++index) {
            biomesForGeneration[index] = BiomeGenBase.func_150565_n()[generatedBiomes[index]];
        }
        return biomesForGeneration;
    }

    public ChunkPosition func_150795_a(int x, int z, int checkRadius, List viableBiomes, Random rand) {
        IntCache.func_76446_a();
        int minX = x - checkRadius >> 2;
        int minZ = z - checkRadius >> 2;
        int maxX = x + checkRadius >> 2;
        int maxZ = z + checkRadius >> 2;
        int sizeX = maxX - minX + 1;
        int sizeZ = maxZ - minZ + 1;
        int[] biomeArray = this.biomeGenLayer.func_75904_a(minX, minZ, sizeX, sizeZ);
        ChunkPosition pos = null;
        int attempts = 0;
        for (int index = 0; index < sizeX * sizeZ; ++index) {
            int finalX = minX + index % sizeX << 2;
            int finalZ = minZ + index / sizeX << 2;
            if (!viableBiomes.contains(BiomeGenBase.func_150565_n()[biomeArray[index]]) || pos != null && rand.nextInt(attempts + 1) != 0) continue;
            pos = new ChunkPosition(finalX, 0, finalZ);
            ++attempts;
        }
        return pos;
    }

    public boolean func_76940_a(int x, int z, int checkRadius, List viableBiomes) {
        IntCache.func_76446_a();
        int minX = x - checkRadius >> 2;
        int minZ = z - checkRadius >> 2;
        int maxX = x + checkRadius >> 2;
        int maxZ = z + checkRadius >> 2;
        int sizeX = maxX - minX + 1;
        int sizeZ = maxZ - minZ + 1;
        int[] biomeArray = this.biomeGenLayer.func_75904_a(minX, minZ, sizeX, sizeZ);
        for (int index = 0; index < sizeX * sizeZ; ++index) {
            if (viableBiomes.contains(BiomeGenBase.func_150565_n()[biomeArray[index]])) continue;
            return false;
        }
        return true;
    }

    public List func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }

    public GenLayer[] getModdedBiomeGenerators(WorldType worldType, long seed, GenLayer[] original) {
        WorldTypeEvent.InitBiomeGens event = new WorldTypeEvent.InitBiomeGens(worldType, seed, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.newBiomeGens;
    }
}

