/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.biomes.decorators;

import erebus.ModBlocks;
import erebus.core.handler.configs.ConfigHandler;
import erebus.world.biomes.decorators.BiomeDecoratorBaseErebus;
import erebus.world.biomes.decorators.data.OreSettings;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.feature.plant.WorldGenGiantMushrooms;
import erebus.world.feature.plant.WorldGenMossPatch;
import erebus.world.feature.plant.WorldGenRottenLogs;
import erebus.world.feature.plant.WorldGenRottenTreeStump;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeDecoratorFungalForest
extends BiomeDecoratorBaseErebus {
    protected final WorldGenerator genMossPatch = new WorldGenMossPatch(0);
    protected final WorldGenerator genLichenPatch = new WorldGenMossPatch(1);
    private final WorldGenFlowers genMushroomsBrown = new WorldGenFlowers((Block)Blocks.field_150338_P);
    private final WorldGenFlowers genMushroomsRed = new WorldGenFlowers((Block)Blocks.field_150337_Q);
    private final WorldGenBigMushroom genBigMushroomRed = new WorldGenBigMushroom(0);
    private final WorldGenBigMushroom genBigMushroomBrown = new WorldGenBigMushroom(1);
    private final WorldGenGiantMushrooms genGiantMushrooms = new WorldGenGiantMushrooms();
    public static final Block[] mushrooms = new Block[]{ModBlocks.dutchCap, ModBlocks.kaizersFinger, ModBlocks.sarcasticCzech, ModBlocks.grandmasShoes, ModBlocks.darkCapped};

    @Override
    public void decorate() {
        int baseRadius;
        this.attempt = 0;
        while (this.attempt < 10) {
            int length = this.rand.nextInt(5) + 4;
            baseRadius = this.rand.nextInt(3) + 2;
            byte direction = (byte)this.rand.nextInt(2);
            this.xx = this.x + 16;
            this.yy = this.rand.nextInt(118);
            this.zz = this.z + 16;
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                new WorldGenRottenLogs(length, baseRadius, direction).func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 10) {
            int height = this.rand.nextInt(11) + 5;
            baseRadius = this.rand.nextInt(4) + 3;
            this.xx = this.x + this.offsetXZ();
            this.yy = this.rand.nextInt(128);
            this.zz = this.z + this.offsetXZ();
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                new WorldGenRottenTreeStump(height, baseRadius).func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 256) {
            this.xx = this.x + this.offsetXZ();
            this.yy = this.rand.nextInt(128);
            this.zz = this.z + this.offsetXZ();
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                this.world.func_147465_d(this.xx, this.yy, this.zz, mushrooms[this.rand.nextInt(mushrooms.length)], 0, 2);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 200) {
            int r = this.rand.nextInt(100);
            if (r < 16) {
                this.genGiantMushrooms.setMushroomType(WorldGenGiantMushrooms.MushroomType.DUTCH_CAP);
            } else if (r < 25) {
                this.genGiantMushrooms.setMushroomType(WorldGenGiantMushrooms.MushroomType.SARCASTIC_CZECH);
            } else if (r < 80) {
                this.genGiantMushrooms.setMushroomType(WorldGenGiantMushrooms.MushroomType.KAIZERS_FINGERS);
            } else if (r < 96) {
                this.genGiantMushrooms.setMushroomType(WorldGenGiantMushrooms.MushroomType.GRANDMAS_SHOES);
            } else {
                this.genGiantMushrooms.setMushroomType(WorldGenGiantMushrooms.MushroomType.BULB_CAPPED);
            }
            this.xx = this.x + this.offsetXZ();
            this.yy = 25 + this.rand.nextInt(50 + this.rand.nextInt(40));
            this.zz = this.z + this.offsetXZ();
            for (int yAttempt = 0; yAttempt < 10 && !this.checkSurface(SurfaceType.GRASS, this.xx, --this.yy, this.zz); ++yAttempt) {
            }
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz) && this.genGiantMushrooms.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz) && this.rand.nextInt(5) == 0) break;
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 100) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 20;
            while (this.yy < 100) {
                if (this.checkSurface(SurfaceType.MIXED, this.xx, this.yy, this.zz)) {
                    if (this.rand.nextInt(8) == 0 && this.world.func_147437_c(this.xx, this.yy + 1, this.zz)) {
                        this.world.func_147465_d(this.xx, this.yy, this.zz, (Block)Blocks.field_150398_cm, 3, 2);
                        this.world.func_147465_d(this.xx, this.yy + 1, this.zz, (Block)Blocks.field_150398_cm, 10, 2);
                        break;
                    }
                    this.world.func_147465_d(this.xx, this.yy, this.zz, ModBlocks.fern, 0, 2);
                    break;
                }
                this.yy += this.rand.nextBoolean() ? 2 : 1;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 20) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz) && this.world.func_147437_c(this.xx, this.yy + 1, this.zz)) {
                this.world.func_147465_d(this.xx, this.yy, this.zz, ModBlocks.tangledStalk, 0, 2);
                this.world.func_147465_d(this.xx, this.yy + 1, this.zz, ModBlocks.tangledStalk, 8, 2);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 20) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz) && this.world.func_147437_c(this.xx, this.yy + 1, this.zz)) {
                this.world.func_147465_d(this.xx, this.yy, this.zz, ModBlocks.highCapped, 0, 2);
                this.world.func_147465_d(this.xx, this.yy + 1, this.zz, ModBlocks.highCapped, 8, 2);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 10) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 30 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            if (this.world.func_147437_c(this.xx, this.yy, this.zz)) {
                this.genMossPatch.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 10) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 30 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            if (this.world.func_147437_c(this.xx, this.yy, this.zz)) {
                this.genLichenPatch.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
            }
            ++this.attempt;
        }
        this.genMushroomsBrown.func_76484_a(this.world, this.rand, this.x + this.offsetXZ(), this.rand.nextInt(128), this.z + this.offsetXZ());
        this.genMushroomsRed.func_76484_a(this.world, this.rand, this.x + this.offsetXZ(), this.rand.nextInt(128), this.z + this.offsetXZ());
        this.attempt = 0;
        while (this.attempt < 100) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                this.genBigMushroomRed.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 100) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                this.genBigMushroomBrown.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
            }
            ++this.attempt;
        }
        if (ConfigHandler.INSTANCE.glowshrooms) {
            this.attempt = 0;
            while (this.attempt < 10) {
                this.xx = this.x + this.offsetXZ();
                this.yy = 30 + this.rand.nextInt(90);
                this.zz = this.z + this.offsetXZ();
                if (this.world.func_147439_a(this.xx, this.yy, this.zz) == ModBlocks.umberstone && this.world.func_147437_c(this.xx, this.yy - 1, this.zz)) {
                    this.world.func_147465_d(this.xx, this.yy - 1, this.zz, ModBlocks.glowshroomStalkMain, 4, 2);
                }
                ++this.attempt;
            }
        }
    }

    @Override
    protected void modifyOreGen(OreSettings oreGen, OreSettings.OreType oreType, boolean extraOres) {
        switch (oreType) {
            case COAL: {
                oreGen.setIterations(extraOres ? 2 : 3, extraOres ? 3 : 4).setY(5, 48);
                break;
            }
            case IRON: {
                oreGen.setChance(0.75f).setIterations(extraOres ? 2 : 3, extraOres ? 4 : 5).setY(5, 42);
                break;
            }
            case GOLD: {
                oreGen.setIterations(extraOres ? 2 : 3);
                break;
            }
            case EMERALD: {
                oreGen.setIterations(2, 4).setCheckArea(2);
                break;
            }
            case JADE: {
                oreGen.setIterations(2, 5);
                break;
            }
            case PETRIFIED_WOOD: {
                oreGen.setChance(0.0f);
                break;
            }
            case FOSSIL: {
                oreGen.setChance(0.25f).setOreAmount(5, 8);
            }
        }
    }
}

