/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.decoration;

import erebus.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenErebusMinable
extends WorldGenerator {
    private Block minableBlock;
    private int minableBlockMeta = 0;
    private int numberOfBlocks;
    private Block blockToReplace;

    public void prepare(Block block, int meta, int numberOfBlocks) {
        this.minableBlock = block;
        this.minableBlockMeta = meta;
        this.numberOfBlocks = numberOfBlocks;
        this.blockToReplace = ModBlocks.umberstone;
    }

    public void prepare(Block block, int meta, int numberOfBlocks, Block blockToReplace) {
        this.minableBlock = block;
        this.minableBlockMeta = meta;
        this.numberOfBlocks = numberOfBlocks;
        this.blockToReplace = blockToReplace;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)(x + 8) + MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks * 0.125f;
        double d1 = (float)(x + 8) - MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks * 0.125f;
        double d2 = (float)(z + 8) + MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks * 0.125f;
        double d3 = (float)(z + 8) - MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks * 0.125f;
        double d4 = y + rand.nextInt(3) - 2;
        double d5 = y + rand.nextInt(3) - 2;
        int realNumberOfBlocks = this.numberOfBlocks;
        this.numberOfBlocks = (int)Math.ceil((float)this.numberOfBlocks * (1.15f + rand.nextFloat() * 0.25f));
        int placed = 0;
        for (int attempt = 0; attempt <= this.numberOfBlocks && placed <= realNumberOfBlocks; ++attempt) {
            double centerX = d0 + (d1 - d0) * (double)placed / (double)this.numberOfBlocks;
            double centerY = d4 + (d5 - d4) * (double)placed / (double)this.numberOfBlocks;
            double centerZ = d2 + (d3 - d2) * (double)placed / (double)this.numberOfBlocks;
            double spreadFactor = rand.nextDouble() * (double)this.numberOfBlocks * 0.0625;
            double maxDistXZ = (double)(MathHelper.func_76126_a((float)((float)placed * (float)Math.PI / (float)this.numberOfBlocks)) + 1.0f) * spreadFactor + 1.0;
            double maxDistY = (double)(MathHelper.func_76126_a((float)((float)placed * (float)Math.PI / (float)this.numberOfBlocks)) + 1.0f) * spreadFactor + 1.0;
            int minX = MathHelper.func_76128_c((double)(centerX - maxDistXZ * 0.5));
            int minY = MathHelper.func_76128_c((double)(centerY - maxDistY * 0.5));
            int minZ = MathHelper.func_76128_c((double)(centerZ - maxDistXZ * 0.5));
            int maxX = MathHelper.func_76128_c((double)(centerX + maxDistXZ * 0.5));
            int maxY = MathHelper.func_76128_c((double)(centerY + maxDistY * 0.5));
            int maxZ = MathHelper.func_76128_c((double)(centerZ + maxDistXZ * 0.5));
            for (int xx = minX; xx <= maxX; ++xx) {
                double d12 = ((double)xx + 0.5 - centerX) / (maxDistXZ * 0.5);
                if (!(d12 * d12 < 1.0)) continue;
                for (int yy = minY; yy <= maxY; ++yy) {
                    double d13 = ((double)yy + 0.5 - centerY) / (maxDistY * 0.5);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int zz = minZ; zz <= maxZ; ++zz) {
                        Block block;
                        double d14 = ((double)zz + 0.5 - centerZ) / (maxDistXZ * 0.5);
                        if (d12 * d12 + d13 * d13 + d14 * d14 >= 1.0 || (block = world.func_147439_a(xx, yy, zz)) == null || !block.isReplaceableOreGen(world, xx, yy, zz, this.blockToReplace)) continue;
                        world.func_147465_d(xx, yy, zz, this.minableBlock, this.minableBlockMeta, 2);
                        ++placed;
                    }
                }
            }
        }
        return true;
    }
}

