/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.plant;

import erebus.ModBlocks;
import erebus.core.helper.MathUtil;
import erebus.world.feature.WorldGenErebus;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenGiantMushrooms
extends WorldGenErebus {
    private static final int stalkMeta = 10;
    private static final int bulbFullMeta = 14;
    private static final Block tempBlock = Blocks.field_150357_h;
    private MushroomType mushroomType = MushroomType.BULB_CAPPED;
    private final List<ChunkCoordinates> bulbs = new ArrayList<ChunkCoordinates>();

    public void setMushroomType(MushroomType type) {
        this.mushroomType = type;
    }

    @Override
    protected boolean generate(int x, int y, int z) {
        this.bulbs.clear();
        Block mushroom = this.mushroomType.log;
        boolean res = false;
        switch (this.mushroomType) {
            case BULB_CAPPED: {
                res = this.genBulbCapped(x, y, z, mushroom);
                break;
            }
            case KAIZERS_FINGERS: {
                res = this.genKaizersFingers(x, y, z, mushroom);
                break;
            }
            case DUTCH_CAP: {
                res = this.genDutchCap(x - 1, y, z, mushroom);
                break;
            }
            case GRANDMAS_SHOES: {
                res = this.genGrandmasShoes(x - 1, y, z, mushroom);
                break;
            }
            case SARCASTIC_CZECH: {
                res = this.genSarcasticCzech(x - 1, y, z, mushroom);
            }
        }
        if (res) {
            this.generateBulbs(x, z, mushroom);
            return true;
        }
        return false;
    }

    private boolean genBulbCapped(int x, int y, int z, Block mushroom) {
        int stalkHeight;
        int sideHeight = 1 + this.rand.nextInt((stalkHeight = 3 + this.rand.nextInt(3 + this.rand.nextInt(2))) > 3 ? 3 : 2);
        if (!this.checkAirCube(x, y, z, x, y + stalkHeight - sideHeight, z) || !this.checkAirCube(x - 2, y + stalkHeight - sideHeight + 1, z - 2, x + 2, y + stalkHeight + 1, z + 2)) {
            return false;
        }
        this.setBlockPillar(x, z, y, y + stalkHeight, mushroom, 10);
        y += stalkHeight + 1;
        for (int px = -1; px <= 1; ++px) {
            for (int pz = -1; pz <= 1; ++pz) {
                this.bulbs.add(new ChunkCoordinates(x + px, y, z + pz));
            }
        }
        for (int py = 1; py <= sideHeight; ++py) {
            for (int off = -1; off <= 1; ++off) {
                this.bulbs.add(new ChunkCoordinates(x + 2, y - py, z + off));
                this.bulbs.add(new ChunkCoordinates(x - 2, y - py, z + off));
                this.bulbs.add(new ChunkCoordinates(x + off, y - py, z + 2));
                this.bulbs.add(new ChunkCoordinates(x + off, y - py, z - 2));
            }
        }
        return true;
    }

    private boolean genKaizersFingers(int x, int y, int z, Block mushroom) {
        int mainShroomHeight = 4 + this.rand.nextInt(4);
        if (!(this.checkAirCube(x - 1, y + 3, z - 1, x + 1, y + mainShroomHeight + 1, z + 1) && this.checkAirCube(x - 4, y, z - 4, x + 4, y + 2, z + 4) && this.checkSolidCube(x - 4, y - 1, z - 4, x + 4, y - 1, z + 4))) {
            return false;
        }
        int sidesPlaced = 0;
        for (int py = 0; py <= mainShroomHeight; ++py) {
            this.setBlock(x, y + py, z, mushroom, 10);
            if (py < 2 || py >= mainShroomHeight - 1 || this.rand.nextInt(4 + sidesPlaced * 2) != 0) continue;
            int dir = this.rand.nextInt(4);
            this.setBlock(x + Direction.field_71583_a[dir], y + py, z + Direction.field_71581_b[dir], mushroom, 14);
            ++sidesPlaced;
        }
        this.bulbs.add(new ChunkCoordinates(x, y + mainShroomHeight + 1, z));
        for (int a = 0; a < 4; ++a) {
            this.bulbs.add(new ChunkCoordinates(x + Direction.field_71583_a[a], y + mainShroomHeight, z + Direction.field_71581_b[a]));
        }
        ArrayList<ChunkCoordinates> connectList = new ArrayList<ChunkCoordinates>();
        connectList.add(new ChunkCoordinates(x, y - 1, z));
        for (int smallShroomAttempt = 0; smallShroomAttempt < 4 + this.rand.nextInt(7); ++smallShroomAttempt) {
            int zz;
            int xx = x + this.rand.nextInt(4) - this.rand.nextInt(4);
            if (!this.isAir(xx, y, zz = z + this.rand.nextInt(4) - this.rand.nextInt(4)) || !this.isAir(xx - 1, y, zz) || !this.isAir(xx + 1, y, zz) || !this.isAir(xx, y, zz - 1) || !this.isAir(xx, y, zz + 1)) continue;
            int smallShroomHeight = this.rand.nextBoolean() ? 1 : 1 + this.rand.nextInt(2);
            this.setBlockPillar(xx, zz, y, y + smallShroomHeight - 1, mushroom, 10);
            this.setBlock(xx, y + smallShroomHeight, zz, mushroom, 14);
            connectList.add(new ChunkCoordinates(xx, y - 1, zz));
        }
        int coordAmt = connectList.size();
        for (int connectionAttempt = 0; connectionAttempt < 48; ++connectionAttempt) {
            int zz;
            int dir;
            int xx;
            double dist;
            ChunkCoordinates coords2;
            ChunkCoordinates coords1 = (ChunkCoordinates)connectList.get(this.rand.nextInt(coordAmt));
            ChunkCoordinates chunkCoordinates = coords2 = this.rand.nextInt(3) != 0 ? (ChunkCoordinates)connectList.get(0) : (ChunkCoordinates)connectList.get(this.rand.nextInt(coordAmt));
            if (coords1 == coords2 || (dist = MathUtil.distance(coords1.field_71574_a - coords2.field_71574_a, coords1.field_71573_c - coords2.field_71573_c)) < 1.0 || !(MathUtil.distance((xx = coords1.field_71574_a + Direction.field_71583_a[dir = this.rand.nextInt(4)]) - coords2.field_71574_a, (zz = coords1.field_71573_c + Direction.field_71581_b[dir]) - coords2.field_71573_c) < dist)) continue;
            this.setBlock(xx, y - 1, zz, mushroom, 10);
            if (this.rand.nextInt(16) == 0) {
                this.setBlock(xx, y, zz, mushroom, 10);
            }
            coords1.field_71574_a = xx;
            coords1.field_71573_c = zz;
        }
        return true;
    }

    private boolean genDutchCap(int x, int y, int z, Block mushroom) {
        int height = 9 + this.rand.nextInt(8);
        if (!(this.checkAirCube(x - 2, y, z - 2, x + 3, y + 4, z + 3) && this.checkAirCube(x - 3, y + 5, z - 3, x + 5, y + height + 1, z + 5) && this.checkAirCube(x - 4, y + height + 2, z - 4, x + 7, y + height + 4, z + 7) && this.checkSolidCube(x - 2, y - 1, z - 2, x + 3, y - 1, z + 3))) {
            return false;
        }
        for (int a = 0; a < 2; ++a) {
            for (int b = 0; b < 2; ++b) {
                this.setBlockPillar(x - 1 + 3 * a, z + b, y, y + 1, mushroom, 10);
                this.setBlockPillar(x + b, z - 1 + 3 * a, y, y + 1, mushroom, 10);
                this.setBlock(x - 1 + 3 * a, y, z - 1 + 3 * b, mushroom, 10);
                this.setBlock(x - 2 + 5 * a, y, z + b, mushroom, 10);
                this.setBlock(x + b, y, z - 2 + 5 * a, mushroom, 10);
            }
        }
        this.setBlockCube(x, y, z, x + 1, y + height, z + 1, mushroom, 10);
        for (int py = 4; py <= height; ++py) {
            boolean isTop;
            boolean bl = isTop = py >= height - 1;
            if (this.rand.nextInt(3) != 0 && !isTop) continue;
            for (int attempt = 0; attempt < (isTop ? 2 : 1); ++attempt) {
                int b;
                int a;
                int branchAddX = 0;
                int branchAddZ = 0;
                for (int branchAttempt = 0; branchAttempt < 12 && branchAddX == 0 && branchAddZ == 0; ++branchAttempt) {
                    branchAddX = this.rand.nextInt(3) != 0 ? 0 : this.rand.nextInt(3) - 1;
                    branchAddZ = this.rand.nextInt(3) != 0 ? 0 : this.rand.nextInt(3) - 1;
                }
                if (branchAddX == 0 && branchAddZ == 0 || !this.checkAirCube(x + branchAddX * 2, y + py - 2, z + branchAddZ * 2, x + branchAddX * 2 + 1, y + py, z + branchAddZ * 2 + 1)) continue;
                int branchSize = isTop ? 3 + this.rand.nextInt(2) : 2 + this.rand.nextInt(2 + this.rand.nextInt(2));
                for (int branch = 1; branch <= branchSize; ++branch) {
                    this.setBlockRect(x + branchAddX * branch, z + branchAddZ * branch, x + branchAddX * branch + 1, z + branchAddZ * branch + 1, y + py - 1 + branch, mushroom, 10);
                    if (!isTop) continue;
                    this.setBlockRect(x + branchAddX * branch, z + branchAddZ * branch, x + branchAddX * branch + 1, z + branchAddZ * branch + 1, y + py + branch, mushroom, 10);
                }
                int branchTopX = x + branchAddX * branchSize;
                int branchTopY = y + py + branchSize;
                int branchTopZ = z + branchAddZ * branchSize;
                if (isTop) {
                    this.setBlockRect(branchTopX, branchTopZ, branchTopX + 1, branchTopZ + 1, branchTopY + 1, mushroom, 10);
                    branchTopY += 2;
                    for (a = 0; a < 2; ++a) {
                        for (b = 0; b < 2; ++b) {
                            if (this.isAir(branchTopX + a, branchTopY, branchTopZ + b)) {
                                this.setBlock(branchTopX + a, branchTopY, branchTopZ + b, mushroom, 14);
                            }
                            if (this.isAir(branchTopX - 1 + 3 * a, branchTopY - 1, branchTopZ + b)) {
                                this.setBlock(branchTopX - 1 + 3 * a, branchTopY - 1, branchTopZ + b, mushroom, 14);
                            }
                            if (this.isAir(branchTopX + b, branchTopY - 1, branchTopZ - 1 + 3 * a)) {
                                this.setBlock(branchTopX + b, branchTopY - 1, branchTopZ - 1 + 3 * a, mushroom, 14);
                            }
                            if (this.isAir(branchTopX - 1 + 3 * a, branchTopY - 2, branchTopZ - 1 + 3 * b)) {
                                this.setBlock(branchTopX - 1 + 3 * a, branchTopY - 2, branchTopZ - 1 + 3 * b, mushroom, 14);
                            }
                            if (this.isAir(branchTopX - 2 + 5 * a, branchTopY - 2, branchTopZ + b)) {
                                this.setBlock(branchTopX - 2 + 5 * a, branchTopY - 2, branchTopZ + b, mushroom, 14);
                            }
                            if (!this.isAir(branchTopX + b, branchTopY - 2, branchTopZ - 2 + 5 * a)) continue;
                            this.setBlock(branchTopX + b, branchTopY - 2, branchTopZ - 2 + 5 * a, mushroom, 14);
                        }
                    }
                    continue;
                }
                for (a = 0; a < 2; ++a) {
                    for (b = 0; b < 2; ++b) {
                        if (this.isAir(branchTopX + a, branchTopY, branchTopZ + b)) {
                            this.setBlock(branchTopX + a, branchTopY, branchTopZ + b, mushroom, 14);
                        }
                        if (this.isAir(branchTopX - 1 + 3 * a, branchTopY - 1, branchTopZ + b)) {
                            this.setBlock(branchTopX - 1 + 3 * a, branchTopY - 1, branchTopZ + b, mushroom, 14);
                        }
                        if (!this.isAir(branchTopX + b, branchTopY - 1, branchTopZ - 1 + 3 * a)) continue;
                        this.setBlock(branchTopX + b, branchTopY - 1, branchTopZ - 1 + 3 * a, mushroom, 14);
                    }
                }
            }
        }
        return true;
    }

    private boolean genGrandmasShoes(int x, int y, int z, Block mushroom) {
        int b;
        int a;
        int splitOffZ;
        int height = 5 + this.rand.nextInt(8);
        int splits = this.rand.nextInt(height > 8 ? 3 : 2);
        int splitSize = splits == 0 ? height : (int)Math.ceil((float)height / (1.0f + (float)splits));
        int splitDir = splits != 0 ? this.rand.nextInt(4) : -1;
        int splitOffX = splitDir == -1 ? 0 : Direction.field_71583_a[splitDir];
        int n = splitOffZ = splitDir == -1 ? 0 : Direction.field_71581_b[splitDir];
        if (!(this.checkAirCube(x - 1, y, z - 1, x + 2, y + height - 2, z + 2) && this.checkAirCube(x - 3 + splitOffX, z - 3 + splitOffZ, y + height - 1, x + 3 + splitOffX, y + height + 1, z + 3 + splitOffZ) && this.checkSolidCube(x - 1, y - 1, z - 1, x + 3, y - 1, z + 3))) {
            return false;
        }
        for (a = 0; a < 2; ++a) {
            for (b = 0; b < 2; ++b) {
                this.setBlockRect(x - 1 + 3 * b, z, x - 1 + 3 * b, z + 1, y, mushroom, 10);
                this.setBlockRect(x, z - 1 + 3 * b, x + 1, z - 1 + 3 * b, y, mushroom, 10);
            }
        }
        int split = splitSize;
        for (int py = 0; py <= height; ++py) {
            this.setBlockRect(x, z, x + 1, z + 1, y + py, mushroom, 10);
            if (--split >= 0 || py >= height) continue;
            x += splitOffX;
            z += splitOffZ;
            split = splitSize - 1;
        }
        for (a = 0; a < 2; ++a) {
            for (b = 0; b < 2; ++b) {
                this.bulbs.add(new ChunkCoordinates(x + a, y + height + 1, z + b));
                this.bulbs.add(new ChunkCoordinates(x - 1 + 3 * a, y + height + 1, z + b));
                this.bulbs.add(new ChunkCoordinates(x + b, y + height + 1, z - 1 + 3 * a));
                this.setBlock(x - 1 + 3 * a, y + height, z - 1 + 3 * b, mushroom, 5);
                this.bulbs.add(new ChunkCoordinates(x - 2 + 5 * a, y + height - 1, z - 2 + 5 * b));
            }
            for (b = 0; b < 4; ++b) {
                this.bulbs.add(new ChunkCoordinates(x - 2 + 5 * a, y + height, z - 1 + b));
                this.bulbs.add(new ChunkCoordinates(x - 1 + b, y + height, z - 2 + 5 * a));
                this.bulbs.add(new ChunkCoordinates(x - 3 + 7 * a, y + height - 1, z - 1 + b));
                this.bulbs.add(new ChunkCoordinates(x - 1 + b, y + height - 1, z - 3 + 7 * a));
            }
        }
        return true;
    }

    private boolean genSarcasticCzech(int x, int y, int z, Block mushroom) {
        int height = 2 + this.rand.nextInt(3);
        int armLength = 4 + this.rand.nextInt(3);
        if (!this.checkAirCube(x, y, z, x, y + height, z) || !this.checkAirCube(x - armLength, y + height, z - armLength, x + armLength, y + height + 1, z + armLength)) {
            return false;
        }
        this.setBlockPillar(x, z, y, y + height, mushroom, 10);
        this.setBlockPillar(x + 1, z, y, y + height, mushroom, 10);
        this.setBlockPillar(x, z + 1, y, y + height, mushroom, 10);
        this.setBlockPillar(x + 1, z + 1, y, y + height, mushroom, 10);
        y += height;
        for (ForgeDirection[] dirs : new ForgeDirection[][]{{ForgeDirection.EAST, ForgeDirection.SOUTH}, {ForgeDirection.EAST, ForgeDirection.NORTH}, {ForgeDirection.WEST, ForgeDirection.SOUTH}, {ForgeDirection.WEST, ForgeDirection.NORTH}}) {
            int i;
            int xx = x + dirs[0].offsetX;
            int yy = y;
            int zz = z + dirs[0].offsetZ;
            for (i = 0; i < armLength; ++i) {
                if (i % 2 == 0) {
                    ++yy;
                } else {
                    ForgeDirection dir = dirs[this.rand.nextInt(dirs.length)];
                    xx += dir.offsetX;
                    zz += dir.offsetZ;
                }
                this.setBlock(xx, yy, zz, mushroom, 10);
            }
            this.setBlock(xx, yy + 1, zz, mushroom, 14);
            for (i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    this.setBlock(xx + i, yy, zz + j, mushroom, 14);
                }
            }
        }
        this.setBlockRect(x, z, x + 1, z + 1, y + 1, mushroom, 14);
        this.setBlockRect(x - 1, z - 1, x + 2, z + 2, y, mushroom, 14);
        return true;
    }

    private void generateBulbs(int centerX, int centerZ, Block mushroom) {
        for (ChunkCoordinates bulb : this.bulbs) {
            this.setBlock(bulb.field_71574_a, bulb.field_71572_b, bulb.field_71573_c, tempBlock);
        }
        for (ChunkCoordinates bulb : this.bulbs) {
            this.setMetadata(bulb.field_71574_a, bulb.field_71572_b, bulb.field_71573_c, this.getBulbMetadata(centerX, centerZ, bulb));
        }
        for (ChunkCoordinates bulb : this.bulbs) {
            this.setBlock(bulb.field_71574_a, bulb.field_71572_b, bulb.field_71573_c, mushroom, this.getMetadata(bulb.field_71574_a, bulb.field_71572_b, bulb.field_71573_c));
        }
        this.bulbs.clear();
    }

    private int getBulbMetadata(int centerX, int centerZ, ChunkCoordinates bulb) {
        boolean negZ;
        boolean posX = this.getBlock(bulb.field_71574_a + 1, bulb.field_71572_b, bulb.field_71573_c) == tempBlock;
        boolean negX = this.getBlock(bulb.field_71574_a - 1, bulb.field_71572_b, bulb.field_71573_c) == tempBlock;
        boolean posZ = this.getBlock(bulb.field_71574_a, bulb.field_71572_b, bulb.field_71573_c + 1) == tempBlock;
        boolean bl = negZ = this.getBlock(bulb.field_71574_a, bulb.field_71572_b, bulb.field_71573_c - 1) == tempBlock;
        if (posX && negX && posZ && negZ) {
            return 5;
        }
        if (posX && negX) {
            if (bulb.field_71573_c > centerZ) {
                return 8;
            }
            return 2;
        }
        if (posZ && negZ) {
            if (bulb.field_71574_a > centerX) {
                return 6;
            }
            return 4;
        }
        if (posX && posZ) {
            return 1;
        }
        if (negX && negZ) {
            return 9;
        }
        if (negX && posZ) {
            return 3;
        }
        if (posX && negZ) {
            return 7;
        }
        int sides = (posX ? 1 : 0) + (negX ? 1 : 0) + (posZ ? 1 : 0) + (negZ ? 1 : 0);
        if (sides > 1) {
            return 0;
        }
        boolean posXposZ = this.getBlock(bulb.field_71574_a + 1, bulb.field_71572_b, bulb.field_71573_c + 1) == tempBlock;
        boolean negXposZ = this.getBlock(bulb.field_71574_a - 1, bulb.field_71572_b, bulb.field_71573_c + 1) == tempBlock;
        boolean posXnegZ = this.getBlock(bulb.field_71574_a + 1, bulb.field_71572_b, bulb.field_71573_c - 1) == tempBlock;
        boolean negXnegZ = this.getBlock(bulb.field_71574_a - 1, bulb.field_71572_b, bulb.field_71573_c - 1) == tempBlock;
        int corners = (posXposZ ? 1 : 0) + (negXposZ ? 1 : 0) + (posXnegZ ? 1 : 0) + (negXnegZ ? 1 : 0);
        if (sides == 0 && corners == 0) {
            return 14;
        }
        if (posXposZ && negXposZ || negXnegZ && posXnegZ || posXposZ && posXnegZ || negXposZ && negXnegZ) {
            return 14;
        }
        if (sides == 0 && corners == 2) {
            for (int dir = 0; dir < 4; ++dir) {
                int meta = this.getMetadata(bulb.field_71574_a + Direction.field_71583_a[dir], bulb.field_71572_b - 1, bulb.field_71573_c + Direction.field_71581_b[dir]);
                if (meta == 0) continue;
                return meta;
            }
        }
        if (sides == 1 && corners == 1 || sides == 0 && corners == 2) {
            if (bulb.field_71574_a > centerX) {
                if (bulb.field_71573_c > centerZ) {
                    return 9;
                }
                return 3;
            }
            if (bulb.field_71573_c > centerZ) {
                return 7;
            }
            return 1;
        }
        return 0;
    }

    public static enum MushroomType {
        BULB_CAPPED(ModBlocks.darkCapped, ModBlocks.bigBulbCappedMushroom),
        GRANDMAS_SHOES(ModBlocks.grandmasShoes, ModBlocks.bigGreenMushroom),
        SARCASTIC_CZECH(ModBlocks.sarcasticCzech, ModBlocks.bigBundleMushroom),
        KAIZERS_FINGERS(ModBlocks.kaizersFinger, ModBlocks.bigKaiserfingerMushroom),
        DUTCH_CAP(ModBlocks.dutchCap, ModBlocks.bigDutchCapMushroom);

        public final Block mushroom;
        public final Block log;

        private MushroomType(Block mushroom, Block log) {
            this.log = log;
            this.mushroom = mushroom;
        }

        public static MushroomType getFromShroom(Block block) {
            for (MushroomType type : MushroomType.values()) {
                if (type.mushroom != block) continue;
                return type;
            }
            return null;
        }
    }
}

