/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.structure;

import erebus.ModBiomes;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.core.helper.Utils;
import erebus.item.ItemErebusFood;
import erebus.item.ItemMaterials;
import erebus.item.ItemSmoothie;
import erebus.tileentity.TileEntityBones;
import erebus.tileentity.TileEntitySlidingBlockPuzzle;
import erebus.world.feature.util.PerfectMazeGenerator;
import erebus.world.loot.IPostProcess;
import erebus.world.loot.LootItemStack;
import erebus.world.loot.LootUtil;
import erebus.world.loot.WeightedLootList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class AntHillMazeDungeon {
    private Block solid = ModBlocks.anthillBlock;
    private Block stairs = ModBlocks.anthillStairs;
    private List<IInventory> chests = new ArrayList<IInventory>();
    private static final WeightedLootList chestLoot = new WeightedLootList(new LootItemStack[]{new LootItemStack(Items.field_151122_aG).setAmount(1, 4).setWeight(18), new LootItemStack(Items.field_151121_aF).setAmount(2, 6).setWeight(16), new LootItemStack(Blocks.field_150321_G).setAmount(2, 7).setWeight(13), new LootItemStack(ModItems.materials).setAmount(1, 3).setDamage(ItemMaterials.DATA.JADE.ordinal()).setWeight(10), new LootItemStack(ModItems.materials).setAmount(4, 8).setDamage(ItemMaterials.DATA.PLATE_EXO.ordinal()).setWeight(9), new LootItemStack((Item)Items.field_151134_bR).setWeight(8), new LootItemStack(ModBlocks.umberGolemStatue).setAmount(1).setWeight(1), new LootItemStack(ModItems.webSlinger).setAmount(1).setWeight(1), new LootItemStack(Items.field_151005_D).setWeight(3), new LootItemStack(Items.field_151035_b).setWeight(2), new LootItemStack(ModItems.jadePickaxe).setWeight(1), new LootItemStack(Items.field_151011_C).setWeight(3), new LootItemStack(Items.field_151037_a).setWeight(2), new LootItemStack(ModItems.jadeShovel).setWeight(1), new LootItemStack(Items.field_151006_E).setWeight(3), new LootItemStack(Items.field_151036_c).setWeight(2), new LootItemStack(ModItems.jadeAxe).setWeight(1), new LootItemStack(Items.field_151010_B).setWeight(3), new LootItemStack(Items.field_151040_l).setWeight(2), new LootItemStack(ModItems.jadeSword).setWeight(1), new LootItemStack((Item)Items.field_151030_Z).setWeight(2), new LootItemStack(ModItems.jadeBody).setWeight(1), new LootItemStack((Item)Items.field_151171_ah).setWeight(1), new LootItemStack((Item)Items.field_151028_Y).setWeight(2), new LootItemStack(ModItems.jadeHelmet).setWeight(1), new LootItemStack((Item)Items.field_151169_ag).setWeight(1), new LootItemStack((Item)Items.field_151165_aa).setWeight(2), new LootItemStack(ModItems.jadeLegs).setWeight(1), new LootItemStack((Item)Items.field_151149_ai).setWeight(1), new LootItemStack((Item)Items.field_151167_ab).setWeight(2), new LootItemStack(ModItems.jadeBoots).setWeight(1), new LootItemStack((Item)Items.field_151151_aj).setWeight(1), new LootItemStack(ModItems.materials).setAmount(1).setDamage(ItemMaterials.DATA.ALTAR_FRAGMENT.ordinal()).setWeight(1), new LootItemStack(ModItems.materials).setAmount(1).setDamage(ItemMaterials.DATA.REINFORCED_PLATE_EXO.ordinal()).setWeight(1), new LootItemStack(ModItems.materials).setAmount(1).setDamage(ItemMaterials.DATA.SCORPION_PINCER.ordinal()).setWeight(1), new LootItemStack(ModItems.materials).setAmount(1, 3).setDamage(ItemMaterials.DATA.WHETSTONE_POWDER.ordinal()).setWeight(3), new LootItemStack(ModItems.materials).setAmount(1).setDamage(ItemMaterials.DATA.PLATE_EXO_RHINO.ordinal()).setWeight(1), new LootItemStack(ModItems.food).setAmount(1, 3).setDamage(ItemErebusFood.FoodType.HONEY_SANDWICH.ordinal()).setWeight(3), new LootItemStack(ModItems.cabbageSeeds).setAmount(1, 3).setWeight(2), new LootItemStack(ModItems.whetstone).setAmount(1).setDamage(0).setWeight(1), new LootItemStack(ModItems.lifeBlood).setAmount(1, 2).setWeight(4), new LootItemStack(ModItems.rolledNewspaper).setAmount(1).setWeight(1), new LootItemStack(ModItems.waspDagger).setAmount(1, 3).setWeight(2), new LootItemStack(ModItems.bucketAntiVenom).setAmount(1).setWeight(1), new LootItemStack(ModItems.bucketBeetleJuice).setAmount(1).setWeight(1), new LootItemStack(ModItems.bucketHoney).setAmount(1).setWeight(1), new LootItemStack(ModBlocks.glowGemBlock).setAmount(1, 3).setWeight(5), new LootItemStack(ModItems.homingBeecon).setAmount(1).setWeight(1), new LootItemStack(ModItems.smoothie).setAmount(1, 3).setDamage(ItemSmoothie.SmoothieType.GIVIN_ME_THE_BLUES.ordinal()).setWeight(3), new LootItemStack(ModItems.smoothie).setAmount(1).setDamage(ItemSmoothie.SmoothieType.BRYUFS_BREW.ordinal()).setWeight(1)}).setPostProcessor(new IPostProcess(){

        @Override
        public ItemStack postProcessItem(ItemStack is, Random rand) {
            if (is.func_77973_b() == Items.field_151134_bR || rand.nextBoolean() && (is.func_77973_b() instanceof ItemTool || is.func_77973_b() instanceof ItemArmor || is.func_77973_b() instanceof ItemSword)) {
                boolean enchBook;
                boolean bl = enchBook = is.func_77973_b() == Items.field_151134_bR;
                if (enchBook) {
                    is.func_150996_a(Items.field_151122_aG);
                }
                List enchList = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)is, (int)(7 + rand.nextInt(10)));
                if (enchBook) {
                    is.func_150996_a((Item)Items.field_151134_bR);
                }
                if (enchList != null && enchList.size() > 0) {
                    for (int a = 0; a < enchList.size(); ++a) {
                        EnchantmentData data = (EnchantmentData)enchList.get(a);
                        if (is.func_77973_b() == Items.field_151134_bR) {
                            Items.field_151134_bR.func_92115_a(is, data);
                            continue;
                        }
                        is.func_77966_a(data.field_76302_b, data.field_76303_c);
                    }
                }
            }
            return is;
        }
    });

    private void generateSurface(World world, Random rand, int chunkX, int chunkY, int chunkZ, boolean hasKey) {
        BiomeGenBase biomeBase = world.func_72807_a(chunkX, chunkZ);
        if (biomeBase == ModBiomes.fungalForest) {
            this.generate(world, rand, chunkX, chunkY, chunkZ, hasKey);
        }
    }

    private void generate(World world, Random rand, int x, int y, int z, boolean hasKey) {
        int sizeX = 16;
        int sizeY = y + 5;
        int sizeZ = 16;
        int mazeWidth = sizeX / 2;
        int mazeHeight = sizeZ / 2;
        if (mazeWidth < 2 || mazeHeight < 2 || sizeY < 1) {
            return;
        }
        this.chests.clear();
        int[][] maze = null;
        PerfectMazeGenerator generator = new PerfectMazeGenerator(mazeWidth, mazeHeight);
        maze = generator.generateMaze();
        block4: for (int yy = y; yy < sizeY; ++yy) {
            switch ((yy - y) % 5) {
                case 0: {
                    this.buildLevel(world, x, yy + 2, z, mazeWidth, mazeHeight, maze, this.solid, 0);
                    this.buildLevel(world, x, yy + 3, z, mazeWidth, mazeHeight, maze, this.solid, 0);
                    this.buildLevel(world, x, yy + 4, z, mazeWidth, mazeHeight, maze, this.solid, 0);
                    this.createAir(world, x, yy + 3, z + 1, mazeWidth, mazeHeight, rand);
                    this.addFeature(world, x, yy + 3, z, mazeWidth, mazeHeight, maze, rand);
                    continue block4;
                }
                case 1: {
                    this.buildFloor(world, x, yy - 1, z, mazeWidth, mazeHeight, rand, false, false);
                    this.buildFloor(world, x, yy, z, mazeWidth, mazeHeight, rand, true, false);
                    this.buildRoof(world, x, yy + 4, z, mazeWidth, mazeHeight, rand);
                }
            }
        }
        if (hasKey && !this.chests.isEmpty()) {
            IInventory randomInvt = this.chests.get(rand.nextInt(this.chests.size()));
            TileEntityBones.allowInsertion = true;
            Utils.addItemStackToInventory(randomInvt, ItemMaterials.DATA.FORCE_KEY.makeStack());
            TileEntityBones.allowInsertion = false;
            System.out.println("Added key to inventory at: " + ((TileEntity)randomInvt).field_145851_c + ", " + ((TileEntity)randomInvt).field_145848_d + ", " + ((TileEntity)randomInvt).field_145849_e);
        }
        System.out.println("Generated Maze At: X: " + x + " Y: " + y + " Z: " + z);
    }

    public void makeMaze(World world, Random rand, int x, int y, int z) {
        int yy = y;
        for (int floors = 0; floors < 6; ++floors) {
            if (floors < 4 && floors > 0) {
                this.generate(world, rand, x, yy, z, true);
            }
            if (floors < 4) {
                if (yy - y == 5 || yy - y == 15) {
                    world.func_147449_b(x + 1, yy + 2, z + 1, this.solid);
                    world.func_147449_b(x + 1, yy + 3, z + 1, this.solid);
                    world.func_147449_b(x + 1, yy + 4, z + 1, this.solid);
                    world.func_147465_d(x + 1, yy + 5, z + 1, this.stairs, 3, 2);
                    if (world.func_147437_c(x + 1, yy + 2, z + 2)) {
                        world.func_147449_b(x + 1, yy + 2, z + 2, this.solid);
                    }
                    world.func_147449_b(x + 1, yy + 3, z + 2, this.solid);
                    world.func_147465_d(x + 1, yy + 4, z + 2, this.stairs, 3, 2);
                    world.func_147465_d(x + 1, yy + 3, z + 3, this.stairs, 1, 2);
                    world.func_147449_b(x + 1, yy + 2, z + 3, this.solid);
                    world.func_147465_d(x + 2, yy + 2, z + 3, this.stairs, 1, 2);
                } else {
                    world.func_147449_b(x + 31, yy + 2, z + 31, this.solid);
                    world.func_147449_b(x + 31, yy + 3, z + 31, this.solid);
                    world.func_147449_b(x + 31, yy + 4, z + 31, this.solid);
                    world.func_147465_d(x + 31, yy + 5, z + 31, this.stairs, 2, 2);
                    if (world.func_147437_c(x + 31, yy + 2, z + 30)) {
                        world.func_147449_b(x + 31, yy + 2, z + 30, this.solid);
                    }
                    world.func_147449_b(x + 31, yy + 3, z + 30, this.solid);
                    world.func_147465_d(x + 31, yy + 4, z + 30, this.stairs, 2, 2);
                    world.func_147465_d(x + 31, yy + 3, z + 29, this.stairs, 0, 2);
                    world.func_147449_b(x + 31, yy + 2, z + 29, this.solid);
                    world.func_147465_d(x + 30, yy + 2, z + 29, this.stairs, 0, 2);
                }
            }
            if (floors == 0) {
                for (int xx = x; xx <= x + 32; ++xx) {
                    for (int zz = z; zz <= z + 32; ++zz) {
                        for (int y2 = y; y2 < y + 5; ++y2) {
                            if (y2 <= y + 1) continue;
                            if (world.func_147439_a(xx, y2, zz) != this.solid && world.func_147439_a(xx, y2, zz) != this.stairs) {
                                world.func_147468_f(xx, y2, zz);
                            }
                            if (rand.nextInt(10) == 0) {
                                world.func_147465_d(xx, y2, z, ModBlocks.soldierAntTrap, 3, 2);
                            } else {
                                world.func_147449_b(xx, y2, z, this.solid);
                            }
                            if (rand.nextInt(10) == 0) {
                                world.func_147465_d(xx, y2, z + 32, ModBlocks.soldierAntTrap, 2, 2);
                            } else {
                                world.func_147449_b(xx, y2, z + 32, this.solid);
                            }
                            if (rand.nextInt(10) == 0) {
                                world.func_147465_d(x, y2, zz, ModBlocks.soldierAntTrap, 5, 2);
                            } else {
                                world.func_147449_b(x, y2, zz, this.solid);
                            }
                            if (rand.nextInt(10) == 0) {
                                world.func_147465_d(x + 32, y2, zz, ModBlocks.soldierAntTrap, 4, 2);
                            } else {
                                world.func_147449_b(x + 32, y2, zz, this.solid);
                            }
                            if (zz <= z + 6 || zz > z + 9 && zz <= z + 22 || zz > z + 25) {
                                if (rand.nextInt(10) == 0) {
                                    world.func_147465_d(x + 16, y2, zz, ModBlocks.soldierAntTrap, 4, 2);
                                } else if (rand.nextInt(10) == 0) {
                                    world.func_147465_d(x + 16, y2, zz, ModBlocks.soldierAntTrap, 5, 2);
                                } else {
                                    world.func_147449_b(x + 16, y2, zz, this.solid);
                                }
                            }
                            if (xx > x + 6 && (xx <= x + 9 || xx > x + 22) && xx <= x + 25) continue;
                            if (rand.nextInt(10) == 0) {
                                world.func_147465_d(xx, y2, z + 16, ModBlocks.soldierAntTrap, 2, 2);
                                continue;
                            }
                            if (rand.nextInt(10) == 0) {
                                world.func_147465_d(xx, y2, z + 16, ModBlocks.soldierAntTrap, 3, 2);
                                continue;
                            }
                            world.func_147449_b(xx, y2, z + 16, this.solid);
                        }
                    }
                }
                this.buildFloor(world, x, yy, z, 8, 8, rand, false, false);
                this.buildFloor(world, x, yy + 1, z, 8, 8, rand, true, true);
                TileEntitySlidingBlockPuzzle.createPuzzleAt(world, x + 16, y + 3, z + 8, ForgeDirection.getOrientation((int)ForgeDirection.WEST.ordinal()), TileEntitySlidingBlockPuzzle.SlidingPuzzle.TEST);
                TileEntitySlidingBlockPuzzle.createPuzzleAt(world, x + 16, y + 3, z + 24, ForgeDirection.getOrientation((int)ForgeDirection.EAST.ordinal()), TileEntitySlidingBlockPuzzle.SlidingPuzzle.TEST);
                TileEntitySlidingBlockPuzzle.createPuzzleAt(world, x + 8, y + 3, z + 16, ForgeDirection.getOrientation((int)ForgeDirection.SOUTH.ordinal()), TileEntitySlidingBlockPuzzle.SlidingPuzzle.TEST);
                TileEntitySlidingBlockPuzzle.createPuzzleAt(world, x + 24, y + 3, z + 16, ForgeDirection.getOrientation((int)ForgeDirection.NORTH.ordinal()), TileEntitySlidingBlockPuzzle.SlidingPuzzle.TEST);
            }
            if (floors == 4) {
                this.generateMainDome(world, x + 16, yy + 1, z + 16);
                this.gererateEntrance(world, x + 2, yy + 1, z + 2);
            }
            if (yy - y == 15 || yy - y == 25) {
                world.func_147468_f(x + 1, yy - 4, z + 1);
                world.func_147468_f(x + 1, yy - 4, z + 2);
                world.func_147468_f(x + 1, yy - 4, z + 3);
                world.func_147468_f(x + 1, yy - 5, z + 2);
                world.func_147468_f(x + 1, yy - 5, z + 3);
                world.func_147468_f(x + 1, yy - 6, z + 3);
                world.func_147468_f(x + 2, yy - 5, z + 3);
                world.func_147468_f(x + 2, yy - 6, z + 3);
                if (yy - y != 25) {
                    world.func_147449_b(x + 1, yy - 3, z + 1, ModBlocks.forceField);
                    world.func_147465_d(x + 1, yy - 3, z + 2, ModBlocks.forceLock, 2, 2);
                    world.func_147449_b(x + 1, yy - 3, z + 3, ModBlocks.forceField);
                }
            } else if (yy - y == 10 || yy - y == 20) {
                world.func_147468_f(x + 31, yy - 4, z + 31);
                world.func_147468_f(x + 31, yy - 4, z + 30);
                world.func_147468_f(x + 31, yy - 4, z + 29);
                world.func_147468_f(x + 31, yy - 5, z + 30);
                world.func_147468_f(x + 31, yy - 5, z + 29);
                world.func_147468_f(x + 31, yy - 6, z + 29);
                world.func_147468_f(x + 30, yy - 5, z + 29);
                world.func_147468_f(x + 30, yy - 6, z + 29);
                world.func_147449_b(x + 31, yy - 3, z + 31, ModBlocks.forceField);
                world.func_147465_d(x + 31, yy - 3, z + 30, ModBlocks.forceLock, 0, 2);
                world.func_147449_b(x + 31, yy - 3, z + 29, ModBlocks.forceField);
            }
            System.out.println("Y height is:  floor: " + (yy - y));
            yy += 5;
        }
    }

    private void gererateEntrance(World world, int x, int y, int z) {
        for (int xx = x - 5; xx <= x + 5; ++xx) {
            for (int zz = z - 5; zz <= z + 5; ++zz) {
                for (int yy = y; yy < y + 5; ++yy) {
                    double dSqDome = Math.pow(xx - x, 2.0) + Math.pow(zz - z, 2.0) + Math.pow(yy - y, 2.0);
                    if (Math.round(Math.sqrt(dSqDome)) >= 5L) continue;
                    if (dSqDome >= Math.pow(3.0, 2.0)) {
                        world.func_147465_d(xx, yy, zz, this.solid, 0, 2);
                        continue;
                    }
                    world.func_147449_b(xx, yy, zz, Blocks.field_150350_a);
                }
            }
        }
        world.func_147468_f(x, y + 1, z - 3);
        world.func_147468_f(x, y + 2, z - 3);
        world.func_147468_f(x, y + 1, z - 4);
        world.func_147468_f(x, y + 2, z - 4);
        world.func_147468_f(x - 3, y + 1, z);
        world.func_147468_f(x - 3, y + 2, z);
        world.func_147468_f(x - 4, y + 1, z);
        world.func_147468_f(x - 4, y + 2, z);
    }

    private void generateMainDome(World world, int x, int y, int z) {
        for (int xx = x - 17; xx <= x + 17; ++xx) {
            for (int zz = z - 17; zz <= z + 17; ++zz) {
                for (int yy = y; yy < y + 17; ++yy) {
                    double dSqDome = Math.pow(xx - x, 2.0) + Math.pow(zz - z, 2.0) + Math.pow(yy - y, 2.0);
                    if (Math.round(Math.sqrt(dSqDome)) >= 17L) continue;
                    if (dSqDome >= Math.pow(15.0, 2.0) || yy == y) {
                        world.func_147465_d(xx, yy, zz, this.solid, 0, 2);
                        continue;
                    }
                    world.func_147468_f(xx, yy, zz);
                }
            }
        }
    }

    private void createAir(World world, int x, int y, int z, int w, int h, Random rand) {
        for (int i = 0; i <= h * 4; ++i) {
            for (int j = 0; j <= w * 4; ++j) {
                for (int k = 0; k <= 2; ++k) {
                    if (world.func_147439_a(x + j, y + k, z + i) == this.solid) continue;
                    world.func_147468_f(x + j, y + k, z + i);
                }
            }
        }
    }

    private void buildRoof(World world, int x, int y, int z, int w, int h, Random rand) {
        for (int i = 0; i <= h * 4; ++i) {
            for (int j = 0; j <= w * 4; ++j) {
                if (!world.func_147437_c(x + j, y, z + i)) continue;
                world.func_147465_d(x + j, y, z + i, this.solid, 1, 2);
            }
        }
    }

    private void buildFloor(World world, int x, int y, int z, int w, int h, Random rand, boolean addFeature, boolean addSpawners) {
        for (int i = 0; i <= h * 4; ++i) {
            for (int j = 0; j <= w * 4; ++j) {
                if (rand.nextInt(15) == 0 && addFeature && world.func_147439_a(x + j, y + 1, z + i) != this.solid) {
                    if (rand.nextBoolean() && rand.nextBoolean()) {
                        world.func_147449_b(x + j, y, z + i, ModBlocks.formicAcid);
                        continue;
                    }
                    if (rand.nextInt(6) == 0 && addSpawners) {
                        world.func_147465_d(x + j, y, z + i, ModBlocks.zombieAntSpawner, 0, 2);
                        continue;
                    }
                    if (rand.nextInt(6) == 0 && addSpawners) {
                        world.func_147465_d(x + j, y, z + i, ModBlocks.zombieAntSoldierSpawner, 0, 2);
                        continue;
                    }
                    world.func_147465_d(x + j, y, z + i, ModBlocks.puffShroom, 3, 2);
                    continue;
                }
                if (world.func_147439_a(x + j, y, z + i) == ModBlocks.zombieAntSoldierSpawner || world.func_147439_a(x + j, y, z + i) == ModBlocks.zombieAntSpawner) continue;
                world.func_147465_d(x + j, y, z + i, this.solid, 0, 2);
            }
        }
    }

    private void addFeature(World world, int x, int y, int z, int w, int h, int[][] maze, Random rand) {
        for (int i = 0; i < h; ++i) {
            int randOffset;
            int j;
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 1) != 0) continue;
                if (world.func_147439_a(x + j * 4, y + 1, z + 1 + i * 4) != this.solid) {
                    world.func_147465_d(x + j * 4, y + 1, z + 1 + i * 4, this.stairs, 7, 3);
                }
                world.func_147465_d(x + 1 + j * 4, y + 1, z + 1 + i * 4, this.stairs, 7, 3);
                world.func_147465_d(x + 2 + j * 4, y + 1, z + 1 + i * 4, this.stairs, 7, 3);
                world.func_147465_d(x + 3 + j * 4, y + 1, z + 1 + i * 4, this.stairs, 7, 3);
                if (world.func_147439_a(x + 4 + j * 4, y + 1, z + 1 + i * 4) != this.solid) {
                    world.func_147465_d(x + 4 + j * 4, y + 1, z + 1 + i * 4, this.stairs, 7, 3);
                }
                if (rand.nextInt(25) == 0) {
                    world.func_147465_d(x + 1 + j * 4, y, z + 1 + i * 4, Blocks.field_150478_aa, 3, 2);
                    if (rand.nextInt(4) == 0) {
                        this.placeChest(world, x + 1 + j * 4, y - 1, z + 1 + i * 4, 3, rand);
                        continue;
                    }
                    if (rand.nextInt(6) != 0) continue;
                    this.placeBones(world, x + 1 + j * 4, y - 1, z + 1 + i * 4, 3, rand);
                    continue;
                }
                if (rand.nextInt(6) == 0) {
                    if (rand.nextBoolean()) {
                        world.func_147449_b(x + 2 + j * 4, y - 2, z + 2 + i * 4, ModBlocks.zombieAntSpawner);
                        continue;
                    }
                    world.func_147449_b(x + 2 + j * 4, y - 2, z + 2 + i * 4, ModBlocks.zombieAntSoldierSpawner);
                    continue;
                }
                if (rand.nextInt(10) != 0) continue;
                randOffset = rand.nextInt(2);
                world.func_147465_d(x + 1 + j * 4, y - randOffset, z + i * 4, ModBlocks.soldierAntTrap, 3, 2);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 8) != 0) continue;
                if (world.func_147439_a(x + 1 + j * 4, y + 1, z + i * 4) != this.solid) {
                    world.func_147465_d(x + 1 + j * 4, y + 1, z + i * 4, this.stairs, 5, 3);
                }
                world.func_147465_d(x + 1 + j * 4, y + 1, z + 1 + i * 4, this.stairs, 5, 3);
                world.func_147465_d(x + 1 + j * 4, y + 1, z + 2 + i * 4, this.stairs, 5, 3);
                world.func_147465_d(x + 1 + j * 4, y + 1, z + 3 + i * 4, this.stairs, 5, 3);
                if (world.func_147439_a(x + 1 + j * 4, y + 1, z + 4 + i * 4) != this.solid) {
                    world.func_147465_d(x + 1 + j * 4, y + 1, z + 4 + i * 4, this.stairs, 5, 3);
                }
                if (rand.nextInt(25) == 0) {
                    world.func_147465_d(x + 1 + j * 4, y, z + 2 + i * 4, Blocks.field_150478_aa, 1, 2);
                    if (rand.nextInt(4) == 0) {
                        this.placeChest(world, x + 1 + j * 4, y - 1, z + 2 + i * 4, 1, rand);
                        continue;
                    }
                    if (rand.nextInt(6) != 0) continue;
                    this.placeBones(world, x + 1 + j * 4, y - 1, z + 2 + i * 4, 5, rand);
                    continue;
                }
                if (rand.nextInt(10) != 0) continue;
                randOffset = rand.nextInt(2);
                world.func_147465_d(x + j * 4, y - randOffset, z + 2 + i * 4, ModBlocks.soldierAntTrap, 5, 2);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 4) != 0) continue;
                if (world.func_147439_a(x + 3 + j * 4, y + 1, z + i * 4) != this.solid) {
                    world.func_147465_d(x + 3 + j * 4, y + 1, z + i * 4, this.stairs, 4, 3);
                }
                world.func_147465_d(x + 3 + j * 4, y + 1, z + 1 + i * 4, this.stairs, 4, 3);
                world.func_147465_d(x + 3 + j * 4, y + 1, z + 2 + i * 4, this.stairs, 4, 3);
                world.func_147465_d(x + 3 + j * 4, y + 1, z + 3 + i * 4, this.stairs, 4, 3);
                if (world.func_147439_a(x + 3 + j * 4, y + 1, z + 4 + i * 4) != this.solid) {
                    world.func_147465_d(x + 3 + j * 4, y + 1, z + 4 + i * 4, this.stairs, 4, 3);
                }
                if (rand.nextInt(25) == 0) {
                    world.func_147465_d(x + 3 + j * 4, y, z + 2 + i * 4, Blocks.field_150478_aa, 2, 2);
                    if (rand.nextInt(4) == 0) {
                        this.placeChest(world, x + 3 + j * 4, y - 1, z + 2 + i * 4, 2, rand);
                    } else if (rand.nextInt(6) == 0) {
                        this.placeBones(world, x + 3 + j * 4, y - 1, z + 2 + i * 4, 4, rand);
                    }
                }
                if (rand.nextInt(10) != 0) continue;
                randOffset = rand.nextInt(2);
                world.func_147465_d(x + 4 + j * 4, y - randOffset, z + 2 + i * 4, ModBlocks.soldierAntTrap, 4, 2);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 2) != 0) continue;
                if (world.func_147439_a(x + j * 4, y + 1, z + 3 + i * 4) != this.solid) {
                    world.func_147465_d(x + j * 4, y + 1, z + 3 + i * 4, this.stairs, 6, 3);
                }
                world.func_147465_d(x + 1 + j * 4, y + 1, z + 3 + i * 4, this.stairs, 6, 3);
                world.func_147465_d(x + 2 + j * 4, y + 1, z + 3 + i * 4, this.stairs, 6, 3);
                world.func_147465_d(x + 3 + j * 4, y + 1, z + 3 + i * 4, this.stairs, 6, 3);
                if (world.func_147439_a(x + 4 + j * 4, y + 1, z + 3 + i * 4) != this.solid) {
                    world.func_147465_d(x + 4 + j * 4, y + 1, z + 3 + i * 4, this.stairs, 6, 3);
                }
                if (rand.nextInt(25) == 0) {
                    world.func_147465_d(x + 2 + j * 4, y, z + 3 + i * 4, Blocks.field_150478_aa, 4, 2);
                    if (rand.nextInt(4) == 0) {
                        this.placeChest(world, x + 2 + j * 4, y - 1, z + 3 + i * 4, 4, rand);
                        continue;
                    }
                    if (rand.nextInt(6) != 0) continue;
                    this.placeBones(world, x + 2 + j * 4, y - 1, z + 3 + i * 4, 2, rand);
                    continue;
                }
                if (rand.nextInt(10) != 0) continue;
                randOffset = rand.nextInt(2);
                world.func_147465_d(x + 1 + j * 4, y - randOffset, z + 4 + i * 4, ModBlocks.soldierAntTrap, 2, 2);
            }
        }
    }

    private void placeChest(World world, int x, int y, int z, int directionMeta, Random rand) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, directionMeta, 2);
        TileEntityChest chest = (TileEntityChest)world.func_147438_o(x, y, z);
        if (chest != null) {
            LootUtil.generateLoot((IInventory)chest, rand, chestLoot, 3, 10);
            this.chests.add((IInventory)chest);
        }
    }

    private void placeBones(World world, int x, int y, int z, int directionMeta, Random rand) {
        world.func_147465_d(x, y, z, ModBlocks.bones, directionMeta, 2);
        TileEntityBones bones = (TileEntityBones)world.func_147438_o(x, y, z);
        if (bones != null) {
            LootUtil.generateLoot((IInventory)bones, rand, chestLoot, 3, 10);
            this.chests.add((IInventory)bones);
        }
    }

    private void buildLevel(World world, int x, int y, int z, int w, int h, int[][] maze, Block blockType, int blockMeta) {
        for (int i = 0; i < h; ++i) {
            int j;
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 1) == 0) {
                    world.func_147465_d(x + j * 4, y, z + i * 4, blockType, blockMeta, 2);
                    world.func_147465_d(x + j * 4 + 1, y, z + i * 4, blockType, blockMeta, 2);
                    world.func_147465_d(x + j * 4 + 2, y, z + i * 4, blockType, blockMeta, 2);
                    world.func_147465_d(x + j * 4 + 3, y, z + i * 4, blockType, blockMeta, 2);
                    continue;
                }
                world.func_147465_d(x + j * 4, y, z + i * 4, blockType, blockMeta, 2);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 8) != 0) continue;
                world.func_147465_d(x + j * 4, y, z + i * 4 + 1, blockType, blockMeta, 2);
                world.func_147465_d(x + j * 4, y, z + i * 4 + 2, blockType, blockMeta, 2);
                world.func_147465_d(x + j * 4, y, z + i * 4 + 3, blockType, blockMeta, 2);
            }
            world.func_147465_d(x + w * 4, y, z + i * 4, blockType, blockMeta, 2);
            world.func_147465_d(x + w * 4, y, z + i * 4 + 1, blockType, blockMeta, 2);
            world.func_147465_d(x + w * 4, y, z + i * 4 + 2, blockType, blockMeta, 2);
            world.func_147465_d(x + w * 4, y, z + i * 4 + 3, blockType, blockMeta, 2);
        }
        for (int j = 0; j <= w * 4; ++j) {
            world.func_147465_d(x + j, y, z + h * 4, blockType, blockMeta, 2);
        }
    }
}

