/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.tree;

import erebus.ModBlocks;
import erebus.lib.EnumWood;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenErebusHugeTree
extends WorldGenerator {
    private int baseHeight;
    private final int leavesMetadata;
    private final boolean thorns;
    private final Block woodBlock;
    private final Block leafBlock;

    public WorldGenErebusHugeTree(boolean par1, boolean par5, EnumWood wood) {
        super(par1);
        this.leavesMetadata = 0;
        this.thorns = par5;
        this.woodBlock = wood.getLog();
        this.leafBlock = wood.getLeaves();
    }

    public void prepare(int baseHeight) {
        this.baseHeight = baseHeight;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(3) + this.baseHeight;
        boolean var7 = true;
        if (y >= 1 && y + height + 1 <= 256) {
            Block block;
            int var11;
            int var10;
            for (int var8 = y; var8 <= y + 1 + height; ++var8) {
                int var9 = 2;
                if (var8 == y) {
                    var9 = 1;
                }
                if (var8 >= y + 1 + height - 2) {
                    var9 = 2;
                }
                for (var10 = x - var9; var10 <= x + var9 && var7; ++var10) {
                    for (var11 = z - var9; var11 <= z + var9 && var7; ++var11) {
                        if (var8 >= 0 && var8 < 256) {
                            block = world.func_147439_a(var10, var8, var11);
                            if (block.isLeaves((IBlockAccess)world, var10, var8, var11) || block == Blocks.field_150349_c || block == Blocks.field_150346_d || block.isWood((IBlockAccess)world, var10, var8, var11) || block.isReplaceable((IBlockAccess)world, var10, var8, var11)) continue;
                            var7 = false;
                            continue;
                        }
                        var7 = false;
                    }
                }
            }
            if (!var7) {
                return false;
            }
            block = world.func_147439_a(x, y - 1, z);
            if ((block == Blocks.field_150349_c || block == Blocks.field_150346_d) && y < 256 - height - 1) {
                world.func_147449_b(x, y - 1, z, Blocks.field_150346_d);
                world.func_147449_b(x + 1, y - 1, z, Blocks.field_150346_d);
                world.func_147449_b(x, y - 1, z + 1, Blocks.field_150346_d);
                world.func_147449_b(x + 1, y - 1, z + 1, Blocks.field_150346_d);
                this.growLeaves(world, x, z, y + height, 2, rand);
                for (int var14 = y + height - 2 - rand.nextInt(4); var14 > y + height / 2; var14 -= 2 + rand.nextInt(4)) {
                    float var15 = rand.nextFloat() * (float)Math.PI * 2.0f;
                    var11 = x + (int)(0.5f + MathHelper.func_76134_b((float)var15) * 4.0f);
                    int var12 = z + (int)(0.5f + MathHelper.func_76126_a((float)var15) * 4.0f);
                    this.growLeaves(world, var11, var12, var14, 0, rand);
                    for (int var13 = 0; var13 < 5; ++var13) {
                        var11 = x + (int)(1.5f + MathHelper.func_76134_b((float)var15) * (float)var13);
                        var12 = z + (int)(1.5f + MathHelper.func_76126_a((float)var15) * (float)var13);
                        world.func_147465_d(var11, var14 - 3 + var13 / 2, var12, this.woodBlock, 0, 2);
                    }
                }
                for (var10 = 0; var10 < height; ++var10) {
                    block = world.func_147439_a(x, y + var10, z);
                    if (block.isReplaceable((IBlockAccess)world, x, y + var10, z) || block.isLeaves((IBlockAccess)world, x, y + var10, z)) {
                        world.func_147465_d(x, y + var10, z, this.woodBlock, 0, 2);
                        if (var10 > 0) {
                            if (rand.nextInt(3) > 0 && world.func_147437_c(x - 1, y + var10, z) && this.thorns) {
                                world.func_147465_d(x - 1, y + var10, z, ModBlocks.thorns, 8, 2);
                            }
                            if (rand.nextInt(3) > 0 && world.func_147437_c(x, y + var10, z - 1) && this.thorns) {
                                world.func_147465_d(x, y + var10, z - 1, ModBlocks.thorns, 1, 2);
                            }
                        }
                    }
                    if (var10 >= height - 1) continue;
                    block = world.func_147439_a(x + 1, y + var10, z);
                    if (block.isReplaceable((IBlockAccess)world, x + 1, y + var10, z) || block.isLeaves((IBlockAccess)world, x + 1, y + var10, z)) {
                        world.func_147465_d(x + 1, y + var10, z, this.woodBlock, 0, 2);
                        if (var10 > 0) {
                            if (rand.nextInt(3) > 0 && world.func_147437_c(x + 2, y + var10, z) && this.thorns) {
                                world.func_147465_d(x + 2, y + var10, z, ModBlocks.thorns, 2, 2);
                            }
                            if (rand.nextInt(3) > 0 && world.func_147437_c(x + 1, y + var10, z - 1) && this.thorns) {
                                world.func_147465_d(x + 1, y + var10, z - 1, ModBlocks.thorns, 1, 2);
                            }
                        }
                    }
                    if ((block = world.func_147439_a(x + 1, y + var10, z + 1)).isReplaceable((IBlockAccess)world, x + 1, y + var10, z + 1) || block.isLeaves((IBlockAccess)world, x + 1, y + var10, z + 1)) {
                        world.func_147465_d(x + 1, y + var10, z + 1, this.woodBlock, 0, 2);
                        if (var10 > 0) {
                            if (rand.nextInt(3) > 0 && world.func_147437_c(x + 2, y + var10, z + 1) && this.thorns) {
                                world.func_147465_d(x + 2, y + var10, z + 1, ModBlocks.thorns, 2, 2);
                            }
                            if (rand.nextInt(3) > 0 && world.func_147437_c(x + 1, y + var10, z + 2) && this.thorns) {
                                world.func_147465_d(x + 1, y + var10, z + 2, ModBlocks.thorns, 4, 2);
                            }
                        }
                    }
                    if (!(block = world.func_147439_a(x, y + var10, z + 1)).isReplaceable((IBlockAccess)world, x, y + var10, z + 1) && !block.isLeaves((IBlockAccess)world, x, y + var10, z + 1)) continue;
                    world.func_147465_d(x, y + var10, z + 1, this.woodBlock, 0, 2);
                    if (var10 <= 0) continue;
                    if (rand.nextInt(3) > 0 && world.func_147437_c(x - 1, y + var10, z + 1) && this.thorns) {
                        world.func_147465_d(x - 1, y + var10, z + 1, ModBlocks.thorns, 8, 2);
                    }
                    if (rand.nextInt(3) <= 0 || !world.func_147437_c(x, y + var10, z + 2) || !this.thorns) continue;
                    world.func_147465_d(x, y + var10, z + 2, ModBlocks.thorns, 4, 2);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void growLeaves(World world, int par2, int par3, int par4, int par5, Random par6Random) {
        int var7 = 2;
        for (int var8 = par4 - var7; var8 <= par4; ++var8) {
            int var9 = var8 - par4;
            int var10 = par5 + 1 - var9;
            for (int var11 = par2 - var10; var11 <= par2 + var10 + 1; ++var11) {
                int var12 = var11 - par2;
                for (int var13 = par3 - var10; var13 <= par3 + var10 + 1; ++var13) {
                    int var14 = var13 - par3;
                    Block block = world.func_147439_a(var11, var8, var13);
                    if (var12 < 0 && var14 < 0 && var12 * var12 + var14 * var14 > var10 * var10 || (var12 > 0 || var14 > 0) && var12 * var12 + var14 * var14 > (var10 + 1) * (var10 + 1) || par6Random.nextInt(4) == 0 && var12 * var12 + var14 * var14 > (var10 - 1) * (var10 - 1) || block != null && !block.canBeReplacedByLeaves((IBlockAccess)world, var11, var8, var13)) continue;
                    world.func_147465_d(var11, var8, var13, this.leafBlock, this.leavesMetadata, 2);
                }
            }
        }
    }
}

