/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.tree;

import erebus.ModBlocks;
import erebus.lib.EnumWood;
import erebus.world.feature.tree.WorldGenTreeBase;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenMarshwoodTree
extends WorldGenTreeBase {
    public WorldGenMarshwoodTree() {
        super(EnumWood.Marshwood);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int radius = rand.nextInt(2) + 3;
        int height = rand.nextInt(radius) + 12;
        int maxRadius = 9;
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 2; yy < y + height; ++yy) {
                    if (world.func_147437_c(xx, yy, zz)) continue;
                    return false;
                }
            }
        }
        for (int yy = y; yy < y + height; ++yy) {
            if (yy % 5 == 0 && radius != 1) {
                --radius;
            }
            for (int i = radius * -1; i <= radius; ++i) {
                for (int j = radius * -1; j <= radius; ++j) {
                    double dSq = i * i + j * j;
                    if (Math.round(Math.sqrt(dSq)) <= (long)radius && yy <= y + height - 2) {
                        world.func_147465_d(x + i, yy, z + j, this.log, 0, 2);
                    }
                    if ((Math.round(Math.sqrt(dSq)) > (long)radius || yy != y) && (Math.round(Math.sqrt(dSq)) > (long)radius || yy != y + height - 1)) continue;
                    world.func_147465_d(x + i, yy, z + j, this.log, 15, 2);
                }
            }
            if (yy == y + height - 1) {
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(3), z, 1, false);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(3), z, 2, false);
                this.createBranch(world, rand, x, yy - rand.nextInt(3), z + radius + 1, 3, false);
                this.createBranch(world, rand, x, yy - rand.nextInt(3), z - radius - 1, 4, false);
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(3), z + radius + 1, 5, false);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(3), z - radius - 1, 6, false);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(3), z + radius + 1, 7, false);
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(3), z - radius - 1, 8, false);
            }
            if (yy != y + 1) continue;
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(3), z, 1, true);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(3), z, 2, true);
            this.createBranch(world, rand, x, yy - rand.nextInt(3), z + radius + 1, 3, true);
            this.createBranch(world, rand, x, yy - rand.nextInt(3), z - radius - 1, 4, true);
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(3), z + radius + 1, 5, true);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(3), z - radius - 1, 6, true);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(3), z + radius + 1, 7, true);
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(3), z - radius - 1, 8, true);
        }
        return true;
    }

    private void createBranch(World world, Random rand, int x, int y, int z, int dir, boolean root) {
        int branchLength = rand.nextInt(2) + 3;
        int meta = dir;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 3) {
                --y;
                meta = 0;
            }
            if (dir == 1) {
                if (!root) {
                    world.func_147465_d(x + i, y, z, this.log, meta == 0 ? 0 : 4, 2);
                    if (i < branchLength) {
                        this.addHangers(world, rand, x + i, y - 1, z);
                    }
                    if (i == branchLength) {
                        this.createLeaves(world, rand, x + i, y - 1, z, 1);
                    }
                } else {
                    world.func_147465_d(x + i, y, z, this.log, 15, 2);
                    world.func_147465_d(x + i, y - 1, z, this.log, 15, 2);
                }
            }
            if (dir == 2) {
                if (!root) {
                    world.func_147465_d(x - i, y, z, this.log, meta == 0 ? 0 : 4, 2);
                    if (i < branchLength) {
                        this.addHangers(world, rand, x - i, y - 1, z);
                    }
                    if (i == branchLength) {
                        this.createLeaves(world, rand, x - i, y - 1, z, 1);
                    }
                } else {
                    world.func_147465_d(x - i, y, z, this.log, 15, 2);
                    world.func_147465_d(x - i, y - 1, z, this.log, 15, 2);
                }
            }
            if (dir == 3) {
                if (!root) {
                    world.func_147465_d(x, y, z + i, this.log, meta == 0 ? 0 : 8, 2);
                    if (i < branchLength) {
                        this.addHangers(world, rand, x, y - 1, z + i);
                    }
                    if (i == branchLength) {
                        this.createLeaves(world, rand, x, y - 1, z + i, 1);
                    }
                } else {
                    world.func_147465_d(x, y, z + i, this.log, 15, 2);
                    world.func_147465_d(x, y - 1, z + i, this.log, 15, 2);
                }
            }
            if (dir == 4) {
                if (!root) {
                    world.func_147465_d(x, y, z - i, this.log, meta == 0 ? 0 : 8, 2);
                    if (i < branchLength) {
                        this.addHangers(world, rand, x, y - 1, z - i);
                    }
                    if (i == branchLength) {
                        this.createLeaves(world, rand, x, y - 1, z - i, 1);
                    }
                } else {
                    world.func_147465_d(x, y, z - i, this.log, 15, 2);
                    world.func_147465_d(x, y - 1, z - i, this.log, 15, 2);
                }
            }
            if (dir == 5) {
                if (!root) {
                    world.func_147465_d(x + i - 1, y, z + i - 1, this.log, meta == 0 ? 0 : 4, 2);
                    if (i < branchLength) {
                        this.addHangers(world, rand, x + i - 1, y - 1, z + i - 1);
                    }
                    if (i == branchLength) {
                        this.createLeaves(world, rand, x + i, y - 1, z + i, 1);
                    }
                } else {
                    world.func_147465_d(x + i - 1, y, z + i - 1, this.log, 15, 2);
                    world.func_147465_d(x + i - 1, y - 1, z + i - 1, this.log, 15, 2);
                }
            }
            if (dir == 6) {
                if (!root) {
                    world.func_147465_d(x - i + 1, y, z - i + 1, this.log, meta == 0 ? 0 : 4, 2);
                    if (i < branchLength) {
                        this.addHangers(world, rand, x - i + 1, y - 1, z - i + 1);
                    }
                    if (i == branchLength) {
                        this.createLeaves(world, rand, x - i, y - 1, z - i, 1);
                    }
                } else {
                    world.func_147465_d(x - i + 1, y, z - i + 1, this.log, 15, 2);
                    world.func_147465_d(x - i + 1, y - 1, z - i + 1, this.log, 15, 2);
                }
            }
            if (dir == 7) {
                if (!root) {
                    world.func_147465_d(x - i + 1, y, z + i - 1, this.log, meta == 0 ? 0 : 8, 2);
                    if (i < branchLength) {
                        this.addHangers(world, rand, x - i + 1, y - 1, z + i - 1);
                    }
                    if (i == branchLength) {
                        this.createLeaves(world, rand, x - i, y - 1, z + i, 1);
                    }
                } else {
                    world.func_147465_d(x - i + 1, y, z + i - 1, this.log, 15, 2);
                    world.func_147465_d(x - i + 1, y - 1, z + i - 1, this.log, 15, 2);
                }
            }
            if (dir != 8) continue;
            if (!root) {
                world.func_147465_d(x + i - 1, y, z - i + 1, this.log, meta == 0 ? 0 : 8, 2);
                if (i < branchLength) {
                    this.addHangers(world, rand, x + i - 1, y - 1, z - i + 1);
                }
                if (i != branchLength) continue;
                this.createLeaves(world, rand, x + i, y - 1, z - i, 1);
                continue;
            }
            world.func_147465_d(x + i - 1, y, z - i + 1, this.log, 15, 2);
            world.func_147465_d(x + i - 1, y - 1, z - i + 1, this.log, 15, 2);
        }
    }

    public void createLeaves(World world, Random rand, int x, int y, int z, int radius) {
        int height = 3;
        for (int xx = x - radius; xx <= x + radius; ++xx) {
            for (int zz = z - radius; zz <= z + radius; ++zz) {
                for (int yy = y; yy > y - height; --yy) {
                    double dSq = Math.pow(xx - x, 2.0) + Math.pow(zz - z, 2.0) + Math.pow(yy - y, 2.0);
                    if (Math.round(Math.sqrt(dSq)) <= (long)radius) {
                        if (Math.round(Math.sqrt(dSq)) == 0L) {
                            world.func_147465_d(xx, yy, zz, this.log, 0, 2);
                        } else {
                            world.func_147449_b(xx, yy, zz, this.leaves);
                        }
                    }
                    if (Math.round(Math.sqrt(dSq)) != 0L) continue;
                    world.func_147449_b(xx, yy - 2, zz, this.leaves);
                    this.addHangers(world, rand, xx, yy - 3, zz);
                }
            }
        }
    }

    public void addHangers(World world, Random rand, int x, int y, int z) {
        if (rand.nextInt(4) != 0) {
            int length = rand.nextInt(13) + 4;
            for (int yy = y; yy > y - length && world.func_147439_a(x, yy, z) == Blocks.field_150350_a; --yy) {
                world.func_147465_d(x, yy, z, ModBlocks.hanger, 4, 2);
            }
        }
    }
}

