/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.tree;

import erebus.lib.EnumWood;
import erebus.world.feature.tree.WorldGenTreeBase;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenSapTree
extends WorldGenTreeBase {
    public WorldGenSapTree() {
        super(EnumWood.Sap);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(4) + 12;
        int maxRadius = 5;
        boolean alternate = rand.nextBoolean();
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 2; yy < y + height; ++yy) {
                    if (world.func_147437_c(xx, yy, zz)) continue;
                    return false;
                }
            }
        }
        for (int yy = y; yy < y + height; ++yy) {
            if (yy < y + height - 1) {
                world.func_147465_d(x, yy, z, this.log, 0, 2);
            }
            if (yy == y + height - 1) {
                this.createLeaves(world, x, yy, z);
                this.placeLeaves(world, x, yy + 1, z);
            }
            if (yy == y + height - 7 || yy == y + height - 10) {
                if (alternate) {
                    this.createBranch(world, rand, x + 1, yy - rand.nextInt(2), z, 1, 1);
                    this.createBranch(world, rand, x - 1, yy - rand.nextInt(2), z, 2, 1);
                    alternate = false;
                } else {
                    this.createBranch(world, rand, x, yy - rand.nextInt(2), z + 1, 3, 1);
                    this.createBranch(world, rand, x, yy - rand.nextInt(2), z - 1, 4, 1);
                    alternate = true;
                }
            }
            if (yy != y + height - 4) continue;
            if (alternate) {
                this.createBranch(world, rand, x + 1, yy - rand.nextInt(2), z, 1, 1);
                this.createBranch(world, rand, x - 1, yy - rand.nextInt(2), z, 2, 1);
                alternate = false;
                continue;
            }
            this.createBranch(world, rand, x, yy - rand.nextInt(2), z + 1, 3, 1);
            this.createBranch(world, rand, x, yy - rand.nextInt(2), z - 1, 4, 1);
            alternate = true;
        }
        return true;
    }

    private void createBranch(World world, Random rand, int x, int y, int z, int dir, int branchLength) {
        int meta = dir;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 1) {
                ++y;
                meta = 0;
            }
            if (dir == 1) {
                world.func_147465_d(x + i, y, z, this.log, meta == 0 ? 0 : 4, 2);
                if (i == branchLength) {
                    this.createLeaves(world, x + i, y, z);
                    this.placeLeaves(world, x + i + 2, y, z);
                }
            }
            if (dir == 2) {
                world.func_147465_d(x - i, y, z, this.log, meta == 0 ? 0 : 4, 2);
                if (i == branchLength) {
                    this.createLeaves(world, x - i, y, z);
                    this.placeLeaves(world, x - i - 2, y, z);
                }
            }
            if (dir == 3) {
                world.func_147465_d(x, y, z + i, this.log, meta == 0 ? 0 : 8, 2);
                if (i == branchLength) {
                    this.createLeaves(world, x, y, z + i);
                    this.placeLeaves(world, x, y, z + i + 2);
                }
            }
            if (dir != 4) continue;
            world.func_147465_d(x, y, z - i, this.log, meta == 0 ? 0 : 8, 2);
            if (i != branchLength) continue;
            this.createLeaves(world, x, y, z - i);
            this.placeLeaves(world, x, y, z - i - 2);
        }
    }

    private void createLeaves(World world, int x, int y, int z) {
        for (int d = -1; d < 2; ++d) {
            for (int d2 = -1; d2 < 2; ++d2) {
                this.placeLeaves(world, x + d, y, z + d2);
            }
        }
    }

    private void placeLeaves(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == Blocks.field_150350_a) {
            world.func_147449_b(x, y, z, this.leaves);
        }
    }
}

