/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.block;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.teamwizardry.wizardry.crafting.mana.FluidCraftInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FluidTracker {
    public static FluidTracker INSTANCE = new FluidTracker();
    private HashMap<Integer, HashMultimap<BlockPos, FluidCraftInstance>> fluidCrafters = new HashMap();

    public synchronized void addManaCraft(World world, BlockPos pos, FluidCraftInstance crafter) {
        int dim = world.field_73011_w.getDimension();
        HashMultimap worldCrafters = this.fluidCrafters.get(dim);
        if (worldCrafters == null) {
            worldCrafters = HashMultimap.create();
            this.fluidCrafters.put(dim, (HashMultimap<BlockPos, FluidCraftInstance>)worldCrafters);
        }
        Set crafterList = worldCrafters.get((Object)pos);
        for (FluidCraftInstance manaCrafter : crafterList) {
            if (!manaCrafter.equals(crafter)) continue;
            return;
        }
        if (world.func_180495_p(pos).func_177230_c() == crafter.getFluid().getBlock()) {
            worldCrafters.put((Object)pos, (Object)crafter);
        }
    }

    public synchronized void tick(World tickedWorld) {
        if (this.fluidCrafters.isEmpty()) {
            return;
        }
        int dim = tickedWorld.field_73011_w.getDimension();
        HashMultimap<BlockPos, FluidCraftInstance> worldCrafters = this.fluidCrafters.get(dim);
        if (worldCrafters == null || worldCrafters.isEmpty()) {
            return;
        }
        HashMultimap crafterToRemove = HashMultimap.create();
        Multimaps.asMap(worldCrafters).forEach((pos, crafterList) -> {
            if (!tickedWorld.func_175667_e(pos)) {
                return;
            }
            List items = tickedWorld.func_72872_a(EntityItem.class, new AxisAlignedBB(pos).func_186662_g(1.0));
            crafterList.forEach(crafter -> {
                if (!crafter.isValid(tickedWorld, (BlockPos)pos, items)) {
                    crafterToRemove.put(pos, crafter);
                } else {
                    crafter.tick(tickedWorld, (BlockPos)pos, items);
                    if (crafter.isFinished()) {
                        crafter.finish(tickedWorld, (BlockPos)pos, items);
                        crafterToRemove.put(pos, crafter);
                    }
                }
            });
        });
        crafterToRemove.forEach((x$0, x$1) -> worldCrafters.remove(x$0, x$1));
        if (worldCrafters.isEmpty()) {
            this.fluidCrafters.remove(dim);
        }
    }
}

