/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.structure;

import com.google.common.collect.HashMultimap;
import com.teamwizardry.librarianlib.features.kotlin.ClientUtilMethods;
import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.structure.WizardryStructure;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class StructureManager {
    private final HashMap<ResourceLocation, WizardryStructure> structures = new HashMap();
    private final HashMap<ResourceLocation, HashMap<Integer, int[]>> vboCache = new HashMap();

    @Nullable
    public WizardryStructure getStructure(ResourceLocation location) {
        return this.structures.get(location);
    }

    public void addStructure(ResourceLocation location, BlockPos origin) {
        if (this.structures.containsKey(location)) {
            return;
        }
        WizardryStructure structure = new WizardryStructure(location);
        structure.setOrigin(origin);
        this.structures.put(location, structure);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(ResourceLocation location, float alpha) {
        HashMap<Integer, int[]> cache = this.vboCache.get(location);
        if (cache == null || cache.isEmpty()) {
            this.bake(location);
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179088_q();
        GlStateManager.func_179136_a((float)1.0f, (float)-0.05f);
        int alphaFunc = GL11.glGetInteger((int)3009);
        float alphaRef = GL11.glGetFloat((int)3010);
        GlStateManager.func_179092_a((int)519, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buffer = tes.func_178180_c();
        for (int layerID : cache.keySet()) {
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            buffer.func_178981_a(cache.get(layerID));
            for (int i = 0; i < buffer.func_178989_h(); ++i) {
                buffer.putColorRGBA(buffer.func_78909_a(i), 255, 255, 255, (int)(alpha * 255.0f));
            }
            tes.func_78381_a();
        }
        GlStateManager.func_179092_a((int)alphaFunc, (float)alphaRef);
        GlStateManager.func_179113_r();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public void bake(ResourceLocation resourceLocation) {
        Wizardry.LOGGER.info("Attempting to bake structure \"" + resourceLocation.toString() + "\"");
        WizardryStructure structure = this.structures.get(resourceLocation);
        if (structure == null) {
            Wizardry.LOGGER.error("Could not bake structure \"" + resourceLocation.toString() + "\". Does not seem to exist?");
            return;
        }
        HashMultimap blocks = HashMultimap.create();
        for (Template.BlockInfo info : structure.blockInfos()) {
            if (info.field_186243_b.func_185904_a() == Material.field_151579_a || info.field_186243_b.func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
            blocks.put((Object)info.field_186243_b.func_177230_c().func_180664_k().ordinal(), (Object)info);
        }
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        if (dispatcher == null) {
            Wizardry.LOGGER.error("Could not bake structure \"" + resourceLocation.toString() + "\". Dispatcher is null. Don't call bake so early?");
            return;
        }
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder bb = tes.func_178180_c();
        HashMap<Integer, int[]> cache = new HashMap<Integer, int[]>();
        Iterator iterator = blocks.keySet().iterator();
        while (iterator.hasNext()) {
            int layerID = (Integer)iterator.next();
            bb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            for (Template.BlockInfo info : blocks.get((Object)layerID)) {
                if (info.field_186243_b == null || info.field_186243_b.func_185904_a() == Material.field_151579_a || info.field_186243_b.func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
                bb.func_178969_c((double)(info.field_186242_a.func_177958_n() - structure.getOrigin().func_177958_n()), (double)(info.field_186242_a.func_177956_o() - structure.getOrigin().func_177956_o()), (double)(info.field_186242_a.func_177952_p() - structure.getOrigin().func_177952_p()));
                dispatcher.func_175018_a(info.field_186243_b, BlockPos.field_177992_a, (IBlockAccess)structure.getWizardryAccess(), bb);
                bb.func_178969_c(0.0, 0.0, 0.0);
            }
            cache.put(layerID, ClientUtilMethods.createCacheArrayAndReset((BufferBuilder)bb));
            bb.func_178965_a();
        }
        this.vboCache.put(resourceLocation, cache);
        Wizardry.LOGGER.info("Baking for structure \"" + resourceLocation.toString() + "\" completed.");
    }

    @SideOnly(value=Side.CLIENT)
    public void bake() {
        this.vboCache.clear();
        for (ResourceLocation resourceLocation : this.structures.keySet()) {
            this.bake(resourceLocation);
        }
    }
}

