/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.gui.book;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.gui.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.Bookmark;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.ComponentBookMark;
import com.teamwizardry.wizardry.client.gui.book.ComponentSpellRecipe;
import com.teamwizardry.wizardry.client.gui.book.GuiBook;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ComponentRecipeBar
extends ComponentBookMark {
    private boolean focused = false;

    public ComponentRecipeBar(@Nonnull GuiBook book, int id) {
        super((IBookGui)book, GuiBook.SPELL_RECIPE_ICON, id, -2, -2);
        this.setBookmarkText(LibrarianLib.PROXY.translate("wizardry.book.spell_recipe_recipe", new Object[0]), book.getBook().getSearchTextColor(), -5);
        this.BUS.hook(GuiComponentEvents.MouseInEvent.class, mouseInEvent -> {
            if (!this.focused) {
                this.slideOutShort();
            }
        });
        this.BUS.hook(GuiComponentEvents.MouseOutEvent.class, mouseOutEvent -> {
            if (!this.focused) {
                this.slideIn();
            }
        });
        this.BUS.hook(GuiComponentEvents.MouseClickEvent.class, mouseClickEvent -> {
            if (this.focused) {
                book.up();
                this.slideOutShort();
                this.focused = false;
            } else {
                book.placeInFocus(new ComponentSpellRecipe(book.getBook()));
                this.slideIn();
                this.focused = true;
            }
        });
    }

    public static class RecipeBookmark
    implements Bookmark {
        @SideOnly(value=Side.CLIENT)
        @NotNull
        public ComponentBookMark createBookmarkComponent(@NotNull IBookGui book, int bookmarkIndex) {
            return new ComponentRecipeBar((GuiBook)book, bookmarkIndex);
        }
    }
}

