/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core;

import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.block.FluidTracker;
import com.teamwizardry.wizardry.api.util.PosUtils;
import com.teamwizardry.wizardry.api.util.TeleportUtil;
import com.teamwizardry.wizardry.crafting.burnable.EntityBurnableItem;
import com.teamwizardry.wizardry.init.ModItems;
import com.teamwizardry.wizardry.init.ModPotions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    public static final HashSet<UUID> fallResetter = new HashSet();
    HashMap<Integer, Boolean> passmap = new HashMap();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent event) {
        if (event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            event.getMap().func_174942_a(new ResourceLocation("wizardry", "particles/smoke"));
            event.getMap().func_174942_a(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            event.getMap().func_174942_a(new ResourceLocation("wizardry", "particles/diamond"));
        }
    }

    @SubscribeEvent
    public void redstoneHandler(EntityJoinWorldEvent event) {
        EntityItem item;
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntityItem && !(event.getEntity() instanceof EntityBurnableItem) && EntityBurnableItem.isBurnable((item = (EntityItem)event.getEntity()).func_92059_d())) {
            EntityBurnableItem newItem = new EntityBurnableItem(event.getWorld(), item.field_70165_t, item.field_70163_u, item.field_70161_v, item.func_92059_d());
            newItem.field_70159_w = item.field_70159_w;
            newItem.field_70181_x = item.field_70181_x;
            newItem.field_70179_y = item.field_70179_y;
            newItem.func_174867_a(40);
            item.func_70106_y();
            event.getWorld().func_72838_d((Entity)newItem);
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER) {
            FluidTracker.INSTANCE.tick(event.world);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.func_130014_f_().field_73011_w.getDimension() == Wizardry.underWorld.func_186068_a() && event.player.field_70163_u < 0.0) {
            event.player.field_70128_L = false;
            BlockPos spawn = event.player.isSpawnForced(0) ? event.player.getBedLocation(0) : event.player.field_70170_p.func_175694_M().func_177963_a(event.player.field_70170_p.field_73012_v.nextGaussian() * 16.0, 0.0, event.player.field_70170_p.field_73012_v.nextGaussian() * 16.0);
            BlockPos teleportTo = spawn.func_177982_a(0, 300 - spawn.func_177956_o(), 0);
            fallResetter.add(event.player.func_110124_au());
            TeleportUtil.teleportToDimension(event.player, 0, teleportTo.func_177958_n(), teleportTo.func_177956_o(), teleportTo.func_177952_p());
        }
        if (event.player.func_130014_f_().field_73011_w.getDimension() == 0 && ConfigValues.underworldFallSpeed <= 0.0 && (event.player.field_70181_x < ConfigValues.underworldFallSpeed || this.passmap.get(event.player.func_145782_y()) != null)) {
            this.passmap.put(event.player.func_145782_y(), true);
            BlockPos location = event.player.func_180425_c();
            BlockPos bedrock = PosUtils.checkNeighborBlocksThoroughly(event.player.func_130014_f_(), location, Blocks.field_150357_h);
            if (bedrock != null) {
                event.player.field_70128_L = false;
                fallResetter.add(event.player.func_110124_au());
                TeleportUtil.teleportToDimension(event.player, Wizardry.underWorld.func_186068_a(), 0.0, 300.0, 0.0);
                this.passmap.remove(event.player.func_145782_y());
            } else if (event.player.field_70181_x > ConfigValues.underworldFallSpeed) {
                this.passmap.remove(event.player.func_145782_y());
            }
        }
        if (!event.player.field_70170_p.field_72995_K) {
            for (ItemStack stack : event.player.field_71071_by.field_70462_a) {
                if (stack.func_77973_b() != ModItems.LEVITATION_ORB) continue;
                if (stack.func_77952_i() + 1 > stack.func_77958_k()) {
                    stack.func_190918_g(1);
                    continue;
                }
                if (event.player.field_70170_p.func_82737_E() % 10L == 0L) {
                    stack.func_77964_b(stack.func_77952_i() + 1);
                }
                if (event.player.func_70644_a((Potion)ModPotions.LOW_GRAVITY)) break;
                event.player.func_70690_d(new PotionEffect((Potion)ModPotions.LOW_GRAVITY, 3, 3, false, false));
                break;
            }
        }
    }

    @SubscribeEvent
    public void underworldTeleport(LivingHurtEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (fallResetter.contains(event.getEntity().func_110124_au())) {
            if (event.getEntity().field_70163_u < 0.0 || event.getEntity().field_70163_u > (double)event.getEntity().field_70170_p.func_72800_K()) {
                event.setCanceled(true);
                return;
            }
            if (event.getSource() == DamageSource.field_76379_h) {
                fallResetter.remove(event.getEntity().func_110124_au());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onFlyFall(PlayerFlyableFallEvent event) {
        if (event.getEntityPlayer().func_130014_f_().field_73011_w.getDimension() == 0 && event.getEntityPlayer().field_70163_u <= 0.0) {
            BlockPos location = event.getEntityPlayer().func_180425_c();
            BlockPos bedrock = PosUtils.checkNeighborBlocksThoroughly(event.getEntity().func_130014_f_(), location, Blocks.field_150357_h);
            if (bedrock != null && event.getEntity().func_130014_f_().func_180495_p(bedrock).func_177230_c() == Blocks.field_150357_h) {
                TeleportUtil.teleportToDimension(event.getEntityPlayer(), Wizardry.underWorld.func_186068_a(), 0.0, 300.0, 0.0);
                ((EntityPlayer)event.getEntity()).func_70690_d(new PotionEffect((Potion)ModPotions.NULLIFY_GRAVITY, 100, 0, true, false));
                fallResetter.add(event.getEntity().func_110124_au());
            }
        }
    }
}

