/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core.nemez;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.common.core.nemez.NemezTracker;
import com.teamwizardry.wizardry.common.network.PacketNemezReversal;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="wizardry")
public final class NemezEventHandler {
    private static HashSet<Reversal> reversals = new HashSet();

    @SideOnly(value=Side.CLIENT)
    public static NemezTracker getCurrent() {
        if (reversals.isEmpty()) {
            Reversal reversal = new Reversal((World)Minecraft.func_71410_x().field_71441_e, new NemezTracker());
            reversals.add(reversal);
        }
        return reversals.iterator().next().nemez;
    }

    public static void reverseTime(World world, NemezTracker tracker, BlockPos locus) {
        Reversal reversal = new Reversal(world, tracker);
        reversal.pos = locus;
        reversals.add(reversal);
    }

    public static void rewind(World world, NemezTracker tracker, BlockPos locus) {
        NemezEventHandler.reverseTime(world, tracker, locus);
        tracker.erase();
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            reversals.removeIf(reversal -> {
                if (((Reversal)reversal).world.get() == event.world) {
                    if (((Reversal)reversal).nemez.hasNext()) {
                        ((Reversal)reversal).nemez.applySnapshot(event.world);
                        if (((Reversal)reversal).pos != null && ((World)((Reversal)reversal).world.get()).func_82737_E() % 20L == 0L) {
                            PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketNemezReversal(((Reversal)reversal).nemez), new NetworkRegistry.TargetPoint(((World)((Reversal)reversal).world.get()).field_73011_w.getDimension(), (double)((Reversal)reversal).pos.func_177958_n() + 0.5, (double)((Reversal)reversal).pos.func_177956_o() + 0.5, (double)((Reversal)reversal).pos.func_177952_p() + 0.5, 96.0));
                        }
                    } else {
                        for (Entity entity : ((Reversal)reversal).nemez.getTrackedEntities(event.world)) {
                            entity.func_189654_d(false);
                        }
                        return true;
                    }
                }
                return ((Reversal)reversal).world.get() == null;
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (event.phase == TickEvent.Phase.START) {
            for (Reversal reversal : reversals) {
                if (reversal.world.get() != world || !reversal.nemez.hasNext()) continue;
                reversal.nemez.applySnapshot((World)world, event.renderTickTime);
            }
        }
    }

    private static class Reversal {
        private final WeakReference<World> world;
        private final NemezTracker nemez;
        @Nullable
        private BlockPos pos = null;

        public Reversal(World world, NemezTracker tracker) {
            this.world = new WeakReference<World>(world);
            this.nemez = tracker.snapshot();
            this.nemez.collapse();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Reversal reversal = (Reversal)o;
            return Objects.equals(this.world, reversal.world) && Objects.equals(this.nemez, reversal.nemez);
        }

        public int hashCode() {
            return Objects.hash(this.world, this.nemez);
        }
    }
}

