/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item.halos;

import baubles.api.BaubleType;
import com.teamwizardry.librarianlib.features.base.item.ItemModBauble;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaManager;
import com.teamwizardry.wizardry.api.item.halo.IHalo;
import com.teamwizardry.wizardry.api.spell.SpellModifierRegistry;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeModifier;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.attribute.Operation;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemCreativeHaloBauble
extends ItemModBauble
implements IHalo {
    public static final ResourceLocation CREATIVE_HALO_MODIFIER_LOC = new ResourceLocation("wizardry", "creative_halo");

    public ItemCreativeHaloBauble() {
        super("halo_creative", new String[0]);
        this.func_77625_d(1);
    }

    public void onWornTick(@Nonnull ItemStack stack, @Nonnull EntityLivingBase player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        try (ManaManager.CapManagerBuilder mgr = ManaManager.forObject((Entity)player);){
            mgr.setMaxMana(ConfigValues.creativeHaloBufferSize);
            mgr.setMaxBurnout(ConfigValues.creativeHaloBufferSize);
            mgr.setMana(ConfigValues.creativeHaloBufferSize);
            mgr.setBurnout(0.0);
        }
    }

    @Nonnull
    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(@Nonnull ItemStack itemStack) {
        return BaubleType.HEAD;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.addAll(this.getHaloTooltip(stack));
    }

    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
        SpellModifierRegistry.addModifier((Entity)player, CREATIVE_HALO_MODIFIER_LOC, (spell, data) -> {
            LinkedList<AttributeModifier> modifiers = new LinkedList<AttributeModifier>();
            modifiers.add(new AttributeModifier(AttributeRegistry.MANA, 0.0f, Operation.MULTIPLY));
            modifiers.add(new AttributeModifier(AttributeRegistry.BURNOUT, 0.0f, Operation.MULTIPLY));
            return modifiers;
        });
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        SpellModifierRegistry.removeModifier((Entity)player, CREATIVE_HALO_MODIFIER_LOC);
    }
}

