/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.BlockUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_burn")
public class ModuleEffectBurn
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe", "modifier_extend_time"};
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity targetEntity = spell.getVictim(world);
        BlockPos targetPos = spell.getTargetPos();
        Entity caster = spell.getCaster(world);
        EnumFacing facing = spell.getData(SpellData.DefaultKeys.FACE_HIT);
        double area = (double)spellRing.getAttributeValue(world, AttributeRegistry.AREA, spell) / 2.0;
        double time = spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell);
        if (!spellRing.taxCaster(world, spell, true)) {
            return false;
        }
        if (targetEntity != null) {
            targetEntity.func_70015_d((int)time);
            world.func_184133_a(null, targetEntity.func_180425_c(), (SoundEvent)ModSounds.FIRE, SoundCategory.NEUTRAL, RandUtil.nextFloat(0.35f, 0.75f), RandUtil.nextFloat(0.35f, 1.5f));
        }
        if (targetPos != null) {
            int x = (int)area;
            while ((double)x >= -area) {
                int y = (int)area;
                while ((double)y >= -area) {
                    int z = (int)area;
                    while ((double)z >= -area) {
                        BlockPos pos = targetPos.func_177982_a(x, y, z);
                        double dist = pos.func_185332_f(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                        if (!(dist > area)) {
                            if (facing != null) {
                                if (world.func_175623_d(pos.func_177972_a(facing))) {
                                    BlockUtils.placeBlock(world, pos.func_177972_a(facing), Blocks.field_150480_ab.func_176223_P(), BlockUtils.makePlacer(world, pos, caster));
                                }
                            } else {
                                for (EnumFacing face : EnumFacing.field_82609_l) {
                                    if (!world.func_175623_d(pos.func_177972_a(face)) && world.func_180495_p(pos.func_177972_a(face)).func_177230_c() != Blocks.field_150431_aC) continue;
                                    BlockUtils.placeBlock(world, pos.func_177972_a(face), Blocks.field_150350_a.func_176223_P(), BlockUtils.makePlacer(world, pos, caster));
                                }
                            }
                        }
                        --z;
                    }
                    --y;
                }
                --x;
            }
            world.func_184133_a(null, targetPos, (SoundEvent)ModSounds.FIRE, SoundCategory.AMBIENT, 0.5f, RandUtil.nextFloat());
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        if (position == null) {
            return;
        }
        Color color = instance.getPrimaryColor();
        if (RandUtil.nextBoolean()) {
            color = instance.getSecondaryColor();
        }
        LibParticles.EFFECT_BURN(world, position, color);
    }
}

