/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpCircle;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.ILingeringModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.init.ModPotions;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_grace")
public class ModuleEffectGrace
implements IModuleEffect,
ILingeringModule {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_time"};
    }

    @Override
    public boolean runOnStart(@Nonnull World world, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity entity = spell.getVictim(world);
        BlockPos pos = spell.getTargetPos();
        if (pos == null) {
            return true;
        }
        double time = spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 10.0f;
        if (!spellRing.taxCaster(world, spell, true)) {
            return false;
        }
        world.func_184133_a(null, pos, (SoundEvent)ModSounds.GRACE, SoundCategory.NEUTRAL, RandUtil.nextFloat(0.6f, 1.0f), RandUtil.nextFloat(0.5f, 1.0f));
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect((Potion)ModPotions.GRACE, (int)time, 0, true, false));
        }
        return true;
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity target = spell.getVictim(world);
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        if (!((EntityLivingBase)target).func_70644_a((Potion)ModPotions.GRACE)) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.disableRandom();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new InterpCircle(target.func_174791_d().func_72441_c(0.0, (double)target.field_70131_O / 2.0, 0.0), new Vec3d(Math.cos((double)world.func_82737_E() / 10.0), 1.0, Math.cos((double)world.func_82737_E() / 10.0)), 2.0f), (int)15, (int)0, (aFloat, particleBuilder) -> {
            particleBuilder.setLifetime(RandUtil.nextInt(20, 25));
            particleBuilder.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(1.0f, 1.5f), 0.0f));
            particleBuilder.setAlphaFunction((InterpFunction)new InterpFloatInOut(aFloat.floatValue(), aFloat.floatValue()));
        });
    }

    @Override
    public int getLingeringTime(World world, SpellData spell, SpellRing spellRing) {
        double time = spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 10.0f;
        return (int)time;
    }
}

