/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects.vanish;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ContextRing;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.common.module.effects.vanish.VanishTracker;
import com.teamwizardry.wizardry.common.network.PacketVanishPlayer;
import com.teamwizardry.wizardry.init.ModSounds;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_vanish")
public class ModuleEffectVanish
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_time"};
    }

    @ModuleOverride(value="shape_zone_run")
    public boolean onRunZone(World world, SpellData data, SpellRing ring, @ContextRing SpellRing childRing) {
        double aoe = ring.getAttributeValue(world, AttributeRegistry.AREA, data);
        double range = ring.getAttributeValue(world, AttributeRegistry.RANGE, data);
        Vec3d targetPos = data.getTarget(world);
        if (targetPos == null) {
            return false;
        }
        Vec3d min = targetPos.func_178786_a(aoe, range, aoe);
        Vec3d max = targetPos.func_72441_c(aoe, range, aoe);
        List entities = world.func_72839_b(null, new AxisAlignedBB(min, max));
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLivingBase) || VanishTracker.isVanished(entity) || !(entity.func_70092_e(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c) <= aoe * aoe)) continue;
            data.processEntity(entity, false);
            this.run(world, (ModuleInstanceEffect)childRing.getModule(), data, childRing);
        }
        return true;
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity targetEntity = spell.getVictim(world);
        double duration = spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 20.0f;
        if (targetEntity instanceof EntityLivingBase) {
            if (!spellRing.taxCaster(world, spell, true)) {
                return false;
            }
            ((EntityLivingBase)targetEntity).field_70170_p.func_184133_a(null, targetEntity.func_180425_c(), (SoundEvent)ModSounds.ETHEREAL_PASS_BY, SoundCategory.NEUTRAL, 0.5f, 1.0f);
            ((EntityLivingBase)targetEntity).func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)duration, 100, false, false));
            ((EntityLivingBase)targetEntity).func_70690_d(new PotionEffect(MobEffects.field_76441_p, (int)duration, 100, false, false));
            VanishTracker.addVanishObject(targetEntity.func_145782_y(), (int)duration);
            PacketHandler.NETWORK.sendToAll((IMessage)new PacketVanishPlayer(targetEntity.func_145782_y(), (int)duration));
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        if (position == null) {
            return;
        }
        LibParticles.EFFECT_REGENERATE(world, position, instance.getPrimaryColor());
    }
}

