/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.shapes;

import com.google.common.base.Predicate;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpCircle;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.module.IModuleShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceShape;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.api.util.RenderUtils;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.common.module.shapes.IShapeOverrides;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="shape_touch")
public class ModuleShapeTouch
implements IModuleShape {
    @Override
    public boolean run(@NotNull World world, ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d look = spell.getData(SpellData.DefaultKeys.LOOK);
        Entity caster = spell.getCaster(world);
        Vec3d origin = spell.getOrigin(world);
        if (look == null) {
            return false;
        }
        if (caster == null) {
            return false;
        }
        if (origin == null) {
            return false;
        }
        if (!spellRing.taxCaster(world, spell, true)) {
            return false;
        }
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        overrides.onRunTouch(world, spell, spellRing);
        RayTraceResult result = new RayTrace(world, look, origin, caster instanceof EntityLivingBase ? ((EntityLivingBase)caster).func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() : 5.0).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        spell.processTrace(result);
        return true;
    }

    @Override
    @NotNull
    public SpellData renderVisualization(@Nonnull World world, ModuleInstanceShape instance, @Nonnull SpellData data, @Nonnull SpellRing ring, float partialTicks) {
        Vec3d look = data.getData(SpellData.DefaultKeys.LOOK);
        Entity caster = data.getCaster(world);
        Vec3d origin = data.getOrigin(world);
        if (look == null) {
            return data;
        }
        if (caster == null) {
            return data;
        }
        if (origin == null) {
            return data;
        }
        double interpPosX = caster.field_70142_S + (caster.field_70165_t - caster.field_70142_S) * (double)partialTicks;
        double interpPosY = caster.field_70137_T + (caster.field_70163_u - caster.field_70137_T) * (double)partialTicks;
        double interpPosZ = caster.field_70136_U + (caster.field_70161_v - caster.field_70136_U) * (double)partialTicks;
        RayTraceResult result = new RayTrace(world, look, new Vec3d(interpPosX, interpPosY + (double)caster.func_70047_e(), interpPosZ), caster instanceof EntityLivingBase ? ((EntityLivingBase)caster).func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() : 5.0).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        data.processTrace(result);
        BlockPos pos = data.getTargetPos();
        EnumFacing facing = data.getFaceHit();
        Vec3d target = data.getTarget(world);
        if (pos == null) {
            return data;
        }
        if (facing != null && !world.func_175623_d(pos)) {
            RenderUtils.drawFaceOutline(pos, facing);
        } else if (target != null) {
            RenderUtils.drawCircle(target, 0.3, true, false);
        }
        data.processTrace(result);
        return data;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        if (overrides.onRenderTouch(world, spell, spellRing)) {
            return;
        }
        Entity targetEntity = spell.getVictim(world);
        if (targetEntity == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(1);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new InterpCircle(targetEntity.func_174791_d().func_72441_c(0.0, (double)targetEntity.field_70131_O / 2.0, 0.0), new Vec3d(0.0, 1.0, 0.0), 1.0f, 10.0f), (int)50, (int)RandUtil.nextInt(10, 15), (aFloat, particleBuilder) -> {
            if (RandUtil.nextBoolean()) {
                glitter.setColor(spellRing.getPrimaryColor());
                glitter.setMotion(new Vec3d(0.0, RandUtil.nextDouble(0.01, 0.1), 0.0));
            } else {
                glitter.setColor(spellRing.getSecondaryColor());
                glitter.setMotion(new Vec3d(0.0, RandUtil.nextDouble(-0.1, -0.01), 0.0));
            }
            glitter.setLifetime(RandUtil.nextInt(20, 30));
            glitter.setScale((float)RandUtil.nextDouble(0.3, 1.0));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, (float)RandUtil.nextDouble(0.6, 1.0)));
            glitter.setLifetime(RandUtil.nextInt(10, 20));
            glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
        });
    }

    @ModuleOverride(value="shape_touch_run")
    public void onRunTouch(World world, SpellData data, SpellRing shape) {
    }

    @ModuleOverride(value="shape_touch_render")
    public boolean onRenderTouch(World world, SpellData data, SpellRing shape) {
        return false;
    }
}

