/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.crafting.mana;

import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public abstract class FluidCraftInstance {
    protected String name;
    protected int maxDuration;
    protected int currentDuration;
    protected Fluid fluid;

    public FluidCraftInstance(String name, int maxDuration, Fluid fluid) {
        this.name = name;
        this.maxDuration = maxDuration;
        this.currentDuration = 0;
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public abstract boolean isValid(World var1, BlockPos var2, List<EntityItem> var3);

    public void tick(World world, BlockPos pos, List<EntityItem> items) {
        ++this.currentDuration;
    }

    public abstract void finish(World var1, BlockPos var2, List<EntityItem> var3);

    public boolean isFinished() {
        return this.currentDuration >= this.maxDuration;
    }

    public boolean equals(FluidCraftInstance other) {
        return other.name.equals(this.name);
    }

    public boolean isInstant() {
        return this.maxDuration == 0;
    }
}

