/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.events.EntityInfoRenderer;
import tk.nukeduck.hud.events.PickupNotifier;
import tk.nukeduck.hud.gui.GuiHUDMenu;
import tk.nukeduck.hud.network.MessageNotifyClient;
import tk.nukeduck.hud.network.MessageNotifyClientHandler;
import tk.nukeduck.hud.network.MessagePickup;
import tk.nukeduck.hud.network.MessagePickupHandler;
import tk.nukeduck.hud.network.ServerStatusHandler;
import tk.nukeduck.hud.network.proxy.ClientProxy;
import tk.nukeduck.hud.network.proxy.CommonProxy;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.RenderUtil;
import tk.nukeduck.hud.util.StringManager;
import tk.nukeduck.hud.util.constants.Textures;

@Mod(modid="hud", name="Better HUD", version="1.3.8", acceptedMinecraftVersions="[1.9.4]")
public class BetterHud {
    @SidedProxy(clientSide="tk.nukeduck.hud.network.proxy.ClientProxy", serverSide="tk.nukeduck.hud.network.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final SimpleNetworkWrapper netWrapper;
    private static int packetId;
    public static EntityInfoRenderer entityInfoRenderer;
    public static ServerStatusHandler serverStatus;
    public static PickupNotifier pickupNotifier;
    public static Random random;
    private static short updateTicker;

    public static final <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> handler, Class<REQ> message, Side side) {
        netWrapper.registerMessage(handler, message, packetId++, side);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        BetterHud.registerMessage(MessageNotifyClientHandler.class, MessageNotifyClient.class, Side.CLIENT);
        BetterHud.registerMessage(MessagePickupHandler.class, MessagePickup.class, Side.CLIENT);
        proxy.init();
        Textures.init();
        proxy.initElements();
        serverStatus = new ServerStatusHandler();
        FMLCommonHandler.instance().bus().register((Object)serverStatus);
        pickupNotifier = new PickupNotifier();
        MinecraftForge.EVENT_BUS.register((Object)pickupNotifier);
        proxy.initKeys();
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.loadDefaults();
        proxy.loadSettings();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTick(RenderGameOverlayEvent e) {
        if (e.isCancelable()) {
            if (BetterHud.proxy.elements.potionBar.disableDefault.value && e.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS) {
                e.setCanceled(true);
            }
            return;
        }
        if (e.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71456_v != null && mc.field_71439_g != null) {
            mc.field_71424_I.func_76320_a("betterHud");
            GL11.glDisable((int)2896);
            GL11.glPushMatrix();
            ScaledResolution resolution = new ScaledResolution(mc);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            LayoutManager layoutManager = new LayoutManager();
            StringManager stringManager = new StringManager();
            for (ExtraGuiElement element : BetterHud.proxy.elements.elements) {
                if (!element.shouldRender()) continue;
                if (element.shouldProfile()) {
                    mc.field_71424_I.func_76320_a(element.getName());
                    element.render(mc, resolution, stringManager, layoutManager);
                    mc.field_71424_I.func_76319_b();
                    continue;
                }
                element.render(mc, resolution, stringManager, layoutManager);
            }
            mc.field_71424_I.func_76320_a("drawStrings");
            int right = resolution.func_78326_a() - 5;
            RenderUtil.renderStrings(mc.field_71466_p, stringManager.get(ElementSettingPosition.Position.TOP_LEFT), 5, layoutManager.get(ElementSettingPosition.Position.TOP_LEFT), ElementSettingPosition.Position.TOP_LEFT);
            RenderUtil.renderStrings(mc.field_71466_p, stringManager.get(ElementSettingPosition.Position.TOP_RIGHT), right, layoutManager.get(ElementSettingPosition.Position.TOP_RIGHT), ElementSettingPosition.Position.TOP_RIGHT);
            RenderUtil.renderStrings(mc.field_71466_p, stringManager.get(ElementSettingPosition.Position.BOTTOM_LEFT), 5, resolution.func_78328_b() - layoutManager.get(ElementSettingPosition.Position.BOTTOM_LEFT), ElementSettingPosition.Position.BOTTOM_LEFT);
            RenderUtil.renderStrings(mc.field_71466_p, stringManager.get(ElementSettingPosition.Position.BOTTOM_RIGHT), right, resolution.func_78328_b() - layoutManager.get(ElementSettingPosition.Position.BOTTOM_RIGHT), ElementSettingPosition.Position.BOTTOM_RIGHT);
            mc.field_71424_I.func_76319_b();
            GL11.glPopMatrix();
            mc.field_71424_I.func_76319_b();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        if ((updateTicker = (short)(updateTicker + 1)) == 200) {
            updateTicker = 0;
        }
        for (ExtraGuiElement element : ExtraGuiElement.UpdateSpeed.FASTER.elements) {
            if (!element.shouldRender()) continue;
            element.update(mc);
        }
        if (updateTicker % 20 == 0) {
            for (ExtraGuiElement element : ExtraGuiElement.UpdateSpeed.FAST.elements) {
                if (!element.shouldRender()) continue;
                element.update(mc);
            }
            if (updateTicker % 100 == 0) {
                for (ExtraGuiElement element : ExtraGuiElement.UpdateSpeed.MEDIUM.elements) {
                    if (!element.shouldRender()) continue;
                    element.update(mc);
                }
                if (updateTicker == 0) {
                    for (ExtraGuiElement element : ExtraGuiElement.UpdateSpeed.SLOW.elements) {
                        if (!element.shouldRender()) continue;
                        element.update(mc);
                    }
                }
            }
        }
        if (mc != null && mc.field_71439_g != null && mc != null && mc.field_71415_G && mc.field_71462_r == null) {
            ClientProxy cfr_ignored_0 = (ClientProxy)proxy;
            if (ClientProxy.openMenu.func_151468_f()) {
                GuiHUDMenu gui = new GuiHUDMenu();
                gui.func_73866_w_();
                mc.func_147108_a((GuiScreen)gui);
            }
        }
    }

    static {
        netWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("hud");
        packetId = 0;
        random = new Random();
        updateTicker = 0;
    }
}

