/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import tk.nukeduck.hud.element.settings.ElementSetting;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.StringManager;

public abstract class ExtraGuiElement {
    public boolean enabled = true;
    public ArrayList<ElementSetting> settings = new ArrayList();
    public boolean unsupported = false;

    public abstract String getName();

    public final String getLocalizedName() {
        return FormatUtil.translatePre("element." + this.getName(), new String[0]);
    }

    public Bounds getBounds(ScaledResolution resolution) {
        return Bounds.EMPTY;
    }

    public abstract boolean shouldProfile();

    public abstract void update(Minecraft var1);

    public abstract void render(Minecraft var1, ScaledResolution var2, StringManager var3, LayoutManager var4);

    public abstract void loadDefaults();

    public void init() {
    }

    public boolean shouldRender() {
        return this.enabled;
    }

    public final void loadSettings(HashMap<String, String> keyVals) {
        if (keyVals.containsKey("enabled")) {
            this.enabled = Boolean.parseBoolean(keyVals.get("enabled"));
        }
        for (ElementSetting setting : this.settings) {
            if (setting instanceof ElementSettingDivider || !keyVals.containsKey(setting.getName())) continue;
            setting.fromString(keyVals.get(setting.getName()));
        }
    }

    public final HashMap<String, String> saveSettings() {
        HashMap<String, String> keyVals = new HashMap<String, String>();
        for (ElementSetting setting : this.settings) {
            keyVals.put(setting.getName(), setting.toString());
        }
        return keyVals;
    }

    protected final void registerUpdates(UpdateSpeed speed) {
        speed.elements.add(this);
    }

    public static enum UpdateSpeed {
        SLOW,
        MEDIUM,
        FAST,
        FASTER;

        public ArrayList<ExtraGuiElement> elements = new ArrayList();
    }
}

