/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.settings.ElementSetting;
import tk.nukeduck.hud.element.settings.ElementSettingAbsolutePositionAnchored;
import tk.nukeduck.hud.element.settings.ElementSettingAnchor;
import tk.nukeduck.hud.element.settings.ElementSettingBoolean;
import tk.nukeduck.hud.element.settings.ElementSettingBooleanLeft;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.element.settings.ElementSettingMode;
import tk.nukeduck.hud.element.settings.ElementSettingModeRight;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.element.settings.ElementSettingPositionHorizontal;
import tk.nukeduck.hud.element.settings.ElementSettingSlider;
import tk.nukeduck.hud.element.settings.ElementSettingSliderPositioned;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.Point;
import tk.nukeduck.hud.util.RenderUtil;
import tk.nukeduck.hud.util.StringManager;

public class ExtraGuiElementArmorBars
extends ExtraGuiElement {
    private ElementSettingMode bars;
    private ElementSettingBoolean showName;
    private ElementSettingBoolean showDurability;
    private ElementSettingMode durabilityMode;
    private ElementSettingMode posMode;
    private ElementSettingPosition pos;
    private ElementSettingAbsolutePositionAnchored pos2;
    private ElementSettingAnchor anchor;
    private ElementSettingPosition alignment;
    private ElementSettingSlider[] damageWarnings;
    public static final DecimalFormat ONE_PLACE = new DecimalFormat("#.#");
    private Bounds bounds = Bounds.EMPTY;
    String[] textCache = new String[4];
    int[] widthCache = new int[4];

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.bars.index = 2;
        this.showName.value = true;
        this.showDurability.value = true;
        this.durabilityMode.index = 0;
        this.posMode.index = 0;
        this.pos.value = ElementSettingPosition.Position.MIDDLE_LEFT;
        this.alignment.value = ElementSettingPosition.Position.MIDDLE_LEFT;
        this.pos2.x = 5;
        this.pos2.y = 5;
        this.anchor.value = ElementSettingPosition.Position.TOP_LEFT.getFlag();
        this.damageWarnings[0].value = 45.0;
        this.damageWarnings[1].value = 25.0;
        this.damageWarnings[2].value = 10.0;
    }

    @Override
    public String getName() {
        return "armorBars";
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        return this.bounds;
    }

    public void updateBounds(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
    }

    public ExtraGuiElementArmorBars() {
        this.settings.add(new ElementSettingDivider("position"));
        this.posMode = new ElementSettingMode("posMode", new String[]{"setPos", "absolute"});
        this.settings.add(this.posMode);
        this.pos = new ElementSettingPositionHorizontal("position", ElementSettingPosition.Position.combine(ElementSettingPosition.Position.MIDDLE_LEFT, ElementSettingPosition.Position.MIDDLE_RIGHT)){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementArmorBars)ExtraGuiElementArmorBars.this).posMode.index == 0;
            }
        };
        this.settings.add(this.pos);
        this.alignment = new ElementSettingPositionHorizontal("alignment", ElementSettingPosition.Position.combine(ElementSettingPosition.Position.MIDDLE_LEFT, ElementSettingPosition.Position.MIDDLE_RIGHT)){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementArmorBars)ExtraGuiElementArmorBars.this).posMode.index != 0;
            }

            @Override
            public void otherAction(Collection<ElementSetting> settings) {
                if (((ExtraGuiElementArmorBars)ExtraGuiElementArmorBars.this).posMode.index == 0) {
                    this.value = ((ExtraGuiElementArmorBars)ExtraGuiElementArmorBars.this).pos.value;
                }
                super.otherAction(settings);
            }
        };
        this.settings.add(this.alignment);
        this.anchor = new ElementSettingAnchor("anchor");
        this.pos2 = new ElementSettingAbsolutePositionAnchored("position2", this.anchor){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementArmorBars)ExtraGuiElementArmorBars.this).posMode.index == 1;
            }
        };
        this.settings.add(this.pos2);
        this.settings.add(this.anchor);
        this.settings.add(new ElementSettingDivider("misc"));
        this.showDurability = new ElementSettingBooleanLeft("showDurability");
        this.settings.add(this.showDurability);
        this.durabilityMode = new ElementSettingModeRight("durabilityMode", new String[]{"values", "percent"}){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementArmorBars)ExtraGuiElementArmorBars.this).showDurability.value;
            }
        };
        this.settings.add(this.durabilityMode);
        this.showName = new ElementSettingBoolean("showName");
        this.settings.add(this.showName);
        this.bars = new ElementSettingMode("barType", new String[]{"hidden", "smallBars", "largeBars"});
        this.settings.add(this.bars);
        this.bars.comments.add("hidden, smallBars, largeBars");
        this.settings.add(new ElementSettingDivider("damageWarning"));
        this.damageWarnings = new ElementSettingSlider[3];
        ElementSettingPosition.Position[] positions = new ElementSettingPosition.Position[]{ElementSettingPosition.Position.MIDDLE_LEFT, ElementSettingPosition.Position.MIDDLE_CENTER, ElementSettingPosition.Position.MIDDLE_RIGHT};
        for (int i = 0; i < 3; ++i) {
            this.damageWarnings[i] = new ElementSettingSliderPositioned("damaged." + String.valueOf(i), 1.0, 100.0, positions[i]){

                @Override
                public String getSliderText() {
                    return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), FormatUtil.translatePre("strings.percent", String.valueOf((int)this.value)));
                }
            };
            this.settings.add(this.damageWarnings[i]);
            this.damageWarnings[i].accuracy = 1.0;
        }
    }

    @Override
    public void update(Minecraft mc) {
    }

    public String generateText(ItemStack item) {
        ArrayList<String> parts = new ArrayList<String>();
        if (this.showName.value) {
            parts.add(item.func_82833_r());
        }
        int maxDamage = item.func_77958_k();
        float value = (float)(maxDamage - item.func_77952_i()) / (float)maxDamage;
        if (this.showDurability.value) {
            if (this.durabilityMode.getValue().equals("percent")) {
                parts.add(FormatUtil.translatePre("strings.percent", ONE_PLACE.format((double)value * 100.0)));
            } else {
                parts.add(FormatUtil.translatePre("strings.outOf", String.valueOf(maxDamage - item.func_77952_i()), String.valueOf(maxDamage)));
            }
        }
        int count = -1;
        for (int a = 0; a < this.damageWarnings.length; ++a) {
            if (!((double)(value * 100.0f) <= this.damageWarnings[a].value)) continue;
            count = a;
        }
        String exclamation = count == -1 ? "" : FormatUtil.translatePre("strings.damaged." + count, new String[0]);
        return FormatUtil.separate(parts.toArray(new String[parts.size()])) + " " + exclamation;
    }

    public Point getPosition(ScaledResolution resolution, LayoutManager manager) {
        if (this.posMode.index == 0) {
            if (this.pos.value == ElementSettingPosition.Position.MIDDLE_LEFT) {
                return new Point(5, manager.get(ElementSettingPosition.Position.TOP_LEFT));
            }
            return new Point(resolution.func_78326_a() - this.bounds.getWidth() - 5, manager.get(ElementSettingPosition.Position.TOP_LEFT));
        }
        return new Point(this.pos2.x, this.pos2.y);
    }

    private Bounds generateBounds(Minecraft mc, ScaledResolution resolution, LayoutManager layoutManager, ItemStack[] armor) {
        Bounds b = Bounds.EMPTY.clone();
        b.setWidth(16);
        boolean anyArmor = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack item = armor[i];
            if (item == null) continue;
            anyArmor = true;
            if (!this.showName.value && !this.showDurability.value) continue;
            this.textCache[i] = this.generateText(item);
            this.widthCache[i] = 21 + mc.field_71466_p.func_78256_a(this.textCache[i]);
            if (this.widthCache[i] <= b.getWidth()) continue;
            b.setWidth(this.widthCache[i]);
        }
        if (!anyArmor) {
            return b;
        }
        if (this.bars.index == 2) {
            b.setWidth(Math.max(b.getWidth(), 85));
        } else if (this.bars.index == 1) {
            b.setWidth(Math.max(b.getWidth(), 20));
        }
        b.setHeight(70);
        b.setPosition(this.getPosition(resolution, layoutManager));
        return b;
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        int i;
        boolean left = this.alignment.value == ElementSettingPosition.Position.MIDDLE_LEFT;
        int cHeight = layoutManager.get(left ? ElementSettingPosition.Position.TOP_LEFT : ElementSettingPosition.Position.TOP_RIGHT);
        Object[] armor = (ItemStack[])mc.field_71439_g.field_71071_by.field_70460_b.clone();
        ArrayUtils.reverse((Object[])armor);
        this.bounds = this.generateBounds(mc, resolution, layoutManager, (ItemStack[])armor);
        this.pos2.update(resolution, this.bounds);
        if (this.bounds.getHeight() == 0) {
            return;
        }
        if (this.posMode.index == 0) {
            layoutManager.add(this.bounds.getHeight(), left ? ElementSettingPosition.Position.TOP_LEFT : ElementSettingPosition.Position.TOP_RIGHT);
        }
        mc.field_71424_I.func_76320_a("items");
        RenderHelper.func_74520_c();
        for (i = 0; i < 4; ++i) {
            Object stack = armor[i];
            if (stack == null) continue;
            mc.func_175599_af().func_180450_b((ItemStack)stack, left ? this.bounds.getX() : this.bounds.getX2() - 16, this.bounds.getY() + i * 18);
        }
        RenderHelper.func_74518_a();
        mc.field_71424_I.func_76319_b();
        if (this.showName.value || this.showDurability.value) {
            mc.field_71424_I.func_76320_a("text");
            int textOffset = this.bars.index == 2 ? 2 : 4;
            for (int i2 = 0; i2 < 4; ++i2) {
                Object stack = armor[i2];
                if (stack == null) continue;
                int x = left ? this.bounds.getX() + 21 : this.bounds.getX2() - this.widthCache[i2];
                mc.field_71456_v.func_73731_b(mc.field_71466_p, this.textCache[i2], x, this.bounds.getY() + i2 * 18 + textOffset, 0xFFFFFF);
            }
            mc.field_71424_I.func_76319_b();
        }
        if (this.bars.index != 0) {
            mc.field_71424_I.func_76320_a("bars");
            for (i = 0; i < 4; ++i) {
                int y;
                int x;
                if (armor[i] == null) continue;
                float value = (float)(armor[i].func_77958_k() - armor[i].func_77952_i()) / (float)armor[i].func_77958_k();
                if (this.bars.index == 2) {
                    x = this.alignment.value == ElementSettingPosition.Position.MIDDLE_LEFT ? this.bounds.getX() + 21 : this.bounds.getX2() - 85;
                    y = this.bounds.getY() + i * 18 + 12 + (this.showName.value || this.showDurability.value ? 0 : -4);
                    RenderUtil.drawProgressBar(x, y, x + 64, y + 2, value);
                    continue;
                }
                x = this.alignment.value == ElementSettingPosition.Position.MIDDLE_LEFT ? this.bounds.getX() + 16 : this.bounds.getX2() - 18;
                y = this.bounds.getY() + i * 18;
                RenderUtil.drawProgressBarV(x, y, x + 2, y + 16, value);
            }
            mc.field_71424_I.func_76319_b();
        }
    }

    @Override
    public boolean shouldProfile() {
        return true;
    }
}

