/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import tk.nukeduck.hud.BetterHud;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.settings.ElementSettingAbsolutePositionAnchored;
import tk.nukeduck.hud.element.settings.ElementSettingAnchor;
import tk.nukeduck.hud.element.settings.ElementSettingBoolean;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.element.settings.ElementSettingMode;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.element.settings.ElementSettingSlider;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.RenderUtil;
import tk.nukeduck.hud.util.StringManager;

public class ExtraGuiElementBlockViewer
extends ExtraGuiElement {
    private ElementSettingMode posMode;
    private ElementSettingPosition pos;
    private ElementSettingAbsolutePositionAnchored pos2;
    private ElementSettingAnchor anchor;
    private ElementSettingBoolean showBlock;
    private ElementSettingSlider distance;
    private ElementSettingBoolean showIds;
    private HashMap<Block, ItemStack> replaceStacks = new HashMap();
    private Bounds bounds = Bounds.EMPTY;

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.posMode.index = 0;
        this.pos.value = ElementSettingPosition.Position.TOP_CENTER;
        this.anchor.value = ElementSettingPosition.Position.TOP_LEFT.getFlag();
        this.pos2.x = 5;
        this.pos2.y = 5;
        this.showBlock.value = true;
        this.distance.value = 256.0;
        this.showIds.value = false;
    }

    @Override
    public String getName() {
        return "blockViewer";
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        return this.bounds;
    }

    public ExtraGuiElementBlockViewer() {
        this.replaceStacks.put(Blocks.field_150474_ac, new ItemStack(Blocks.field_150474_ac));
        this.replaceStacks.put(Blocks.field_150439_ay, new ItemStack(Blocks.field_150450_ax));
        this.replaceStacks.put(Blocks.field_150380_bt, new ItemStack(Blocks.field_150380_bt));
        this.replaceStacks.put(Blocks.field_150384_bq, new ItemStack(Blocks.field_150384_bq));
        this.settings.add(new ElementSettingDivider("position"));
        this.posMode = new ElementSettingMode("posMode", new String[]{"setPos", "absolute"});
        this.settings.add(this.posMode);
        this.pos = new ElementSettingPosition("position", ElementSettingPosition.Position.combine(ElementSettingPosition.Position.TOP_LEFT, ElementSettingPosition.Position.TOP_CENTER, ElementSettingPosition.Position.TOP_RIGHT, ElementSettingPosition.Position.BOTTOM_LEFT, ElementSettingPosition.Position.BOTTOM_RIGHT, ElementSettingPosition.Position.MIDDLE_CENTER)){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementBlockViewer)ExtraGuiElementBlockViewer.this).posMode.index == 0;
            }
        };
        this.settings.add(this.pos);
        this.anchor = new ElementSettingAnchor("anchor");
        this.pos2 = new ElementSettingAbsolutePositionAnchored("position2", this.anchor){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementBlockViewer)ExtraGuiElementBlockViewer.this).posMode.index == 1;
            }
        };
        this.settings.add(this.pos2);
        this.settings.add(this.anchor);
        this.settings.add(new ElementSettingDivider("misc"));
        this.showBlock = new ElementSettingBoolean("showBlock");
        this.settings.add(this.showBlock);
        this.distance = new ElementSettingSlider("distance", 6.0, 256.0){

            @Override
            public String getSliderText() {
                if (this.value % 16.0 == 0.0) {
                    int chunks = (int)(this.value / 16.0);
                    String chunkString = FormatUtil.translatePre(chunks == 1 ? "strings.chunk" : "strings.chunks", String.valueOf(chunks));
                    return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), chunkString);
                }
                String distanceString = FormatUtil.translatePre("strings.distanceShort", String.valueOf((int)this.value));
                return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), distanceString);
            }
        };
        this.settings.add(this.distance);
        this.distance.accuracy = 16.0;
        this.showIds = new ElementSettingBoolean("showIds");
        this.settings.add(this.showIds);
    }

    @Override
    public void update(Minecraft mc) {
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        RayTraceResult mop = mc.func_175606_aa().func_174822_a(this.distance.value, 1.0f);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            String l;
            if (mc.field_71441_e.func_175623_d(mop.func_178782_a())) {
                return;
            }
            IBlockState te = mc.field_71441_e.func_180495_p(mop.func_178782_a());
            ItemStack stack = te.func_177230_c().getPickBlock(te, mop, (World)mc.field_71441_e, mop.func_178782_a(), (EntityPlayer)mc.field_71439_g);
            for (Block block : this.replaceStacks.keySet()) {
                if (!te.func_177230_c().equals(block)) continue;
                stack = this.replaceStacks.get(block);
                break;
            }
            try {
                l = stack.func_82833_r();
            }
            catch (NullPointerException e) {
                try {
                    l = te.func_177230_c().func_149732_F();
                    stack = new ItemStack(Blocks.field_150348_b);
                }
                catch (Exception ex) {
                    l = FormatUtil.translatePre("strings.unknownBlock", new String[0]);
                    stack = new ItemStack(Blocks.field_150348_b);
                }
            }
            if (this.showIds.value) {
                String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)te.func_177230_c())).toString();
                String id = String.format("%04d", Block.func_149682_b((Block)te.func_177230_c()));
                String meta = String.valueOf(te.func_177230_c().func_176201_c(te));
                l = l + " " + ChatFormatting.YELLOW + FormatUtil.translatePre("strings.brackets", name + "/#" + id + ":" + meta);
            }
            int w = mc.field_71466_p.func_78256_a(l) + 10;
            if (this.showBlock.value) {
                w += 21;
            }
            int x = resolution.func_78326_a() / 2 - w - 5;
            int y = resolution.func_78328_b() / 2 - mc.field_71466_p.field_78288_b - 15;
            if (this.posMode.index == 1) {
                this.bounds = new Bounds(x, y, w, 11 + mc.field_71466_p.field_78288_b);
                this.pos2.update(resolution, this.bounds);
                x = this.pos2.x;
                y = this.pos2.y;
            } else if (this.pos.value == ElementSettingPosition.Position.TOP_LEFT) {
                x = 5;
                y = layoutManager.get(this.pos.value);
                layoutManager.add(10 + mc.field_71466_p.field_78288_b, this.pos.value);
            } else if (this.pos.value == ElementSettingPosition.Position.TOP_CENTER) {
                x = (resolution.func_78326_a() - w) / 2;
                y = BetterHud.proxy.elements.biome.enabled ? 60 : 50;
            } else if (this.pos.value == ElementSettingPosition.Position.TOP_RIGHT) {
                x = resolution.func_78326_a() - 5 - w;
                y = layoutManager.get(this.pos.value);
                layoutManager.add(10 + mc.field_71466_p.field_78288_b, this.pos.value);
            } else if (this.pos.value == ElementSettingPosition.Position.BOTTOM_LEFT) {
                x = 5;
                y = resolution.func_78328_b() - layoutManager.get(this.pos.value) - 10 - mc.field_71466_p.field_78288_b;
                layoutManager.add(10 + mc.field_71466_p.field_78288_b, this.pos.value);
            } else if (this.pos.value == ElementSettingPosition.Position.BOTTOM_RIGHT) {
                x = resolution.func_78326_a() - 5 - w;
                y = resolution.func_78328_b() - layoutManager.get(this.pos.value) - 10 - mc.field_71466_p.field_78288_b;
                layoutManager.add(10 + mc.field_71466_p.field_78288_b, this.pos.value);
            }
            if (this.posMode.index != 1) {
                this.bounds = new Bounds(x, y, w, 11 + mc.field_71466_p.field_78288_b);
            }
            this.renderBox(x, y, w, 11 + mc.field_71466_p.field_78288_b, RenderUtil.colorARGB(58, 0, 0, 0));
            if (this.showBlock.value) {
                mc.field_71456_v.func_73731_b(mc.field_71466_p, l, x + 26, y + 6, RenderUtil.colorRGB(255, 255, 255));
                RenderHelper.func_74520_c();
                mc.func_175599_af().func_180450_b(stack, x + 5, y + 2);
                RenderHelper.func_74518_a();
            } else {
                mc.field_71456_v.func_73731_b(mc.field_71466_p, l, x + 5, y + 6, RenderUtil.colorRGB(255, 255, 255));
            }
        }
    }

    public void renderBox(int x, int y, int width, int height, int color) {
        RenderUtil.drawRect(x + 1, y, x + width - 1, y + height, color);
        RenderUtil.drawRect(x, y + 1, x + 1, y + height - 1, color);
        RenderUtil.drawRect(x + width - 1, y + 1, x + width, y + height - 1, color);
        RenderUtil.drawRect(x + 1, y + 1, x + (width - 1), y + 2, color);
        RenderUtil.drawRect(x + 1, y + height - 2, x + (width - 1), y + height - 1, color);
        RenderUtil.drawRect(x + 1, y + 2, x + 2, y + height - 2, color);
        RenderUtil.drawRect(x + (width - 2), y + 2, x + (width - 1), y + height - 2, color);
    }

    @Override
    public boolean shouldProfile() {
        return true;
    }
}

