/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.settings.ElementSettingAbsolutePositionAnchored;
import tk.nukeduck.hud.element.settings.ElementSettingAnchor;
import tk.nukeduck.hud.element.settings.ElementSettingBoolean;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.element.settings.ElementSettingMode;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.element.settings.ElementSettingSlider;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.RenderUtil;
import tk.nukeduck.hud.util.StringManager;

public class ExtraGuiElementCompass
extends ExtraGuiElement {
    private ElementSettingMode posMode;
    private ElementSettingAbsolutePositionAnchored pos;
    private ElementSettingAnchor anchor;
    private ElementSettingSlider directionScaling;
    private ElementSettingBoolean showNotches;
    private ElementSettingSlider scale;
    public static final double degreesPerRadian = 57.29577951308232;
    public static int nColor = RenderUtil.colorRGB(255, 0, 0);
    public static int ewColor = RenderUtil.colorRGB(255, 255, 255);
    public static int sColor = RenderUtil.colorRGB(0, 0, 255);
    private int[] notchX = new int[9];

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.posMode.index = 0;
        this.anchor.value = ElementSettingPosition.Position.TOP_LEFT.getFlag();
        this.pos.x = 5;
        this.pos.y = 5;
        this.directionScaling.value = 50.0;
        this.showNotches.value = true;
        this.scale.value = 100.0;
    }

    @Override
    public String getName() {
        return "compass";
    }

    public ExtraGuiElementCompass() {
        int x = 0;
        for (double i = 0.1; i < 0.9; i += 0.1) {
            this.notchX[x] = (int)(Math.asin(i) / Math.PI * 180.0);
            ++x;
        }
        this.settings.add(new ElementSettingDivider("position"));
        this.posMode = new ElementSettingMode("posMode", new String[]{"setPos", "absolute"});
        this.settings.add(this.posMode);
        this.anchor = new ElementSettingAnchor("anchor");
        this.pos = new ElementSettingAbsolutePositionAnchored("position", this.anchor){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementCompass)ExtraGuiElementCompass.this).posMode.index == 1;
            }
        };
        this.settings.add(this.pos);
        this.settings.add(this.anchor);
        this.settings.add(new ElementSettingDivider("misc"));
        this.directionScaling = new ElementSettingSlider("scaledDirections", 0.0, 100.0){

            @Override
            public String getSliderText() {
                return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), FormatUtil.translatePre("strings.percent", String.valueOf((int)this.value)));
            }
        };
        this.settings.add(this.directionScaling);
        this.directionScaling.accuracy = 1.0;
        this.scale = new ElementSettingSlider("scale", 25.0, 200.0){

            @Override
            public String getSliderText() {
                return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), FormatUtil.translatePre("strings.percent", String.valueOf((int)this.value)));
            }
        };
        this.settings.add(this.scale);
        this.directionScaling.accuracy = 1.0;
        this.showNotches = new ElementSettingBoolean("showNotches");
        this.settings.add(this.showNotches);
    }

    @Override
    public void update(Minecraft mc) {
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        int x = this.posMode.index == 0 ? resolution.func_78326_a() / 2 - 90 : this.pos.x;
        int y = this.posMode.index == 0 ? 18 : this.pos.y;
        return new Bounds((int)Math.round((double)x - 90.0 * (this.scale.value - 100.0) / 100.0), y, (int)Math.round(180.0 * this.scale.value / 100.0), (int)Math.round(12.0 * this.scale.value / 100.0));
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        float finalSize;
        float size;
        double offsetQuarter = Math.toRadians(90.0);
        double transform = Math.toRadians(mc.field_71439_g.field_70177_z);
        short nOpacity = (short)Math.abs(Math.sin(transform / 2.0) * 255.0);
        short wOpacity = (short)Math.abs(Math.sin((transform + offsetQuarter) / 2.0) * 255.0);
        short sOpacity = (short)Math.abs(Math.sin((transform + offsetQuarter * 2.0) / 2.0) * 255.0);
        short eOpacity = (short)Math.abs(Math.sin((transform - offsetQuarter) / 2.0) * 255.0);
        int nX = (int)(Math.sin(transform + offsetQuarter * 2.0) * 100.0);
        int eX = (int)(Math.sin(transform + offsetQuarter) * 100.0);
        int sX = (int)(Math.sin(transform) * 100.0);
        int wX = (int)(Math.sin(transform - offsetQuarter) * 100.0);
        if (this.posMode.index == 1) {
            this.pos.update(resolution, this.getBounds(resolution));
        }
        int x = this.posMode.index == 0 ? resolution.func_78326_a() / 2 - 90 : this.pos.x;
        int y = this.posMode.index == 0 ? 18 : this.pos.y;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x + 90), (float)y, (float)0.0f);
        GL11.glScaled((double)(this.scale.value / 100.0), (double)(this.scale.value / 100.0), (double)1.0);
        GL11.glTranslatef((float)(-x - 90), (float)(-y), (float)0.0f);
        RenderUtil.drawRect(x, y, x + 180, y + 12, RenderUtil.colorARGB(170, 0, 0, 0));
        RenderUtil.drawRect(x + 50, y, x + 130, y + 12, RenderUtil.colorARGB(85, 85, 85, 85));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71424_I.func_76320_a("text");
        int maxScale = 4;
        float factor = 100 / maxScale;
        if (nOpacity > 10) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x + 90 - nX), (float)(y + 2), (float)0.0f);
            size = (float)nOpacity / 128.0f;
            finalSize = Math.max(0.0f, (float)(this.directionScaling.value / (double)factor) * (size - 1.0f) + 1.0f);
            GL11.glScalef((float)finalSize, (float)finalSize, (float)1.0f);
            mc.field_71456_v.func_73732_a(mc.field_71466_p, "N", 0, 0, RenderUtil.colorARGB(nOpacity, 255, 0, 0));
            GL11.glPopMatrix();
        }
        if (eOpacity > 10) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x + 90 - eX), (float)(y + 2), (float)0.0f);
            size = (float)eOpacity / 128.0f;
            finalSize = Math.max(0.0f, (float)(this.directionScaling.value / (double)factor) * (size - 1.0f) + 1.0f);
            GL11.glScalef((float)finalSize, (float)finalSize, (float)1.0f);
            mc.field_71456_v.func_73732_a(mc.field_71466_p, "E", 0, 0, RenderUtil.colorARGB(eOpacity, 255, 255, 255));
            GL11.glPopMatrix();
        }
        if (sOpacity > 10) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x + 90 - sX), (float)(y + 2), (float)0.0f);
            size = (float)sOpacity / 128.0f;
            finalSize = Math.max(0.0f, (float)(this.directionScaling.value / (double)factor) * (size - 1.0f) + 1.0f);
            GL11.glScalef((float)finalSize, (float)finalSize, (float)1.0f);
            mc.field_71456_v.func_73732_a(mc.field_71466_p, "S", 0, 0, RenderUtil.colorARGB(sOpacity, 0, 0, 255));
            GL11.glPopMatrix();
        }
        if (wOpacity > 10) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x + 90 - wX), (float)(y + 2), (float)0.0f);
            size = (float)wOpacity / 128.0f;
            finalSize = Math.max(0.0f, (float)(this.directionScaling.value / (double)factor) * (size - 1.0f) + 1.0f);
            GL11.glScalef((float)finalSize, (float)finalSize, (float)1.0f);
            mc.field_71456_v.func_73732_a(mc.field_71466_p, "W", 0, 0, RenderUtil.colorARGB(wOpacity, 255, 255, 255));
            GL11.glPopMatrix();
        }
        mc.field_71424_I.func_76319_b();
        mc.field_71424_I.func_76320_a("notches");
        int largeNotch = RenderUtil.colorRGB(255, 255, 255);
        if (this.showNotches.value) {
            largeNotch = RenderUtil.colorRGB(255, 0, 0);
            for (int loc : this.notchX) {
                RenderUtil.drawRect(x + loc - 1, y - 2, x + loc, y + 4, RenderUtil.colorRGB(255, 255, 255));
                RenderUtil.drawRect(x - loc + 180, y - 2, x - loc + 181, y + 4, RenderUtil.colorRGB(255, 255, 255));
            }
        }
        RenderUtil.drawRect(x + 89, y - 3, x + 90, y + 4, largeNotch);
        RenderUtil.drawRect(x, y - 3, x + 1, y + 4, largeNotch);
        RenderUtil.drawRect(x + 180, y - 3, x + 179, y + 4, largeNotch);
        mc.field_71424_I.func_76319_b();
        GL11.glPopMatrix();
    }

    @Override
    public boolean shouldProfile() {
        return true;
    }
}

