/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.passive.EntityHorse;
import tk.nukeduck.hud.element.settings.ElementSettingBoolean;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.element.settings.ElementSettingText;
import tk.nukeduck.hud.element.text.ExtraGuiElementText;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.RenderUtil;
import tk.nukeduck.hud.util.StringManager;

public class ExtraGuiElementExperienceInfo
extends ExtraGuiElementText {
    private ElementSettingBoolean total;

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.total.value = false;
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        return super.getBounds(resolution);
    }

    public ExtraGuiElementExperienceInfo() {
        this.settings.add(0, new ElementSettingDivider("position"));
        this.settings.add(0, new ElementSettingText("expInfoNotice"));
        this.settings.add(new ElementSettingDivider("misc"));
        this.total = new ElementSettingBoolean("total");
        this.settings.add(this.total);
    }

    @Override
    public String getName() {
        return "experienceInfo";
    }

    @Override
    public void update(Minecraft mc) {
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        if (!(mc.field_71439_g.field_71075_bZ.field_75098_d || mc.field_71439_g.func_184187_bx() != null && mc.field_71439_g.func_184187_bx() instanceof EntityHorse)) {
            int has = Math.round(mc.field_71439_g.field_71106_cc * (float)this.getExperienceWithinLevel(mc.field_71439_g.field_71068_ca));
            int needed = this.getExperienceWithinLevel(mc.field_71439_g.field_71068_ca) - has;
            this.drawBorderedString(mc.field_71466_p, String.valueOf(has), resolution.func_78326_a() / 2 - 90, resolution.func_78328_b() - 30, RenderUtil.colorRGB(255, 255, 255));
            this.drawBorderedString(mc.field_71466_p, String.valueOf(needed), resolution.func_78326_a() / 2 + 90 - mc.field_71466_p.func_78256_a(String.valueOf(needed)), resolution.func_78328_b() - 30, RenderUtil.colorRGB(255, 255, 255));
        }
        if (this.total.value) {
            super.render(mc, resolution, stringManager, layoutManager);
        }
    }

    public void drawBorderedString(FontRenderer fontrenderer, String s, int x, int y, int color) {
        fontrenderer.func_175065_a(s, (float)(x + 1), (float)y, 0, false);
        fontrenderer.func_175065_a(s, (float)(x - 1), (float)y, 0, false);
        fontrenderer.func_175065_a(s, (float)x, (float)(y + 1), 0, false);
        fontrenderer.func_175065_a(s, (float)x, (float)(y - 1), 0, false);
        fontrenderer.func_175065_a(s, (float)x, (float)y, color, false);
    }

    public int getExperienceWithinLevel(int level) {
        if (level >= 31) {
            return 9 * level - 158;
        }
        if (level >= 16) {
            return 5 * level - 38;
        }
        return 2 * level + 7;
    }

    @Override
    public boolean shouldProfile() {
        return true;
    }

    @Override
    protected String[] getText(Minecraft mc) {
        if (!this.total.value) {
            return new String[0];
        }
        int totalExp = Math.round(mc.field_71439_g.field_71106_cc * (float)this.getExperienceWithinLevel(mc.field_71439_g.field_71068_ca));
        for (int i = 0; i < mc.field_71439_g.field_71068_ca; ++i) {
            totalExp += this.getExperienceWithinLevel(i);
        }
        return new String[]{FormatUtil.translatePre("strings.total", String.valueOf(totalExp))};
    }
}

