/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.ExtraGuiElementArmorBars;
import tk.nukeduck.hud.element.settings.ElementSettingAbsolutePositionAnchored;
import tk.nukeduck.hud.element.settings.ElementSettingAnchor;
import tk.nukeduck.hud.element.settings.ElementSettingBoolean;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.element.settings.ElementSettingMode;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.RenderUtil;
import tk.nukeduck.hud.util.StringManager;

public class ExtraGuiElementHandBar
extends ExtraGuiElement {
    private ElementSettingMode posMode;
    private ElementSettingAbsolutePositionAnchored pos;
    private ElementSettingAnchor anchor;
    private ElementSettingBoolean showName;
    private ElementSettingBoolean showDurability;
    private ElementSettingMode durabilityMode;
    private ElementSettingBoolean showItem;
    private ElementSettingBoolean offHand;
    private Bounds bounds = Bounds.EMPTY;

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.posMode.index = 0;
        this.pos.x = 5;
        this.pos.y = 5;
        this.showName.value = true;
        this.showDurability.value = true;
        this.durabilityMode.index = 0;
        this.showItem.value = true;
        this.offHand.value = false;
    }

    @Override
    public String getName() {
        return "handBar";
    }

    public ExtraGuiElementHandBar() {
        this.settings.add(new ElementSettingDivider("position"));
        this.posMode = new ElementSettingMode("posMode", new String[]{"setPos", "absolute"});
        this.settings.add(this.posMode);
        this.anchor = new ElementSettingAnchor("anchor");
        this.pos = new ElementSettingAbsolutePositionAnchored("position", this.anchor){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementHandBar)ExtraGuiElementHandBar.this).posMode.index == 1;
            }
        };
        this.settings.add(this.pos);
        this.settings.add(this.anchor);
        this.settings.add(new ElementSettingDivider("misc"));
        this.showItem = new ElementSettingBoolean("showItem");
        this.settings.add(this.showItem);
        this.showDurability = new ElementSettingBoolean("showDurability");
        this.settings.add(this.showDurability);
        this.durabilityMode = new ElementSettingMode("durabilityMode", new String[]{"values", "percent"});
        this.settings.add(this.durabilityMode);
        this.showName = new ElementSettingBoolean("showName");
        this.settings.add(this.showName);
        this.offHand = new ElementSettingBoolean("offHand");
        this.settings.add(this.offHand);
    }

    @Override
    public void update(Minecraft mc) {
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        return this.bounds;
    }

    public void renderBar(Minecraft mc, ItemStack stack, int x, int y) {
        int maxDamage = stack.func_77958_k();
        float value = (float)(maxDamage - stack.func_77952_i()) / (float)maxDamage;
        byte green = (byte)(255.0f * value);
        byte red = (byte)(256 - green);
        String text = "";
        String dur = this.durabilityMode.getValue().equals("percent") ? FormatUtil.translatePre("strings.percent", ExtraGuiElementArmorBars.ONE_PLACE.format((double)value * 100.0)) : FormatUtil.translatePre("strings.outOf", String.valueOf(maxDamage - stack.func_77952_i()), String.valueOf(maxDamage));
        if (this.showName.value && this.showDurability.value) {
            text = FormatUtil.translatePre("strings.separated", stack.func_82833_r(), dur);
        } else if (this.showName.value) {
            text = stack.func_82833_r();
        } else if (this.showDurability.value) {
            text = dur;
        }
        int totalWidth = mc.field_71466_p.func_78256_a(text);
        if (this.showItem.value) {
            totalWidth += 21;
        }
        if (this.showItem.value) {
            mc.field_71424_I.func_76320_a("items");
            mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            RenderUtil.renderItem(mc.func_175599_af(), mc.field_71466_p, mc.func_110434_K(), stack, x + 90 - totalWidth / 2, y);
            mc.field_71424_I.func_76319_b();
        }
        mc.field_71424_I.func_76320_a("text");
        mc.field_71456_v.func_73731_b(mc.field_71466_p, text, x + 90 - totalWidth / 2 + (this.showItem.value ? 21 : 0), y + 4, RenderUtil.colorRGB(255, 255, 255));
        mc.field_71424_I.func_76319_b();
        mc.field_71424_I.func_76320_a("bars");
        RenderUtil.drawRect(x, y + 16, x + 180, y + 18, RenderUtil.colorARGB(255, 0, 0, 0));
        RenderUtil.drawRect(x, y + 16, x + Math.round(value * 180.0f), y + 17, RenderUtil.colorARGB(255, red, green, 0));
        mc.field_71424_I.func_76319_b();
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        int x;
        int n = x = this.posMode.index == 0 ? resolution.func_78326_a() / 2 - 90 : this.pos.x;
        int y = this.posMode.index == 0 ? resolution.func_78328_b() - (this.offHand.value ? 107 : 84) : this.pos.y;
        this.bounds = new Bounds(x, y, 180, this.offHand.value ? 41 : 18);
        this.pos.update(resolution, this.bounds);
        ItemStack stack = mc.field_71439_g.func_184614_ca();
        if (stack != null && stack.func_77958_k() > 0) {
            this.renderBar(mc, stack, x, this.bounds.getY2() - 18);
        }
        if (this.offHand.value && (stack = mc.field_71439_g.func_184592_cb()) != null && stack.func_77958_k() > 0) {
            this.renderBar(mc, stack, x, this.bounds.getY());
        }
    }

    @Override
    public boolean shouldProfile() {
        return true;
    }
}

