/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.settings.ElementSettingAbsolutePositionAnchored;
import tk.nukeduck.hud.element.settings.ElementSettingAnchor;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.element.settings.ElementSettingMode;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.element.settings.ElementSettingSlider;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.StringManager;
import tk.nukeduck.hud.util.constants.Textures;

public class ExtraGuiElementHungerIndicator
extends ExtraGuiElement {
    private ElementSettingMode posMode;
    private ElementSettingPosition pos;
    private ElementSettingAbsolutePositionAnchored pos2;
    private ElementSettingAnchor anchor;
    private ElementSettingSlider maxLimit;
    private static final ItemStack beef = new ItemStack(Items.field_151083_be);

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.posMode.index = 0;
        this.pos.value = ElementSettingPosition.Position.BOTTOM_CENTER;
        this.anchor.value = ElementSettingPosition.Position.TOP_LEFT.getFlag();
        this.pos2.x = 5;
        this.pos2.y = 5;
        this.maxLimit.value = 9.5;
    }

    @Override
    public String getName() {
        return "foodIndicator";
    }

    public ExtraGuiElementHungerIndicator() {
        this.settings.add(new ElementSettingDivider("position"));
        this.posMode = new ElementSettingMode("posMode", new String[]{"setPos", "absolute"});
        this.settings.add(this.posMode);
        this.pos = new ElementSettingPosition("position", ElementSettingPosition.Position.combine(ElementSettingPosition.Position.MIDDLE_CENTER, ElementSettingPosition.Position.BOTTOM_CENTER)){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementHungerIndicator)ExtraGuiElementHungerIndicator.this).posMode.index == 0;
            }
        };
        this.settings.add(this.pos);
        this.anchor = new ElementSettingAnchor("anchor");
        this.pos2 = new ElementSettingAbsolutePositionAnchored("position2", this.anchor){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementHungerIndicator)ExtraGuiElementHungerIndicator.this).posMode.index == 1;
            }
        };
        this.settings.add(this.pos2);
        this.settings.add(this.anchor);
        this.settings.add(new ElementSettingDivider("misc"));
        this.maxLimit = new ElementSettingSlider("maxLimit", 0.0, 10.0);
        this.settings.add(this.maxLimit);
        this.maxLimit.accuracy = 0.5;
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        int y;
        int x;
        if (this.posMode.index == 1) {
            x = this.pos2.x;
            y = this.pos2.y;
        } else if (this.pos.value == ElementSettingPosition.Position.MIDDLE_CENTER) {
            x = resolution.func_78326_a() / 2 + 5;
            y = resolution.func_78328_b() / 2 + 5;
        } else {
            x = resolution.func_78326_a() / 2 + 75;
            y = resolution.func_78328_b() - 56;
        }
        return new Bounds(x, y, 16, 16);
    }

    @Override
    public void update(Minecraft mc) {
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        double foodMax;
        double foodLevel = mc.field_71439_g.func_71024_bL().func_75116_a();
        if (foodLevel <= (foodMax = this.maxLimit.value * 2.0)) {
            double speed = (foodMax - foodLevel) / foodMax * 50.0 + 2.0;
            double alpha = Math.sin((double)System.currentTimeMillis() / 3000.0 * speed) + 0.5;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)alpha);
            mc.func_110434_K().func_110577_a(Textures.iconsHud);
            int x = 0;
            int y = 0;
            if (this.posMode.index == 1) {
                this.pos2.update(resolution, this.getBounds(resolution));
                x = this.pos2.x;
                y = this.pos2.y;
            } else if (this.pos.value == ElementSettingPosition.Position.MIDDLE_CENTER) {
                x = resolution.func_78326_a() / 2 + 5;
                y = resolution.func_78328_b() / 2 + 5;
            } else {
                x = resolution.func_78326_a() / 2 + 75;
                y = resolution.func_78328_b() - 56;
            }
            mc.field_71456_v.func_73729_b(x, y, 0, 64, 16, 16);
        }
    }

    @Override
    public boolean shouldProfile() {
        return true;
    }
}

