/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.settings.ElementSettingAbsolutePosition;
import tk.nukeduck.hud.element.settings.ElementSettingMode;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.network.PickupHandler;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.RenderUtil;
import tk.nukeduck.hud.util.StringManager;

public class ExtraGuiElementPickup
extends ExtraGuiElement {
    private ElementSettingMode posMode;
    private ElementSettingPosition pos;
    private ElementSettingAbsolutePosition pos2;
    public final PickupHandler handler = new PickupHandler();
    private Bounds bounds = Bounds.EMPTY;

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.posMode.index = 0;
        this.pos.value = ElementSettingPosition.Position.MIDDLE_CENTER;
        this.pos2.x = 5;
        this.pos2.y = 5;
    }

    @Override
    public String getName() {
        return "itemPickup";
    }

    public ExtraGuiElementPickup() {
        this.posMode = new ElementSettingMode("posMode", new String[]{"setPos", "absolute"});
        this.settings.add(this.posMode);
        this.pos = new ElementSettingPosition("position", ElementSettingPosition.Position.combine(ElementSettingPosition.Position.TOP_LEFT, ElementSettingPosition.Position.TOP_RIGHT, ElementSettingPosition.Position.BOTTOM_LEFT, ElementSettingPosition.Position.BOTTOM_RIGHT, ElementSettingPosition.Position.MIDDLE_CENTER)){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementPickup)ExtraGuiElementPickup.this).posMode.index == 0;
            }
        };
        this.settings.add(this.pos);
        this.pos2 = new ElementSettingAbsolutePosition("position2"){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementPickup)ExtraGuiElementPickup.this).posMode.index == 1;
            }
        };
        this.settings.add(this.pos2);
        this.registerUpdates(ExtraGuiElement.UpdateSpeed.FASTER);
    }

    @Override
    public void update(Minecraft mc) {
        this.handler.update(mc);
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        return this.bounds;
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        Map<ItemStack, Float> sortedMap = ExtraGuiElementPickup.sortByComparator(this.handler.pickedUp);
        boolean top = this.pos.value == ElementSettingPosition.Position.TOP_LEFT || this.pos.value == ElementSettingPosition.Position.TOP_RIGHT;
        boolean left = this.pos.value == ElementSettingPosition.Position.TOP_LEFT || this.pos.value == ElementSettingPosition.Position.BOTTOM_LEFT;
        int n = 0;
        for (Map.Entry<ItemStack, Float> entry : sortedMap.entrySet()) {
            int y;
            int x;
            ++n;
            ItemStack i = entry.getKey();
            String text = i.field_77994_a + "x " + i.func_82833_r();
            int textWidth = mc.field_71466_p.func_78256_a(text);
            if (this.posMode.index == 1) {
                x = this.pos2.x + 21;
                y = this.pos2.y + 4;
            } else if (this.pos.value == ElementSettingPosition.Position.MIDDLE_CENTER) {
                x = resolution.func_78326_a() / 2 - textWidth / 2 + 10;
                y = resolution.func_78328_b() / 2 - 40 - (mc.field_71466_p.field_78288_b + 5) * (n - 1);
            } else {
                x = left ? 26 : resolution.func_78326_a() - textWidth - 5;
                y = top ? (mc.field_71466_p.field_78288_b + 5) * (n - 1) + layoutManager.get(this.pos.value) : resolution.func_78328_b() - (mc.field_71466_p.field_78288_b + 5) * (n - 1) - mc.field_71466_p.field_78288_b - layoutManager.get(this.pos.value);
            }
            int a = (int)(entry.getValue().floatValue() * 255.0f);
            if (a >= 5) {
                mc.field_71456_v.func_73731_b(mc.field_71466_p, text, x, y, RenderUtil.colorARGB(a, 255, 255, 255));
            }
            RenderHelper.func_74520_c();
            int x2 = x - 21;
            int y2 = y - (16 - mc.field_71466_p.field_78288_b) / 2;
            this.bounds = new Bounds(x2, y2, 21 + mc.field_71466_p.func_78256_a(text), 16);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x2 + 8), (float)(y2 + 8), (float)0.0f);
            float b = entry.getValue().floatValue();
            GL11.glScalef((float)b, (float)b, (float)b);
            GL11.glTranslatef((float)(-x2 - 8), (float)(-y2 - 10), (float)0.0f);
            mc.func_175599_af().func_180450_b(i, x2, y2);
            GL11.glPopMatrix();
        }
        if (n > 0) {
            layoutManager.add((mc.field_71466_p.field_78288_b + 5) * n, this.pos.value);
        }
    }

    private static Map<ItemStack, Float> sortByComparator(Map<ItemStack, Float> unsortMap) {
        LinkedList<Map.Entry<ItemStack, Float>> list = new LinkedList<Map.Entry<ItemStack, Float>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<ItemStack, Float>>(){

            @Override
            public int compare(Map.Entry<ItemStack, Float> o1, Map.Entry<ItemStack, Float> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        LinkedHashMap<ItemStack, Float> sortedMap = new LinkedHashMap<ItemStack, Float>();
        for (Map.Entry entry : list) {
            sortedMap.put((ItemStack)entry.getKey(), (Float)entry.getValue());
        }
        return sortedMap;
    }

    @Override
    public boolean shouldProfile() {
        return true;
    }
}

