/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.entityinfo;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import tk.nukeduck.hud.element.entityinfo.ExtraGuiElementEntityInfo;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.element.settings.ElementSettingPositionHorizontal;
import tk.nukeduck.hud.element.settings.ElementSettingSlider;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.RenderUtil;
import tk.nukeduck.hud.util.constants.Textures;

public class ExtraGuiElementBreedIndicator
extends ExtraGuiElementEntityInfo {
    ElementSettingPosition pos = new ElementSettingPositionHorizontal("position", ElementSettingPosition.Position.combine(ElementSettingPosition.Position.MIDDLE_LEFT, ElementSettingPosition.Position.MIDDLE_RIGHT));

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.pos.value = ElementSettingPosition.Position.MIDDLE_LEFT;
        this.distance.value = 100.0;
    }

    @Override
    public String getName() {
        return "breedIndicator";
    }

    public ExtraGuiElementBreedIndicator() {
        this.settings.add(this.pos);
        this.distance = new ElementSettingSlider("distance", 5.0, 200.0){

            @Override
            public String getSliderText() {
                return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), FormatUtil.translatePre("strings.distanceShort", String.valueOf((int)this.value)));
            }
        };
        this.settings.add(this.distance);
    }

    public int getBreedingItemIndex(EntityAnimal entity) {
        Item[] items = new Item[]{Items.field_151172_bF, Items.field_151014_N, Items.field_151015_O};
        for (int i = 0; i < items.length; ++i) {
            if (!entity.func_70877_b(new ItemStack(items[i]))) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public void renderInfo(EntityLivingBase entity, Minecraft mc, float partialTicks) {
        if (entity instanceof EntityAnimal) {
            EntityPlayerSP player = mc.field_71439_g;
            Tessellator t = Tessellator.func_178181_a();
            int breedItemIndex = this.getBreedingItemIndex((EntityAnimal)entity);
            if (breedItemIndex != -1 && ((EntityAnimal)entity).func_70874_b() >= 0) {
                GL11.glPushMatrix();
                RenderUtil.billBoard((Entity)entity, (EntityPlayer)player, partialTicks);
                boolean love = ((EntityAnimal)entity).func_70880_s();
                float perLine = 10.0f;
                int width = 20;
                int height = 20;
                if (this.pos.value == ElementSettingPosition.Position.MIDDLE_RIGHT) {
                    GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
                }
                float scale = 0.0125f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glTranslatef((float)(this.pos.value == ElementSettingPosition.Position.MIDDLE_LEFT ? (float)(-width - 5) : 5.0f), (float)0.0f, (float)0.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                RenderUtil.renderQuad(t, 0, 0, width, height, 0.0f, 0.0f, 0.0f, 0.5f);
                RenderUtil.zIncrease();
                GL11.glPushAttrib((int)1048575);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(Textures.iconsHud);
                RenderUtil.renderQuadWithUV(Tessellator.func_178181_a(), 2, 2, (float)(breedItemIndex * 16) / 256.0f, 0.25f, 16, 16);
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            }
        }
    }
}

