/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.entityinfo;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;
import tk.nukeduck.hud.element.entityinfo.ExtraGuiElementEntityInfo;
import tk.nukeduck.hud.element.settings.ElementSettingBoolean;
import tk.nukeduck.hud.element.settings.ElementSettingSlider;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.RenderUtil;

public class ExtraGuiElementHorseInfo
extends ExtraGuiElementEntityInfo {
    ElementSettingBoolean jump = new ElementSettingBoolean("jump");
    ElementSettingBoolean speed;

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.jump.value = true;
        this.speed.value = true;
        this.distance.value = 100.0;
    }

    @Override
    public String getName() {
        return "horseInfo";
    }

    public ExtraGuiElementHorseInfo() {
        this.settings.add(this.jump);
        this.speed = new ElementSettingBoolean("speed");
        this.settings.add(this.speed);
        this.distance = new ElementSettingSlider("distance", 5.0, 200.0){

            @Override
            public String getSliderText() {
                return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), FormatUtil.translatePre("strings.distanceShort", String.valueOf((int)this.value)));
            }
        };
        this.settings.add(this.distance);
    }

    @Override
    public void renderInfo(EntityLivingBase entity, Minecraft mc, float partialTicks) {
        if (this.enabled && entity instanceof EntityHorse) {
            Tessellator t = Tessellator.func_178181_a();
            GL11.glPushMatrix();
            ArrayList<String> infoParts = new ArrayList<String>();
            EntityHorse horse = (EntityHorse)entity;
            if (this.jump.value) {
                infoParts.add(FormatUtil.translatePre("strings.jump", String.valueOf((double)Math.round(this.getJumpHeight(horse) * 1000.0) / 1000.0)));
            }
            if (this.speed.value) {
                infoParts.add(FormatUtil.translatePre("strings.speed", String.valueOf((double)Math.round(horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * 43.05 * 100.0) / 100.0)));
            }
            int horseWidth = FormatUtil.getLongestWidth(mc.field_71466_p, infoParts) + 10;
            int horseHeight = infoParts.size() * (mc.field_71466_p.field_78288_b + 2) + 8;
            RenderUtil.billBoard((Entity)entity, (EntityPlayer)mc.field_71439_g, partialTicks);
            float scale = 1.0f / (float)horseWidth;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTranslatef((float)0.0f, (float)(-horseHeight - 5), (float)0.0f);
            RenderUtil.renderQuad(t, 0, 0, horseWidth, horseHeight, 0.0f, 0.0f, 0.0f, 0.5f);
            RenderUtil.zIncrease();
            for (int i = 0; i < infoParts.size(); ++i) {
                mc.field_71456_v.func_73731_b(mc.field_71466_p, infoParts.get(i), 5, 5 + (mc.field_71466_p.field_78288_b + 2) * i, RenderUtil.colorRGB(255, 255, 255));
            }
            GL11.glPopMatrix();
        }
    }

    public double getJumpHeight(EntityHorse horse) {
        double jumpHeight = 0.0;
        for (double yVelocity = horse.func_110215_cj(); yVelocity > 0.0; yVelocity *= 0.98) {
            jumpHeight += yVelocity;
            yVelocity -= 0.08;
        }
        return jumpHeight;
    }
}

