/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.particles;

import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;
import tk.nukeduck.hud.BetterHud;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.particles.GuiParticleManager;
import tk.nukeduck.hud.element.particles.GuiParticleWater;
import tk.nukeduck.hud.element.settings.ElementSettingMode;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.StringManager;
import tk.nukeduck.hud.util.constants.Textures;

public class ExtraGuiElementWaterDrops
extends ExtraGuiElement {
    public ElementSettingMode density;
    GuiParticleManager<GuiParticleWater> particleManager = new GuiParticleManager();
    private boolean isUnderwater = false;

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.density.index = 1;
    }

    @Override
    public String getName() {
        return "waterDrops";
    }

    public ExtraGuiElementWaterDrops() {
        this.density = new ElementSettingMode("density", new String[]{"blood.sparse", "blood.normal", "blood.dense", "blood.denser"});
        this.settings.add(this.density);
        this.registerUpdates(ExtraGuiElement.UpdateSpeed.FASTER);
    }

    @Override
    public void update(Minecraft mc) {
        BlockPos pos;
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        this.particleManager.update(mc);
        EntityPlayerSP entityplayer = mc.field_71439_g;
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        if (!this.isUnderwater) {
            if (entityplayer.func_70055_a(Material.field_151586_h)) {
                this.isUnderwater = true;
                this.particleManager.particles.clear();
            }
        } else if (!entityplayer.func_70055_a(Material.field_151586_h)) {
            this.isUnderwater = false;
            if (this.enabled) {
                int max = 10 * (this.density.index + 1);
                for (int i = 0; i < max; ++i) {
                    this.particleManager.particles.add(GuiParticleWater.random(width, height));
                }
            }
        }
        if (mc.field_71441_e.func_175727_C(pos = new BlockPos(entityplayer.field_70165_t, entityplayer.field_70163_u + (double)entityplayer.func_70047_e(), entityplayer.field_70161_v)) && BetterHud.random.nextInt((4 - this.density.index) * 3) == 0) {
            this.particleManager.particles.add(GuiParticleWater.random(width, height));
        }
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        GL11.glEnable((int)3042);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Textures.particles);
        this.particleManager.renderAll(mc);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean shouldProfile() {
        return this.particleManager.particles.size() > 0;
    }
}

