/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.settings;

import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import tk.nukeduck.hud.element.settings.ElementSetting;
import tk.nukeduck.hud.element.settings.ElementSettingAbsolutePosition;
import tk.nukeduck.hud.element.settings.ElementSettingAnchor;
import tk.nukeduck.hud.gui.GuiElementSettings;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.Point;

public class ElementSettingAbsolutePositionAnchored
extends ElementSettingAbsolutePosition {
    private Point size;
    private Bounds bounds;
    private final ElementSettingAnchor anchor;

    public ElementSettingAbsolutePositionAnchored(String name, ElementSettingAnchor anchor) {
        super(name);
        this.anchor = anchor;
        ScaledResolution size = new ScaledResolution(Minecraft.func_71410_x());
        this.size = new Point(size.func_78326_a(), size.func_78328_b());
    }

    @Override
    public void actionPerformed(GuiElementSettings gui, GuiButton button) {
        super.actionPerformed(gui, button);
        if (this.isPicking) {
            return;
        }
        ScaledResolution next = new ScaledResolution(Minecraft.func_71410_x());
        this.size.setX(next.func_78326_a());
        this.size.setY(next.func_78328_b());
    }

    @Override
    public void otherAction(Collection<ElementSetting> settings) {
        super.otherAction(settings);
        this.anchor.enabled = this.getEnabled();
    }

    public void update(ScaledResolution next, Bounds bounds) {
        Point p = new Point(next.func_78326_a(), next.func_78328_b());
        if (this.size == null) {
            this.size = p;
        }
        if (this.bounds == null) {
            this.bounds = bounds;
        }
        if (this.size != p) {
            Point p2 = new Point(this.x, this.y);
            p2 = this.anchor.translateAnchor(p2, this.size, p, this.bounds, bounds);
            this.bounds = bounds;
            this.x = p2.getX();
            this.y = p2.getY();
            this.size = p;
            if (this.xBox != null && this.yBox != null) {
                this.updateText();
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.x).append(",").append(this.y);
        if (this.size != null) {
            builder.append(",").append(this.size.getX()).append(",").append(this.size.getY());
        } else {
            builder.append(",").append("-1").append(",").append("-1");
        }
        if (this.bounds != null) {
            builder.append(",").append(this.bounds.getWidth()).append(",").append(this.bounds.getHeight());
        }
        return builder.toString();
    }

    @Override
    public void fromString(String val) {
        if (val.contains(",")) {
            String[] xy = val.split(",");
            if (xy.length >= 6) {
                this.bounds = new Bounds(0, 0, Integer.parseInt(xy[4]), Integer.parseInt(xy[5]));
            }
            if (xy.length >= 4) {
                try {
                    if (xy[2].charAt(0) != '-') {
                        this.size = new Point(Integer.parseInt(xy[2]), Integer.parseInt(xy[3]));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (xy.length >= 2) {
                try {
                    this.x = Integer.parseInt(xy[0]);
                    this.y = Integer.parseInt(xy[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

