/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.settings;

import java.io.IOException;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import tk.nukeduck.hud.element.settings.ElementSetting;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.gui.GuiElementSettings;
import tk.nukeduck.hud.gui.GuiToggleButton;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.Point;
import tk.nukeduck.hud.util.RenderUtil;

public class ElementSettingAnchor
extends ElementSetting {
    public GuiToggleButton topLeft;
    public GuiToggleButton topRight;
    public GuiToggleButton bottomLeft;
    public GuiToggleButton bottomRight;
    private GuiToggleButton[] radios;
    public int lastValue = 0;
    public int value = 0;
    public boolean enabled = true;
    private ElementSettingPosition.Position posValue;

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    private void updatePosValue() {
        int anchorX = 1;
        int anchorY = 1;
        if ((this.value & ElementSettingPosition.Position.TOP_LEFT.getFlag()) == ElementSettingPosition.Position.TOP_LEFT.getFlag()) {
            --anchorX;
            --anchorY;
        }
        if ((this.value & ElementSettingPosition.Position.TOP_RIGHT.getFlag()) == ElementSettingPosition.Position.TOP_RIGHT.getFlag()) {
            ++anchorX;
            --anchorY;
        }
        if ((this.value & ElementSettingPosition.Position.BOTTOM_LEFT.getFlag()) == ElementSettingPosition.Position.BOTTOM_LEFT.getFlag()) {
            --anchorX;
            ++anchorY;
        }
        if ((this.value & ElementSettingPosition.Position.BOTTOM_RIGHT.getFlag()) == ElementSettingPosition.Position.BOTTOM_RIGHT.getFlag()) {
            ++anchorX;
            ++anchorY;
        }
        if (anchorX < 0) {
            anchorX = 0;
        }
        if (anchorX > 2) {
            anchorX = 2;
        }
        if (anchorY < 0) {
            anchorY = 0;
        }
        if (anchorY > 2) {
            anchorY = 2;
        }
        this.posValue = ElementSettingPosition.Position.values()[anchorY * 3 + anchorX];
    }

    public ElementSettingAnchor(String name) {
        super(name);
    }

    public Point translateAnchor(Point pos, Point last, Point next, Bounds oldBounds, Bounds newBounds) {
        int anchorX = 0;
        int anchorY = 0;
        if ((this.value & ElementSettingPosition.Position.TOP_LEFT.getFlag()) == ElementSettingPosition.Position.TOP_LEFT.getFlag()) {
            --anchorX;
            --anchorY;
        }
        if ((this.value & ElementSettingPosition.Position.TOP_RIGHT.getFlag()) == ElementSettingPosition.Position.TOP_RIGHT.getFlag()) {
            ++anchorX;
            --anchorY;
        }
        if ((this.value & ElementSettingPosition.Position.BOTTOM_LEFT.getFlag()) == ElementSettingPosition.Position.BOTTOM_LEFT.getFlag()) {
            --anchorX;
            ++anchorY;
        }
        if ((this.value & ElementSettingPosition.Position.BOTTOM_RIGHT.getFlag()) == ElementSettingPosition.Position.BOTTOM_RIGHT.getFlag()) {
            ++anchorX;
            ++anchorY;
        }
        if (anchorX == 0) {
            pos.setX(pos.getX() + oldBounds.getWidth() / 2);
            pos.setX(pos.getX() * next.getX() / last.getX());
            pos.setX(pos.getX() - newBounds.getWidth() / 2);
        } else if (anchorX > 0) {
            pos.setX(pos.getX() + oldBounds.getWidth());
            pos.setX(pos.getX() - last.getX() + next.getX());
            pos.setX(pos.getX() - newBounds.getWidth());
        }
        if (anchorY == 0) {
            pos.setY(pos.getY() + oldBounds.getHeight() / 2);
            pos.setY(pos.getY() * next.getY() / last.getY());
            pos.setY(pos.getY() - newBounds.getHeight() / 2);
        } else if (anchorY > 0) {
            pos.setY(pos.getY() + oldBounds.getHeight());
            pos.setY(pos.getY() - last.getY() + next.getY());
            pos.setY(pos.getY() - newBounds.getHeight());
        }
        return pos;
    }

    public void updateValue() {
        this.lastValue = this.value;
        this.value = 0;
        for (GuiToggleButton button : this.radios) {
            if (!button.pressed) continue;
            this.value |= ElementSettingPosition.Position.values()[button.field_146127_k].getFlag();
        }
        this.updatePosValue();
    }

    @Override
    public int getGuiHeight() {
        return 42;
    }

    @Override
    public Gui[] getGuiParts(int width, int y) {
        this.topLeft = new GuiToggleButton(ElementSettingPosition.Position.TOP_LEFT.ordinal(), width / 2 - 100, y, 20, 20, "");
        this.topRight = new GuiToggleButton(ElementSettingPosition.Position.TOP_RIGHT.ordinal(), width / 2 - 78, y, 20, 20, "");
        this.bottomLeft = new GuiToggleButton(ElementSettingPosition.Position.BOTTOM_LEFT.ordinal(), width / 2 - 100, y + 22, 20, 20, "");
        this.bottomRight = new GuiToggleButton(ElementSettingPosition.Position.BOTTOM_RIGHT.ordinal(), width / 2 - 78, y + 22, 20, 20, "");
        for (GuiToggleButton button : this.radios = new GuiToggleButton[]{this.topLeft, this.topRight, this.bottomLeft, this.bottomRight}) {
            button.pressed = (ElementSettingPosition.Position.values()[button.field_146127_k].getFlag() & this.value) == ElementSettingPosition.Position.values()[button.field_146127_k].getFlag();
        }
        return this.radios;
    }

    @Override
    public void actionPerformed(GuiElementSettings gui, GuiButton button) {
        ((GuiToggleButton)button).toggle();
        this.updateValue();
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
    }

    @Override
    public void otherAction(Collection<ElementSetting> settings) {
        boolean enabled = this.getEnabled();
        for (GuiToggleButton button : this.radios) {
            button.field_146124_l = enabled;
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void fromString(String val) {
        this.value = Integer.parseInt(val);
    }

    @Override
    public void render(GuiScreen gui, int yScroll) {
        if (this.posValue == null) {
            this.updatePosValue();
        }
        gui.func_73731_b(Minecraft.func_71410_x().field_71466_p, FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), FormatUtil.translatePre("setting." + this.posValue.name, new String[0])), this.topRight.field_146128_h + this.topRight.field_146120_f + 5, this.topRight.field_146129_i + this.topRight.field_146121_g - Minecraft.func_71410_x().field_71466_p.field_78288_b / 2, RenderUtil.colorRGB(255, 255, 255));
    }
}

