/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.settings;

import java.io.IOException;
import java.util.Collection;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import tk.nukeduck.hud.element.settings.ElementSetting;
import tk.nukeduck.hud.gui.GuiElementSettings;
import tk.nukeduck.hud.gui.GuiOptionSliderA;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.FuncsUtil;

public class ElementSettingSlider
extends ElementSetting {
    double minValue = 0.0;
    double maxValue = 1.0;
    public double value = 0.0;
    public double accuracy = -1.0;

    public ElementSettingSlider(String name, double minValue, double maxValue) {
        super(name);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = FuncsUtil.clamp(this.value, minValue, maxValue);
    }

    public double normalize(double value) {
        return (value - this.minValue) / (this.maxValue - this.minValue);
    }

    public double denormalize(double normalized) {
        double toRound = normalized * (this.maxValue - this.minValue) + this.minValue;
        return this.accuracy == -1.0 ? toRound : FuncsUtil.clamp((double)Math.round(toRound / this.accuracy) * this.accuracy, this.minValue, this.maxValue);
    }

    public String getSliderText() {
        return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), String.valueOf(this.value));
    }

    @Override
    public Gui[] getGuiParts(int width, int y) {
        return new Gui[]{new GuiOptionSliderA(0, width / 2 - 100, y, 200, 20, this)};
    }

    @Override
    public void actionPerformed(GuiElementSettings gui, GuiButton button) {
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
    }

    @Override
    public void otherAction(Collection<ElementSetting> settings) {
    }

    @Override
    public void render(GuiScreen gui, int yScroll) {
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void fromString(String val) {
        try {
            this.value = FuncsUtil.clamp(Double.parseDouble(val), this.minValue, this.maxValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

