/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.text;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.settings.ElementSettingBoolean;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.element.text.ExtraGuiElementText;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.PingService;
import tk.nukeduck.hud.util.StringManager;

public class ExtraGuiElementConnection
extends ExtraGuiElementText {
    private ElementSettingBoolean playerCount;
    private ElementSettingBoolean showIp;
    private ElementSettingBoolean latency;
    private String ip = "localServer";
    long lastPing = 0L;

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.playerCount.value = true;
        this.showIp.value = true;
        this.latency.value = true;
    }

    @Override
    public void init() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public String getName() {
        return "connection";
    }

    public ExtraGuiElementConnection() {
        this.settings.add(0, new ElementSettingDivider("position"));
        this.settings.add(new ElementSettingDivider("misc"));
        this.playerCount = new ElementSettingBoolean("playerCount");
        this.settings.add(this.playerCount);
        this.showIp = new ElementSettingBoolean("showIp");
        this.settings.add(this.showIp);
        this.latency = new ElementSettingBoolean("latency");
        this.settings.add(this.latency);
        this.registerUpdates(ExtraGuiElement.UpdateSpeed.SLOW);
    }

    @Override
    public void update(Minecraft mc) {
        if (mc.func_147104_D() != null) {
            new PingService(mc.func_147104_D()).run();
        }
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        if (mc.func_147104_D() != null) {
            this.lastPing = mc.func_147104_D().field_78844_e;
        }
        super.render(mc, resolution, stringManager, layoutManager);
    }

    @SubscribeEvent
    public void networkAction(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        this.ip = !e.isLocal() ? e.getManager().func_74430_c().toString() : "localServer";
    }

    @Override
    public boolean shouldProfile() {
        return this.posMode.index == 1 && (this.playerCount.value || this.showIp.value || this.latency.value);
    }

    @Override
    protected String[] getText(Minecraft mc) {
        ArrayList<String> toRender = new ArrayList<String>();
        if (this.playerCount.value) {
            int players = mc.func_147114_u().func_175106_d().size();
            String conn = players != 1 ? FormatUtil.translatePre("strings.players", String.valueOf(players)) : FormatUtil.translatePre("strings.player", new String[0]);
            toRender.add(conn);
        }
        if (this.showIp.value) {
            toRender.add(this.ip.equals("localServer") ? FormatUtil.translatePre("strings.localServer", new String[0]) : FormatUtil.translatePre("strings.ip", this.ip));
        }
        if (this.latency.value) {
            toRender.add(this.lastPing + "ms");
        }
        return toRender.toArray(new String[toRender.size()]);
    }
}

