/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.text;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import tk.nukeduck.hud.element.settings.ElementSettingBoolean;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.element.settings.ElementSettingSlider;
import tk.nukeduck.hud.element.text.ExtraGuiElementText;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.StringManager;

public class ExtraGuiElementCoordinates
extends ExtraGuiElementText {
    private ElementSettingBoolean spaced;
    private ElementSettingSlider decimalPlaces;
    private String decimalFormat;
    Bounds topBounds = Bounds.EMPTY;

    private void updateDecimalFormat() {
        this.decimalFormat = "%." + (int)this.decimalPlaces.value + "f";
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.pos.value = ElementSettingPosition.Position.TOP_CENTER;
        this.spaced.value = true;
        this.decimalPlaces.value = 0.0;
        this.updateDecimalFormat();
    }

    @Override
    public String getName() {
        return "coordinates";
    }

    public ExtraGuiElementCoordinates() {
        this.settings.add(0, new ElementSettingDivider("position"));
        this.pos.possibleLocations = ElementSettingPosition.Position.combine(ElementSettingPosition.Position.TOP_LEFT, ElementSettingPosition.Position.TOP_CENTER, ElementSettingPosition.Position.TOP_RIGHT, ElementSettingPosition.Position.BOTTOM_LEFT, ElementSettingPosition.Position.BOTTOM_RIGHT);
        this.settings.add(new ElementSettingDivider("misc"));
        this.spaced = new ElementSettingBoolean("spaced");
        this.settings.add(this.spaced);
        this.decimalPlaces = new ElementSettingSlider("decimals", 0.0, 5.0){

            @Override
            public String getSliderText() {
                return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), String.valueOf((int)this.value));
            }
        };
        this.settings.add(this.decimalPlaces);
        this.decimalPlaces.accuracy = 1.0;
    }

    @Override
    public void update(Minecraft mc) {
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        if (this.posMode.index == 0 && this.pos.value == ElementSettingPosition.Position.TOP_CENTER) {
            return this.topBounds;
        }
        return super.getBounds(resolution);
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        if (this.posMode.index == 0 && this.pos.value == ElementSettingPosition.Position.TOP_CENTER) {
            int color = this.getColor();
            if (this.spaced.value) {
                String[] letters = this.getText(mc);
                int spacer = Math.max(Math.max(mc.field_71466_p.func_78256_a(letters[0]), mc.field_71466_p.func_78256_a(letters[1])), mc.field_71466_p.func_78256_a(letters[2])) + 24;
                for (int i = 0; i < 3; ++i) {
                    mc.field_71456_v.func_73732_a(mc.field_71466_p, letters[i], resolution.func_78326_a() / 2 + (i - 1) * spacer, 5, color);
                }
                int strX = resolution.func_78326_a() / 2 - spacer - mc.field_71466_p.func_78256_a(letters[0]) / 2;
                int width = spacer * 2 + (mc.field_71466_p.func_78256_a(letters[0]) + mc.field_71466_p.func_78256_a(letters[2])) / 2;
                this.topBounds = new Bounds(strX, 5, width, mc.field_71466_p.field_78288_b);
            } else {
                String xyz = this.getText(mc)[0];
                int strWidth = mc.field_71466_p.func_78256_a(xyz);
                mc.field_71456_v.func_73732_a(mc.field_71466_p, xyz, resolution.func_78326_a() / 2, 5, color);
                this.topBounds = new Bounds((resolution.func_78326_a() - strWidth) / 2, 5, strWidth, mc.field_71466_p.field_78288_b);
            }
        } else {
            this.topBounds = Bounds.EMPTY;
            super.render(mc, resolution, stringManager, layoutManager);
        }
    }

    @Override
    public boolean shouldProfile() {
        return this.posMode.index == 0 && this.pos.value != ElementSettingPosition.Position.TOP_CENTER;
    }

    @Override
    protected String[] getText(Minecraft mc) {
        this.updateDecimalFormat();
        String x = String.format(this.decimalFormat, mc.field_71439_g.field_70165_t);
        String y = String.format(this.decimalFormat, mc.field_71439_g.field_70163_u);
        String z = String.format(this.decimalFormat, mc.field_71439_g.field_70161_v);
        if (this.spaced.value) {
            x = FormatUtil.translatePre("strings.x", x);
            y = FormatUtil.translatePre("strings.y", y);
            z = FormatUtil.translatePre("strings.z", z);
            return new String[]{x, y, z};
        }
        return new String[]{FormatUtil.translatePre("strings.xyz", x, y, z)};
    }
}

