/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.text;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.RayTraceResult;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.element.settings.ElementSettingMode;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.element.text.ExtraGuiElementText;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.StringManager;

public class ExtraGuiElementDistance
extends ExtraGuiElementText {
    private ElementSettingMode mode;
    private Bounds textBounds = Bounds.EMPTY;

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.pos.value = ElementSettingPosition.Position.MIDDLE_CENTER;
    }

    @Override
    public String getName() {
        return "distance";
    }

    public ExtraGuiElementDistance() {
        this.pos.possibleLocations = ElementSettingPosition.Position.combine(ElementSettingPosition.Position.TOP_LEFT, ElementSettingPosition.Position.TOP_RIGHT, ElementSettingPosition.Position.MIDDLE_CENTER, ElementSettingPosition.Position.BOTTOM_LEFT, ElementSettingPosition.Position.BOTTOM_RIGHT);
        this.settings.add(0, new ElementSettingDivider("position"));
        this.settings.add(new ElementSettingDivider("misc"));
        this.mode = new ElementSettingMode("type", new String[]{"1", "2"});
        this.settings.add(this.mode);
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        if (this.posMode.index == 0 && this.pos.value == ElementSettingPosition.Position.MIDDLE_CENTER) {
            return this.textBounds;
        }
        return super.getBounds(resolution);
    }

    @Override
    public void update(Minecraft mc) {
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        RayTraceResult mop = mc.func_175606_aa().func_174822_a(200.0, 1.0f);
        Block te = mc.field_71441_e.func_180495_p(mop.func_178782_a()).func_177230_c();
        if (te != null && !te.equals(Blocks.field_150350_a)) {
            if (this.posMode.index == 0 && this.pos.value == ElementSettingPosition.Position.MIDDLE_CENTER) {
                String s = this.getText(mc)[0];
                int textWidth = mc.field_71466_p.func_78256_a(s);
                int xPos = resolution.func_78326_a() / 2 - 5 - textWidth;
                int yPos = resolution.func_78328_b() / 2 + 5;
                this.textBounds = new Bounds(xPos, yPos, textWidth, mc.field_71466_p.field_78288_b);
                mc.field_71456_v.func_73731_b(mc.field_71466_p, s, xPos, yPos, this.getColor());
            } else {
                super.render(mc, resolution, stringManager, layoutManager);
            }
        }
    }

    @Override
    public boolean shouldProfile() {
        return true;
    }

    @Override
    protected String[] getText(Minecraft mc) {
        RayTraceResult mop = mc.func_175606_aa().func_174822_a(200.0, 1.0f);
        double x = (double)mop.func_178782_a().func_177958_n() + 0.5 - mc.field_71439_g.field_70165_t;
        double y = (double)mop.func_178782_a().func_177956_o() + 0.5 - mc.field_71439_g.field_70163_u;
        double z = (double)mop.func_178782_a().func_177952_p() + 0.5 - mc.field_71439_g.field_70161_v;
        int distance = (int)Math.round(Math.sqrt(x * x + y * y + z * z));
        return new String[]{FormatUtil.translatePre("strings.distance." + this.mode.getValue(), String.valueOf(distance))};
    }
}

