/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.settings.ElementSetting;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.network.proxy.ClientProxy;
import tk.nukeduck.hud.util.constants.Constants;

public class SettingsIO {
    public static HashMap<String, String> generateKeyVal(ArrayList<String> lines) {
        HashMap<String, String> keyVal = new HashMap<String, String>();
        for (String line : lines) {
            if (!line.contains(":")) continue;
            String[] parts = line.split(":");
            keyVal.put(parts[0], parts[1]);
        }
        return keyVal;
    }

    public static ArrayList<String> generateSrc(ArrayList<ElementSetting> settings) {
        ArrayList<String> lines = new ArrayList<String>();
        for (ElementSetting setting : settings) {
            if (setting instanceof ElementSettingDivider) continue;
            for (String comment : setting.comments) {
                lines.add("\t# " + comment);
            }
            lines.add("\t" + setting.getName() + ":" + setting.toString());
        }
        return lines;
    }

    public static void saveSettings(Logger logger, ClientProxy proxy) {
        try {
            FileWriter writer = new FileWriter(Constants.CONFIG_PATH);
            StringBuilder src = new StringBuilder();
            String[] comments = new String[]{"Better HUD configuration file", "Any removed or corrupted properties will be reverted to default.", new Timestamp(new Date().getTime()).toString()};
            for (String comment : comments) {
                src.append("# ").append(comment).append(Constants.LINE_SEPARATOR);
            }
            for (ExtraGuiElement element : proxy.elements.elements) {
                src.append(element.getName()).append(":").append(Constants.LINE_SEPARATOR);
                src.append("\tenabled").append(":").append(String.valueOf(element.enabled)).append(Constants.LINE_SEPARATOR);
                ArrayList<String> s = SettingsIO.generateSrc(element.settings);
                for (String line : s) {
                    src.append(line).append(Constants.LINE_SEPARATOR);
                }
            }
            src.setLength(src.length() - Constants.LINE_SEPARATOR.length());
            writer.write(src.toString());
            writer.close();
            logger.log(Level.INFO, "Settings have been saved at " + Constants.CONFIG_PATH);
        }
        catch (IOException e) {
            logger.log(Level.WARN, "Failed to save settings to " + Constants.CONFIG_PATH + "." + Constants.LINE_SEPARATOR + e.getMessage());
        }
    }

    public static void loadSettings(Logger logger, ClientProxy proxy) {
        try {
            String line;
            logger.log(Level.INFO, "Loading HUD settings from " + Constants.CONFIG_PATH);
            String currentName = null;
            ArrayList<String> valueLines = new ArrayList<String>();
            HashMap<String, ArrayList<String>> namedSections = new HashMap<String, ArrayList<String>>();
            FileReader reader = new FileReader(Constants.CONFIG_PATH);
            BufferedReader buffer = new BufferedReader(reader);
            while ((line = buffer.readLine()) != null) {
                if (line.trim().startsWith("#") || line.isEmpty()) continue;
                if (line.startsWith("\t")) {
                    valueLines.add(line.substring(1));
                    continue;
                }
                if (currentName != null) {
                    namedSections.put(currentName, valueLines);
                }
                valueLines = new ArrayList();
                currentName = line.substring(0, line.length() - 1);
            }
            namedSections.put(currentName, valueLines);
            for (ExtraGuiElement element : proxy.elements.elements) {
                if (!namedSections.containsKey(element.getName())) continue;
                try {
                    element.loadSettings(SettingsIO.generateKeyVal((ArrayList)namedSections.get(element.getName())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            buffer.close();
            reader.close();
        }
        catch (IOException e) {
            SettingsIO.saveSettings(logger, proxy);
            logger.log(Level.WARN, "Failed to load settings from " + Constants.CONFIG_PATH + "." + Constants.LINE_SEPARATOR + e.getMessage() + Constants.LINE_SEPARATOR + "The default configuration was saved.");
        }
    }
}

