/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.util;

import java.util.ArrayList;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.util.ColoredText;
import tk.nukeduck.hud.util.constants.Colors;

public class StringManager {
    private ArrayList<ColoredText> topLeft = new ArrayList();
    private ArrayList<ColoredText> topRight = new ArrayList();
    private ArrayList<ColoredText> bottomLeft = new ArrayList();
    private ArrayList<ColoredText> bottomRight = new ArrayList();

    public void add(String value, ElementSettingPosition.Position corner) {
        this.add(new ColoredText(value, Colors.WHITE), corner);
    }

    public void add(ColoredText value, ElementSettingPosition.Position corner) {
        switch (corner) {
            case TOP_LEFT: {
                this.topLeft.add(value);
                break;
            }
            case TOP_RIGHT: {
                this.topRight.add(value);
                break;
            }
            case BOTTOM_LEFT: {
                this.bottomLeft.add(value);
                break;
            }
            case BOTTOM_RIGHT: {
                this.bottomRight.add(value);
                break;
            }
        }
    }

    public void add(ElementSettingPosition.Position corner, ColoredText ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.add(values[i], corner);
        }
    }

    public void add(ElementSettingPosition.Position corner, String ... values) {
        this.add(corner, Colors.WHITE, values);
    }

    public void add(ElementSettingPosition.Position corner, int color, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.add(new ColoredText(values[i], color), corner);
        }
    }

    public ArrayList<ColoredText> get(ElementSettingPosition.Position corner) {
        switch (corner) {
            case TOP_LEFT: {
                return this.topLeft;
            }
            case TOP_RIGHT: {
                return this.topRight;
            }
            case BOTTOM_LEFT: {
                return this.bottomLeft;
            }
            case BOTTOM_RIGHT: {
                return this.bottomRight;
            }
        }
        return null;
    }
}

