/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud;

import jobicade.betterhud.geom.LayoutManager;
import jobicade.betterhud.network.InventoryNameQuery;
import jobicade.betterhud.network.MessageNotifyClientHandler;
import jobicade.betterhud.network.MessagePickup;
import jobicade.betterhud.network.MessagePickupHandler;
import jobicade.betterhud.network.MessageVersion;
import jobicade.betterhud.proxy.HudSidedProxy;
import jobicade.betterhud.util.Tickable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IWorldNameable;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="betterhud", name="Better HUD", version="1.4.3", updateJSON="https://raw.githubusercontent.com/mccreery/better-hud/master/update.json", dependencies="required-after:forge@[14.23.1.2557,)", acceptedMinecraftVersions="[1.12.2]")
public class BetterHud {
    public static final String MODID = "betterhud";
    public static final String VERSION = "1.4.3";
    private static ArtifactVersion serverVersion;
    private static Logger logger;
    @SidedProxy(clientSide="jobicade.betterhud.proxy.ClientProxy", serverSide="jobicade.betterhud.proxy.ServerProxy")
    private static HudSidedProxy proxy;
    public static final LayoutManager MANAGER;
    public static final int SPACER = 5;
    public static final SimpleNetworkWrapper NET_WRAPPER;

    public BetterHud() {
        BetterHud.setServerVersion(null);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static HudSidedProxy getProxy() {
        return proxy;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NET_WRAPPER.registerMessage(MessagePickupHandler.class, MessagePickup.class, 1, Side.CLIENT);
        NET_WRAPPER.registerMessage(MessageNotifyClientHandler.class, MessageVersion.class, 2, Side.CLIENT);
        NET_WRAPPER.registerMessage(InventoryNameQuery.ServerHandler.class, InventoryNameQuery.Request.class, 3, Side.SERVER);
        NET_WRAPPER.registerMessage(InventoryNameQuery.ClientHandler.class, InventoryNameQuery.Response.class, 4, Side.CLIENT);
        Tickable.Ticker.registerEvents();
        proxy.init(event);
    }

    @SubscribeEvent
    public static void onPlayerConnected(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            DefaultArtifactVersion version = new DefaultArtifactVersion(VERSION);
            NET_WRAPPER.sendTo((IMessage)new MessageVersion((ArtifactVersion)version), (EntityPlayerMP)e.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        BetterHud.setServerVersion(null);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getWorld().func_175625_s(event.getPos()) instanceof IWorldNameable) {
            NET_WRAPPER.sendToDimension((IMessage)new InventoryNameQuery.Response(event.getPos(), null), event.getWorld().field_73011_w.getDimension());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemPickup(PlayerEvent.ItemPickupEvent e) {
        if (!e.getStack().func_190926_b() && e.player instanceof EntityPlayerMP) {
            NET_WRAPPER.sendTo((IMessage)new MessagePickup(e.getStack()), (EntityPlayerMP)e.player);
        }
    }

    public static void setServerVersion(ArtifactVersion version) {
        serverVersion = version == null ? new DefaultArtifactVersion("") : version;
    }

    public static ArtifactVersion getServerVersion() {
        return serverVersion;
    }

    static {
        MANAGER = new LayoutManager();
        NET_WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
    }
}

