/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.text.TextElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.network.InventoryNameQuery;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;

public class BlockViewer
extends TextElement {
    private SettingBoolean showBlock;
    private SettingBoolean showIds;
    private SettingBoolean invNames;
    private RayTraceResult trace;
    private IBlockState state;
    private ItemStack stack;
    public static final Map<BlockPos, ITextComponent> nameCache = new HashMap<BlockPos, ITextComponent>();

    public BlockViewer() {
        super("blockViewer", new SettingPosition(DirectionOptions.I, DirectionOptions.WEST_EAST));
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        settings.add(new Legend("misc"));
        this.showBlock = new SettingBoolean("showItem").setValuePrefix("betterHud.value.visible");
        settings.add(this.showBlock);
        this.showIds = new SettingBoolean("showIds").setValuePrefix("betterHud.value.visible");
        settings.add(this.showIds);
        this.invNames = new SettingBoolean("invNames"){

            @Override
            public boolean enabled() {
                VersionRange versionRange;
                try {
                    versionRange = VersionRange.createFromVersionSpec((String)"[1.4-beta,)");
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new RuntimeException(e);
                }
                return super.enabled() && versionRange.containsVersion(BetterHud.getServerVersion());
            }
        };
        settings.add(this.invNames);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.NORTH);
        this.showBlock.set(true);
        this.showIds.set(false);
        this.invNames.set(true);
    }

    @Override
    public boolean shouldRender(Event event) {
        if (!super.shouldRender(event)) {
            return false;
        }
        this.trace = Minecraft.func_71410_x().func_175606_aa().func_174822_a((double)HudElement.GLOBAL.getBillboardDistance(), 1.0f);
        if (this.trace != null && this.trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.state = Minecraft.func_71410_x().field_71441_e.func_180495_p(this.trace.func_178782_a());
            this.stack = this.getDisplayStack(this.trace, this.state);
            return true;
        }
        return false;
    }

    @Override
    protected List<String> getText() {
        String text = this.getBlockName(this.trace, this.state, this.stack);
        if (this.showIds.get().booleanValue()) {
            text = text + " " + this.getIdString(this.state);
        }
        return Arrays.asList(text);
    }

    @Override
    protected Rect getPadding() {
        int vPad = 20 - Minecraft.func_71410_x().field_71466_p.field_78288_b;
        int bottom = vPad / 2;
        Rect bounds = Rect.createPadding(5, vPad - bottom, 5, bottom);
        if (this.stack != null && this.showBlock.get().booleanValue()) {
            bounds = this.position.getContentAlignment() == Direction.EAST ? bounds.withRight(bounds.getRight() + 21) : bounds.withLeft(bounds.getLeft() - 21);
        }
        return bounds;
    }

    @Override
    protected void drawBorder(Rect bounds, Rect padding, Rect margin) {
        GlUtil.drawTooltipBox(bounds);
    }

    @Override
    public Rect render(Event event) {
        GlStateManager.func_179097_i();
        return super.render(event);
    }

    @Override
    protected void drawExtras(Rect bounds) {
        if (this.stack != null && this.showBlock.get().booleanValue()) {
            Rect stackRect = new Rect(16, 16).anchor(bounds.grow(-5, -2, -5, -2), this.position.getContentAlignment());
            GlUtil.renderSingleItem(this.stack, stackRect.getPosition());
        }
    }

    @Override
    protected Rect moveRect(Rect bounds) {
        if (this.position.isDirection(Direction.CENTER)) {
            return bounds.align(BetterHud.MANAGER.getScreen().getAnchor(Direction.CENTER).add(0, -5), Direction.SOUTH);
        }
        return super.moveRect(bounds);
    }

    private ItemStack getDisplayStack(RayTraceResult trace, IBlockState state) {
        ItemStack stack = state.func_177230_c().getPickBlock(state, trace, (World)Minecraft.func_71410_x().field_71441_e, trace.func_178782_a(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (BlockViewer.isStackEmpty(stack) && BlockViewer.isStackEmpty(stack = new ItemStack(state.func_177230_c(), state.func_177230_c().func_176201_c(state)))) {
            return null;
        }
        return stack;
    }

    private String getBlockName(RayTraceResult trace, IBlockState state, ItemStack stack) {
        ITextComponent invName;
        TileEntity tileEntity;
        if (state.func_177230_c() == Blocks.field_150384_bq) {
            return I18n.func_135052_a((String)"tile.endPortal.name", (Object[])new Object[0]);
        }
        if (this.invNames.get().booleanValue() && state.func_177230_c().hasTileEntity(state) && (tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(trace.func_178782_a())) instanceof IWorldNameable && (invName = BlockViewer.ensureInvName(trace.func_178782_a())) != null) {
            return invName.func_150254_d();
        }
        return BlockViewer.isStackEmpty(stack) ? state.func_177230_c().func_149732_F() : stack.func_82833_r();
    }

    private String getIdString(IBlockState state) {
        String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString();
        int id = Block.func_149682_b((Block)state.func_177230_c());
        int meta = state.func_177230_c().func_176201_c(state);
        return String.format("%s(%s:%d/#%04d)", ChatFormatting.YELLOW, name, meta, id);
    }

    @SubscribeEvent
    public void onPlayerDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        nameCache.clear();
    }

    @SubscribeEvent
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        nameCache.clear();
    }

    public void onNameReceived(BlockPos pos, ITextComponent name) {
        nameCache.put(pos, name);
    }

    private static ITextComponent ensureInvName(BlockPos pos) {
        ITextComponent name;
        if (!nameCache.containsKey(pos)) {
            BetterHud.NET_WRAPPER.sendToServer((IMessage)new InventoryNameQuery.Request(pos));
            nameCache.put(pos, null);
        }
        if ((name = nameCache.get(pos)) != null) {
            return name;
        }
        return Minecraft.func_71410_x().field_71441_e.func_175625_s(pos).func_145748_c_();
    }

    private static boolean isStackEmpty(ItemStack stack) {
        return stack == null || stack.func_190926_b();
    }
}

